/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Pig;
import org.eclipse.jdt.annotation.Nullable;

public class PigData
extends EntityData<Pig> {
    private int saddled = 0;

    static {
        PigData.register(PigData.class, "pig", Pig.class, 1, "unsaddled pig", "pig", "saddled pig");
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.saddled = matchedPattern - 1;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Pig> c, @Nullable Pig e) {
        this.saddled = e == null ? 0 : (e.hasSaddle() ? 1 : -1);
        return true;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.saddled = Integer.parseInt(s);
            return Math.abs(this.saddled) <= 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void set(Pig entity) {
        if (this.saddled != 0) {
            entity.setSaddle(this.saddled == 1);
        }
    }

    @Override
    protected boolean match(Pig entity) {
        return this.saddled == 0 || entity.hasSaddle() == (this.saddled == 1);
    }

    @Override
    public Class<? extends Pig> getType() {
        return Pig.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof PigData)) {
            return false;
        }
        PigData other = (PigData)obj;
        return other.saddled == this.saddled;
    }

    @Override
    protected int hashCode_i() {
        return this.saddled;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof PigData) {
            return this.saddled == 0 || ((PigData)e).saddled == this.saddled;
        }
        return false;
    }

    @Override
    public EntityData getSuperType() {
        return new PigData();
    }
}

