/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Replace")
@Description(value={"Replaces all occurrences of a given text with another text. Please note that you can only change variables and a few expressions, e.g. a <a href='../expressions/#ExprMessage'>message</a> or a line of a sign.", "Starting with 2.2-dev24, you can replace items in a inventory too."})
@Examples(value={"replace \"<item>\" in {textvar} with \"%item%\"", "replace every \"&\" with \"\u00a7\" in line 1", "# The following acts as a simple chat censor, but it will e.g. censor mass, hassle, assassin, etc. as well:", "on chat:", "\treplace all \"fuck\", \"bitch\" and \"ass\" with \"****\" in the message", " ", "replace all stone and dirt in player's inventory and player's top inventory with diamond"})
@Since(value="2.0, 2.2-dev24 (replace in muliple strings and replace items in inventory)")
public class EffReplace
extends Effect {
    private Expression<?> haystack;
    private Expression<?> needles;
    private Expression<?> replacement;
    private boolean replaceString = true;

    static {
        Skript.registerEffect(EffReplace.class, "replace (all|every|) %strings% in %strings% with %string%", "replace (all|every|) %strings% with %string% in %strings%", "replace (all|every|) %itemstacks% in %inventories% with %itemstack%", "replace (all|every|) %itemstacks% with %itemstack% in %inventories%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.haystack = exprs[1 + matchedPattern % 2];
        boolean bl = this.replaceString = matchedPattern < 2;
        if (this.replaceString && !Changer.ChangerUtils.acceptsChange(this.haystack, Changer.ChangeMode.SET, String.class)) {
            Skript.error(this.haystack + " cannot be changed and can thus not have parts replaced.");
            return false;
        }
        this.needles = exprs[0];
        this.replacement = exprs[2 - matchedPattern % 2];
        return true;
    }

    @Override
    protected void execute(Event e) {
        Object[] haystack = this.haystack.getAll(e);
        ?[] needles = this.needles.getAll(e);
        Object replacement = this.replacement.getSingle(e);
        if (replacement == null || haystack == null || haystack.length == 0 || needles == null || needles.length == 0) {
            return;
        }
        if (this.replaceString) {
            int x = 0;
            while (x < haystack.length) {
                ?[] objArray = needles;
                int n = needles.length;
                int n2 = 0;
                while (n2 < n) {
                    Object n3 = objArray[n2];
                    assert (n3 != null);
                    haystack[x] = StringUtils.replace((String)haystack[x], (String)n3, (String)replacement, SkriptConfig.caseSensitive.value());
                    ++n2;
                }
                ++x;
            }
            this.haystack.change(e, haystack, Changer.ChangeMode.SET);
        } else {
            Inventory[] inventoryArray = (Inventory[])haystack;
            int n = inventoryArray.length;
            int n4 = 0;
            while (n4 < n) {
                Inventory inv = inventoryArray[n4];
                ItemStack[] itemStackArray = (ItemStack[])needles;
                int n5 = itemStackArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    ItemStack item = itemStackArray[n6];
                    for (Integer slot : inv.all(item).keySet()) {
                        inv.setItem(slot.intValue(), (ItemStack)replacement);
                    }
                    ++n6;
                }
                ++n4;
            }
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "replace " + this.needles.toString(e, debug) + " in " + this.haystack.toString(e, debug) + " with " + this.replacement.toString(e, debug);
    }
}

