/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.util.Closeable;
import ch.njol.util.Kleenean;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Log")
@Description(value={"Writes text into a .log file. Skript will write these files to /plugins/Skript/logs.", "NB: Using 'server.log' as the log file will write to the default server log. Omitting the log file altogether will log the message as '[Skript] [&lt;script&gt;.sk] &lt;message&gt;' in the server log."})
@Examples(value={"on place of TNT:", "\tlog \"%player% placed TNT in %world% at %location of block%\" to \"tnt/placement.log\""})
@Since(value="2.0")
public class EffLog
extends Effect {
    private static final File logsFolder;
    static final HashMap<String, PrintWriter> writers;
    private Expression<String> messages;
    @Nullable
    private Expression<String> files;

    static {
        Skript.registerEffect(EffLog.class, "log %strings% [(to|in) [file[s]] %-strings%]");
        logsFolder = new File(Skript.getInstance().getDataFolder(), "logs");
        writers = new HashMap();
        Skript.closeOnDisable(new Closeable(){

            @Override
            public void close() {
                for (PrintWriter pw : writers.values()) {
                    pw.close();
                }
            }
        });
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.messages = exprs[0];
        this.files = exprs[1];
        return true;
    }

    @Override
    protected void execute(Event e) {
        String[] stringArray = this.messages.getArray(e);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (this.files != null) {
                String[] stringArray2 = this.files.getArray(e);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray2[n4];
                    if (!(s = s.toLowerCase()).endsWith(".log")) {
                        s = String.valueOf(s) + ".log";
                    }
                    if (s.equals("server.log")) {
                        SkriptLogger.LOGGER.log(Level.INFO, message);
                    } else {
                        PrintWriter w = writers.get(s);
                        if (w == null) {
                            File f = new File(logsFolder, s);
                            try {
                                f.getParentFile().mkdirs();
                                w = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
                                writers.put(s, w);
                            }
                            catch (IOException ex) {
                                Skript.error("Cannot write to log file '" + s + "' (" + f.getPath() + "): " + ExceptionUtils.toString(ex));
                                return;
                            }
                        }
                        w.println("[" + SkriptConfig.formatDate(System.currentTimeMillis()) + "] " + message);
                        w.flush();
                    }
                    ++n4;
                }
            } else {
                Trigger t = this.getTrigger();
                File script = t == null ? null : t.getScript();
                Skript.info("[" + (script != null ? script.getName() : "---") + "] " + message);
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "log " + this.messages.toString(e, debug) + (this.files != null ? " to " + this.files.toString(e, debug) : "");
    }
}

