/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.aliases.MaterialName;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.validate.SectionValidator;
import ch.njol.skript.localization.ArgsMessage;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.localization.RegexMessage;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.Setter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Aliases {
    private static final boolean newPotions = Skript.isRunningMinecraft(1, 9);
    private static final HashMap<String, ItemType> aliases_english = new HashMap(10000);
    private static final HashMap<String, ItemType> aliases_localised = new HashMap(1000);
    private static final HashMap<Integer, MaterialName> materialNames_english = new HashMap(Material.values().length);
    private static final HashMap<Integer, MaterialName> materialNames_localised = new HashMap(Material.values().length);
    static String itemSingular = "item";
    static String itemPlural = "items";
    @Nullable
    static String itemGender = null;
    static String blockSingular = "block";
    static String blockPlural = "blocks";
    @Nullable
    static String blockGender = null;
    private static final ItemType everything = new ItemType();
    private static final Message m_brackets_error;
    private static final ArgsMessage m_invalid_brackets;
    private static final ArgsMessage m_empty_alias;
    private static final ArgsMessage m_unknown_variation;
    private static final Message m_starting_with_number;
    private static final Message m_missing_aliases;
    private static final Message m_empty_string;
    private static final ArgsMessage m_invalid_item_data;
    private static final ArgsMessage m_invalid_id;
    private static final Message m_invalid_block_data;
    private static final ArgsMessage m_invalid_item_type;
    private static final ArgsMessage m_out_of_data_range;
    private static final Message m_invalid_range;
    private static final ArgsMessage m_invalid_section;
    private static final ArgsMessage m_section_not_found;
    private static final ArgsMessage m_not_a_section;
    private static final Message m_unexpected_non_variation_section;
    private static final Message m_unexpected_section;
    private static final ArgsMessage m_loaded_x_aliases_from;
    private static final ArgsMessage m_loaded_x_aliases;
    private static final Pattern numberWordPattern;
    private static final RegexMessage p_any;
    private static final Message m_any;
    private static final RegexMessage p_every;
    private static final RegexMessage p_of_every;
    private static final RegexMessage p_of;

    static {
        everything.setAll(true);
        everything.add(new ItemData());
        m_brackets_error = new Message("aliases.brackets error");
        m_invalid_brackets = new ArgsMessage("aliases.invalid brackets");
        m_empty_alias = new ArgsMessage("aliases.empty alias");
        m_unknown_variation = new ArgsMessage("aliases.unknown variation");
        m_starting_with_number = new Message("aliases.starting with number");
        m_missing_aliases = new Message("aliases.missing aliases");
        m_empty_string = new Message("aliases.empty string");
        m_invalid_item_data = new ArgsMessage("aliases.invalid item data");
        m_invalid_id = new ArgsMessage("aliases.invalid id");
        m_invalid_block_data = new Message("aliases.invalid block data");
        m_invalid_item_type = new ArgsMessage("aliases.invalid item type");
        m_out_of_data_range = new ArgsMessage("aliases.out of data range");
        m_invalid_range = new Message("aliases.invalid range");
        m_invalid_section = new ArgsMessage("aliases.invalid section");
        m_section_not_found = new ArgsMessage("aliases.section not found");
        m_not_a_section = new ArgsMessage("aliases.not a section");
        m_unexpected_non_variation_section = new Message("aliases.unexpected non-variation section");
        m_unexpected_section = new Message("aliases.unexpected section");
        m_loaded_x_aliases_from = new ArgsMessage("aliases.loaded x aliases from");
        m_loaded_x_aliases = new ArgsMessage("aliases.loaded x aliases");
        numberWordPattern = Pattern.compile("\\d+\\s+.+");
        p_any = new RegexMessage("aliases.any", "", " (.+)", 2);
        m_any = new Message("aliases.any-skp");
        p_every = new RegexMessage("aliases.every", "", " (.+)", 2);
        p_of_every = new RegexMessage("aliases.of every", "(\\d+) ", " (.+)", 2);
        p_of = new RegexMessage("aliases.of", "(\\d+) (?:", " )?(.+)", 2);
    }

    private static final HashMap<String, ItemType> getAliases() {
        return Language.isUsingLocal() ? aliases_localised : aliases_english;
    }

    @Nullable
    private static final ItemType getAlias_i(String s) {
        ItemType t = ScriptLoader.getScriptAliases().get(s);
        if (t != null) {
            return t;
        }
        return Aliases.getAliases().get(s);
    }

    private static final HashMap<Integer, MaterialName> getMaterialNames() {
        return Language.isUsingLocal() ? materialNames_localised : materialNames_english;
    }

    private static int nextBracket(String s, char closingBracket, char openingBracket, int start) {
        int n = 0;
        assert (s.charAt(start) == openingBracket);
        int i = start + 1;
        while (i < s.length()) {
            if (s.charAt(i) == '\\') {
                ++i;
            } else if (s.charAt(i) == closingBracket) {
                if (n == 0) {
                    return i;
                }
                --n;
            } else if (s.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        Skript.error(m_invalid_brackets.toString(String.valueOf(openingBracket) + closingBracket));
        return -1;
    }

    private static final String concatenate(String ... parts) {
        assert (parts.length >= 2);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < parts.length) {
            if (!parts[i].isEmpty()) {
                if (b.length() == 0) {
                    b.append(parts[i]);
                } else {
                    char c = parts[i].charAt(0);
                    if (Character.isUpperCase(c) && b.charAt(b.length() - 1) != ' ') {
                        b.append(String.valueOf(Character.toLowerCase(c)) + parts[i].substring(1));
                    } else {
                        b.append(parts[i]);
                    }
                }
            }
            ++i;
        }
        return b.toString().replace("  ", " ").trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static LinkedHashMap<String, ItemType> getAliases(String name, ItemType value, Variations variations) {
        int end;
        LinkedHashMap<String, ItemType> r = new LinkedHashMap<String, ItemType>();
        if ((name.contains("potion") || name.contains("water bottle") || name.contains("bottle of water")) && newPotions) {
            return r;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if ("[({".indexOf(c) != -1) {
                int end2 = Aliases.nextBracket(name, "])}".charAt("[({".indexOf(c)), c, i);
                if (end2 == -1) {
                    return r;
                }
                if (c == '[') {
                    r.putAll(Aliases.getAliases(Aliases.concatenate(name.substring(0, i), name.substring(i + 1, end2), name.substring(end2 + 1)), value, variations));
                    r.putAll(Aliases.getAliases(Aliases.concatenate(name.substring(0, i), name.substring(end2 + 1)), value, variations));
                    return r;
                }
                if (c != '(') {
                    assert (c == '{');
                } else {
                    int n = 0;
                    int last = i;
                    boolean hasParts = false;
                    int j = i + 1;
                    while (j < end2) {
                        char x = name.charAt(j);
                        if (x == '(') {
                            ++n;
                        } else if (x == ')') {
                            --n;
                        } else if (x == '|' && n <= 0) {
                            hasParts = true;
                            r.putAll(Aliases.getAliases(Aliases.concatenate(name.substring(0, i), name.substring(last + 1, j), name.substring(end2 + 1)), value, variations));
                            last = j;
                        }
                        ++j;
                    }
                    if (!hasParts) {
                        Skript.error(m_brackets_error.toString());
                        return r;
                    }
                    r.putAll(Aliases.getAliases(Aliases.concatenate(name.substring(0, i), name.substring(last + 1, end2), name.substring(end2 + 1)), value, variations));
                    return r;
                }
            }
            ++i;
        }
        i = name.indexOf(123);
        if (i != -1) {
            end = name.indexOf(125, i + 1);
            if (end == -1) {
                assert (false);
                return r;
            }
            String var = name.substring(i + 1, end);
            if (variations.containsKey(var)) {
                boolean hasDefault = false;
                for (Map.Entry v : ((HashMap)variations.get(var)).entrySet()) {
                    String n;
                    if (((String)v.getKey()).equalsIgnoreCase("{default}")) {
                        hasDefault = true;
                        if (v.getValue() == null) continue;
                        n = Aliases.concatenate(name.substring(0, i), name.substring(end + 1));
                    } else {
                        String n0;
                        int c0;
                        int g = ((String)v.getKey()).lastIndexOf(64);
                        n = g == -1 ? Aliases.concatenate(name.substring(0, i), (String)v.getKey(), name.substring(end + 1)) : ((c0 = (n0 = Aliases.concatenate(name.substring(0, i), ((String)v.getKey()).substring(0, g), name.substring(end + 1))).lastIndexOf(64)) == -1 ? n0 : String.valueOf(n0.substring(0, c0).trim()) + ((String)v.getKey()).substring(g));
                    }
                    ItemType t = ((ItemType)v.getValue()).intersection(value);
                    if (t != null) {
                        r.putAll(Aliases.getAliases(n, t, variations));
                        continue;
                    }
                    Skript.warning(m_empty_alias.toString(n));
                }
                if (hasDefault) return r;
                r.putAll(Aliases.getAliases(Aliases.concatenate(name.substring(0, i), name.substring(end + 1)), value, variations));
                return r;
            } else {
                Skript.error(m_unknown_variation.toString(var));
            }
            return r;
        }
        i = name.indexOf(60);
        if (i != -1 && (end = name.indexOf(62, i + 1)) != -1) {
            String[][] os;
            String x = name.substring(i + 1, end);
            if (x.equalsIgnoreCase("any")) {
                String s = String.valueOf(name.substring(0, i)) + m_any.toString() + name.substring(end + 1);
                int g = s.lastIndexOf(64);
                if (g != -1) {
                    s = String.valueOf(s.substring(0, g + 1)) + "-";
                }
                r.putAll(Aliases.getAliases(s, value, variations));
                return r;
            }
            String[][] stringArrayArray = os = new String[][]{{"item", itemSingular, itemPlural, itemGender}, {"block", blockSingular, blockPlural, blockGender}, {"item/block", itemSingular, itemPlural, itemGender, blockSingular, blockPlural, blockGender}, {"block/item", blockSingular, blockPlural, blockGender, itemSingular, itemPlural, itemGender}};
            int n = os.length;
            int n2 = 0;
            while (n2 < n) {
                String[] o = stringArrayArray[n2];
                if (x.equalsIgnoreCase(o[0])) {
                    int j = 1;
                    while (j < o.length) {
                        String s = String.valueOf(name.substring(0, i)) + "\u00a6" + o[j] + "\u00a6" + o[j + 1] + "\u00a6" + name.substring(end + 1);
                        if (o[j + 2] != null) {
                            NonNullPair<String, Integer> p = Noun.stripGender(s, s);
                            s = String.valueOf(p.getFirst()) + "@" + o[j + 2];
                        }
                        r.put(s, value);
                        j += 3;
                    }
                    return r;
                }
                ++n2;
            }
        }
        r.put(name, value);
        r.remove("");
        return r;
    }

    static int addAliases(String name, String value, Variations variations) {
        ItemType t = Aliases.parseAlias(value);
        if (t == null) {
            return 0;
        }
        HashMap<String, ItemType> aliases = Aliases.getAliases();
        LinkedHashMap<String, ItemType> as = Aliases.getAliases(name.replaceAll("\\s+", " "), t, variations);
        boolean printedStartingWithNumberError = false;
        for (Map.Entry e : ((HashMap)as).entrySet()) {
            ItemType alias;
            ItemType si;
            String m;
            String s = ((String)e.getKey()).trim().replaceAll("\\s+", " ");
            NonNullPair<String, Integer> g = Noun.stripGender(s, (String)e.getKey());
            NonNullPair<String, String> p = Noun.getPlural(g.getFirst());
            String lcs = p.getFirst().toLowerCase();
            String lcp = p.getSecond().toLowerCase();
            if (numberWordPattern.matcher(lcs).matches() || numberWordPattern.matcher(lcp).matches()) {
                if (printedStartingWithNumberError) continue;
                Skript.error(m_starting_with_number.toString());
                printedStartingWithNumberError = true;
                continue;
            }
            boolean b = lcs.endsWith(itemSingular);
            if (b || lcp.endsWith(itemPlural)) {
                String string = m = b ? lcs.substring(0, lcs.length() - itemSingular.length()) : lcp.substring(0, lcp.length() - itemPlural.length());
                if (m.endsWith(" ") || m.endsWith("-")) {
                    m = m.substring(0, m.length() - 1);
                }
                if ((si = aliases.get(m)) != null) {
                    si.setItem((ItemType)e.getValue());
                }
                alias = (ItemType)e.getValue();
            } else {
                b = lcs.endsWith(blockSingular);
                if (b || lcp.endsWith(blockPlural)) {
                    String string = m = b ? lcs.substring(0, lcs.length() - blockSingular.length()) : lcp.substring(0, lcp.length() - blockPlural.length());
                    if (m.endsWith(" ") || m.endsWith("-")) {
                        m = m.substring(0, m.length() - 1);
                    }
                    if ((si = aliases.get(m)) != null) {
                        si.setBlock((ItemType)e.getValue());
                    }
                    alias = (ItemType)e.getValue();
                } else {
                    ItemType[] ib = new ItemType[2];
                    String[] ibs = new String[]{itemSingular, blockSingular};
                    String[] seps = new String[]{" ", "", "-"};
                    int i = 0;
                    while (i < ib.length) {
                        String[] stringArray = seps;
                        int n = seps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String sep = stringArray[n2];
                            ib[i] = aliases.get(String.valueOf(lcs) + sep + ibs[i]);
                            if (ib[i] != null) break;
                            ++n2;
                        }
                        ++i;
                    }
                    if (ib[0] == null && ib[1] == null) {
                        alias = (ItemType)e.getValue();
                    } else {
                        alias = ((ItemType)e.getValue()).clone();
                        alias.setItem(ib[0]);
                        alias.setBlock(ib[1]);
                    }
                }
            }
            aliases.put(lcs, alias);
            aliases.put(lcp, alias);
            HashMap<Integer, MaterialName> materialNames = Aliases.getMaterialNames();
            if (alias.getTypes().size() != 1) continue;
            ItemData d = alias.getTypes().get(0);
            MaterialName n = materialNames.get(d.getId());
            if (d.dataMin == -1 && d.dataMax == -1) {
                if (n != null) {
                    if (!n.singular.equals("" + d.getId()) || !n.singular.equals(n.plural)) continue;
                    n.singular = p.getFirst();
                    n.plural = p.getSecond();
                    continue;
                }
                materialNames.put(d.getId(), new MaterialName(d.getId(), p.getFirst(), p.getSecond(), g.getSecond()));
                continue;
            }
            if (n == null) {
                n = new MaterialName(d.getId(), "" + d.getId(), "" + d.getId(), g.getSecond());
                materialNames.put(d.getId(), n);
            }
            NonNullPair<Short, Short> data = new NonNullPair<Short, Short>(d.dataMin, d.dataMax);
            n.names.put(data, p);
        }
        return as.size();
    }

    public static final String getMaterialName(int id, short data, boolean plural) {
        return Aliases.getMaterialName(id, data, data, plural);
    }

    public static final String getDebugMaterialName(int id, short data, boolean plural) {
        return Aliases.getDebugMaterialName(id, data, data, plural);
    }

    public static final String getMaterialName(int id, short dataMin, short dataMax, boolean plural) {
        MaterialName n = Aliases.getMaterialNames().get(id);
        if (n == null) {
            return "" + id;
        }
        return n.toString(dataMin, dataMax, plural);
    }

    public static final String getDebugMaterialName(int id, short dataMin, short dataMax, boolean plural) {
        MaterialName n = Aliases.getMaterialNames().get(id);
        if (n == null) {
            return id + ":" + dataMin + (dataMax == dataMin ? "" : "-" + dataMax);
        }
        return n.getDebugName(dataMin, dataMax, plural);
    }

    public static final int getGender(int id, short dataMin, short dataMax) {
        MaterialName n = Aliases.getMaterialNames().get(id);
        if (n != null) {
            return n.gender;
        }
        return -1;
    }

    static final int addMissingMaterialNames() {
        Object m;
        HashMap<Integer, MaterialName> materialNames = Aliases.getMaterialNames();
        int r = 0;
        StringBuilder missing = new StringBuilder(m_missing_aliases + " ");
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = materialArray[n2];
            if (materialNames.get(m.getId()) == null) {
                materialNames.put(m.getId(), new MaterialName(m.getId(), m.toString().toLowerCase().replace('_', ' '), m.toString().toLowerCase().replace('_', ' '), 0));
                missing.append(String.valueOf(m.getId()) + ", ");
                ++r;
            }
            ++n2;
        }
        m = materialNames.get(-1);
        if (m == null) {
            materialNames.put(-1, new MaterialName(-1, Language.get("aliases.anything"), Language.get("aliases.anything"), 0));
            missing.append("<any>, ");
            ++r;
        }
        if (r > 0) {
            Skript.warning(missing.substring(0, missing.length() - 2));
        }
        return r;
    }

    @Nullable
    public static ItemType parseAlias(String s) {
        String[] types;
        if (s.isEmpty()) {
            Skript.error(m_empty_string.toString());
            return null;
        }
        if (s.equals("*")) {
            return everything;
        }
        ItemType t = new ItemType();
        String[] stringArray = types = s.split("\\s*,\\s*");
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (type == null || Aliases.parseType(type, t, true) == null) {
                return null;
            }
            ++n2;
        }
        return t;
    }

    @Nullable
    public static ItemType parseItemType(String s) {
        if (s.isEmpty()) {
            return null;
        }
        s = s.trim();
        ItemType t = new ItemType();
        Matcher m = p_of_every.matcher(s);
        if (m.matches()) {
            t.setAmount(Utils.parseInt(m.group(1)));
            t.setAll(true);
            s = m.group(m.groupCount());
        } else {
            m = p_of.matcher(s);
            if (m.matches()) {
                t.setAmount(Utils.parseInt(m.group(1)));
                s = m.group(m.groupCount());
            } else {
                m = p_every.matcher(s);
                if (m.matches()) {
                    t.setAll(true);
                    s = m.group(m.groupCount());
                } else {
                    int l = s.length();
                    if ((s = Noun.stripIndefiniteArticle(s)).length() != l) {
                        t.setAmount(1);
                    }
                }
            }
        }
        String lc = s.toLowerCase();
        String of = Language.getSpaced("enchantments.of").toLowerCase();
        int c = -1;
        block3: while ((c = lc.indexOf(of, c + 1)) != -1) {
            String[] enchs;
            ItemType t2 = t.clone();
            BlockingLogHandler log = SkriptLogger.startLogHandler(new BlockingLogHandler());
            try {
                if (Aliases.parseType(s.substring(0, c), t2, false) == null) {
                    continue;
                }
            }
            finally {
                log.stop();
            }
            if (t2.numTypes() == 0) continue;
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            String[] stringArray = enchs = lc.substring(c + of.length(), lc.length()).split("\\s*(,|" + Pattern.quote(Language.get("and")) + ")\\s*");
            int n = enchs.length;
            int n2 = 0;
            while (n2 < n) {
                String ench = stringArray[n2];
                EnchantmentType e = EnchantmentType.parse(ench);
                if (e == null) continue block3;
                enchantments.put(e.getType(), e.getLevel());
                ++n2;
            }
            t2.addEnchantments(enchantments);
            return t2;
        }
        if (Aliases.parseType(s, t, false) == null) {
            return null;
        }
        if (t.numTypes() == 0) {
            return null;
        }
        return t;
    }

    @Nullable
    private static final ItemType parseType(String s, ItemType t, boolean isAlias) {
        int c = s.indexOf(58);
        if (c == -1) {
            c = s.length();
        }
        String type = s.substring(0, c);
        ItemData data = null;
        if (c != s.length() && (data = Aliases.parseData(s.substring(c + 1))) == null) {
            Skript.error(m_invalid_item_data.toString(s.substring(c)));
            return null;
        }
        if (type.isEmpty()) {
            t.add(data == null ? new ItemData() : data);
            return t;
        }
        if (type.matches("\\d+")) {
            ItemData d = new ItemData(Utils.parseInt(type));
            if (Material.getMaterial((int)d.getId()) == null) {
                Skript.error(m_invalid_id.toString(d.getId()));
                return null;
            }
            if (data != null) {
                if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                    Skript.error(m_invalid_block_data.toString());
                    return null;
                }
                d = d.intersection(data);
            }
            if (!isAlias && d != null) {
                Skript.warning("Using an ID instead of an alias is discouraged and will likely not be supported in future versions of Skript anymore. " + (d.toString().equals(type) ? "Please crate an alias for '" + type + (type.equals(s) ? "" : " or '" + s + "'") + "' (" + Material.getMaterial((int)d.getId()).name() + ") in aliases-english.sk or the script's aliases section and use that instead." : "Please replace '" + s + "' with e.g. '" + d.toString(true, false) + "'."));
            }
            t.add(d);
            return t;
        }
        ItemType i = Aliases.getAlias(type);
        if (i != null) {
            for (ItemData d : i) {
                if (data != null) {
                    if (d.getId() <= 255 && (data.dataMax > 15 || data.dataMin > 15)) {
                        Skript.error(m_invalid_block_data.toString());
                        return null;
                    }
                    d = d.intersection(data);
                } else {
                    d = d.clone();
                }
                t.add(d);
            }
            if (data == null) {
                if (i.getItem() != i) {
                    t.setItem(i.getItem().clone());
                }
                if (i.getBlock() != i) {
                    t.setBlock(i.getBlock().clone());
                }
            }
            return t;
        }
        if (isAlias) {
            Skript.error(m_invalid_item_type.toString(s));
        }
        return null;
    }

    @Nullable
    private static final ItemType getAlias(String s) {
        ItemType i;
        String lc = s.toLowerCase();
        Matcher m = p_any.matcher(lc);
        if (m.matches()) {
            lc = m.group(m.groupCount());
        }
        if ((i = Aliases.getAlias_i(lc)) != null) {
            return i.clone();
        }
        boolean b = lc.endsWith(" " + blockSingular);
        if (b || lc.endsWith(" " + blockPlural)) {
            i = Aliases.getAlias_i(s.substring(0, s.length() - (b ? blockSingular.length() : blockPlural.length()) - 1));
            if (i != null) {
                i = i.clone();
                int j = 0;
                while (j < i.numTypes()) {
                    ItemData d = i.getTypes().get(j);
                    if (d.getId() > 255) {
                        i.remove(d);
                        --j;
                    }
                    ++j;
                }
                if (i.getTypes().isEmpty()) {
                    return null;
                }
                return i;
            }
        } else {
            b = lc.endsWith(" " + itemSingular);
            if ((b || lc.endsWith(" " + itemPlural)) && (i = Aliases.getAlias_i(s.substring(0, s.length() - (b ? itemSingular.length() : itemPlural.length()) - 1))) != null) {
                int j = 0;
                while (j < i.numTypes()) {
                    ItemData d = i.getTypes().get(j);
                    if (d.getId() != -1 && d.getId() <= 255) {
                        i.remove(d);
                        --j;
                    }
                    ++j;
                }
                if (i.getTypes().isEmpty()) {
                    return null;
                }
                return i;
            }
        }
        return null;
    }

    @Nullable
    private static final ItemData parseData(String s) {
        if (s.isEmpty()) {
            return new ItemData();
        }
        if (!s.matches("\\d+(-\\d+)?")) {
            return null;
        }
        ItemData t = new ItemData();
        int i = s.indexOf(45);
        if (i == -1) {
            i = s.length();
        }
        try {
            t.dataMin = Short.parseShort(s.substring(0, i));
            t.dataMax = i == s.length() ? t.dataMin : Short.parseShort(s.substring(i + 1, s.length()));
        }
        catch (NumberFormatException e) {
            Skript.error(m_out_of_data_range.toString((short)Short.MAX_VALUE));
            return null;
        }
        if (t.dataMin > t.dataMax) {
            Skript.error(m_invalid_range.toString());
            return null;
        }
        return t;
    }

    public static void clear() {
        aliases_english.clear();
        aliases_localised.clear();
        materialNames_english.clear();
        materialNames_localised.clear();
    }

    public static void load() {
        boolean wasLocal = Language.isUsingLocal();
        try {
            int l = 0;
            while (l < 2) {
                Config aliasConfig;
                Language.setUseLocal(l == 1);
                if (l == 1 && !Language.isUsingLocal()) {
                    break;
                }
                try {
                    File file = new File(Skript.getInstance().getDataFolder(), "aliases-" + Language.getName() + ".sk");
                    if (!file.exists()) {
                        Skript.error("Could not find the " + Language.getName() + " aliases file " + file.getName());
                    }
                    aliasConfig = new Config(file, false, true, "=");
                }
                catch (IOException e) {
                    Skript.error("Could not load the " + Language.getName() + " aliases config: " + e.getLocalizedMessage());
                    Language.setUseLocal(wasLocal);
                    return;
                }
                final ArrayList aliasNodes = new ArrayList();
                aliasConfig.validate(new SectionValidator().addEntry("aliases", new Setter<String>(){

                    @Override
                    public void set(String s) {
                        String[] stringArray = s.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String n3 = stringArray[n2];
                            aliasNodes.add(n3.trim());
                            ++n2;
                        }
                    }
                }, false).addEntry("item", new Setter<String>(){

                    @Override
                    public void set(String s) {
                        NonNullPair<String, Integer> g = Noun.stripGender(s, "item");
                        itemGender = Noun.getGenderID(g.getSecond());
                        NonNullPair<String, String> p = Noun.getPlural(g.getFirst());
                        itemSingular = p.getFirst().toLowerCase();
                        itemPlural = p.getSecond().toLowerCase();
                    }
                }, false).addEntry("block", new Setter<String>(){

                    @Override
                    public void set(String s) {
                        NonNullPair<String, Integer> g = Noun.stripGender(s, "block");
                        blockGender = Noun.getGenderID(g.getSecond());
                        NonNullPair<String, String> p = Noun.getPlural(g.getFirst());
                        blockSingular = p.getFirst().toLowerCase();
                        blockPlural = p.getSecond().toLowerCase();
                    }
                }, false).setAllowUndefinedSections(true));
                for (Node node : aliasConfig.getMainNode()) {
                    if (!(node instanceof SectionNode) || aliasNodes.contains(node.getKey())) continue;
                    Skript.error(m_invalid_section.toString(node.getKey()));
                }
                Variations variations = new Variations();
                int num = 0;
                for (String an : aliasNodes) {
                    Node node = aliasConfig.getMainNode().get(an);
                    SkriptLogger.setNode(node);
                    if (node == null) {
                        Skript.error(m_section_not_found.toString(an));
                        continue;
                    }
                    if (!(node instanceof SectionNode)) {
                        Skript.error(m_not_a_section.toString(an));
                        continue;
                    }
                    int i = 0;
                    for (Node n : (SectionNode)node) {
                        if (n instanceof EntryNode) {
                            i += Aliases.addAliases(((EntryNode)n).getKey(), ((EntryNode)n).getValue(), variations);
                            continue;
                        }
                        if (!(n instanceof SectionNode)) continue;
                        String key = n.getKey();
                        if (key == null) {
                            assert (false);
                            continue;
                        }
                        if (!key.startsWith("{") || !key.endsWith("}")) {
                            Skript.error(m_unexpected_non_variation_section.toString());
                            continue;
                        }
                        HashMap<String, ItemType> vs = new HashMap<String, ItemType>();
                        for (Node a : (SectionNode)n) {
                            ItemType t;
                            if (a instanceof SectionNode) {
                                Skript.error(m_unexpected_section.toString());
                                continue;
                            }
                            if (!(a instanceof EntryNode)) continue;
                            boolean noDefault = ((EntryNode)a).getValue().isEmpty() && ((EntryNode)a).getKey().equalsIgnoreCase("{default}");
                            ItemType itemType = t = noDefault ? null : Aliases.parseAlias(((EntryNode)a).getValue());
                            if (t == null && !noDefault) continue;
                            vs.put(Noun.normalizePluralMarkers(((EntryNode)a).getKey()), t);
                        }
                        variations.put(key.substring(1, key.length() - 1), vs);
                    }
                    if (Skript.logVeryHigh()) {
                        Skript.info(m_loaded_x_aliases_from.toString(i, node.getKey()));
                    }
                    num += i;
                }
                SkriptLogger.setNode(null);
                if (Skript.logNormal()) {
                    Skript.info(m_loaded_x_aliases.toString(num));
                }
                Aliases.addMissingMaterialNames();
                ++l;
            }
        }
        finally {
            Language.setUseLocal(wasLocal);
        }
    }

    static final class Variations
    extends HashMap<String, HashMap<String, ItemType>> {
        private static final long serialVersionUID = -139481665727386819L;

        Variations() {
        }
    }
}

