/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Debuggable;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.util.StringUtils;
import java.io.File;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public abstract class TriggerItem
implements Debuggable {
    @Nullable
    protected TriggerSection parent = null;
    @Nullable
    private TriggerItem next = null;
    private static final String indent = "  ";
    @Nullable
    private String indentation = null;

    protected TriggerItem() {
    }

    protected TriggerItem(TriggerSection parent) {
        this.parent = parent;
    }

    @Nullable
    protected TriggerItem walk(Event e) {
        if (this.run(e)) {
            this.debug(e, true);
            return this.next;
        }
        this.debug(e, false);
        TriggerSection parent = this.parent;
        return parent == null ? null : parent.getNext();
    }

    protected abstract boolean run(Event var1);

    public static final boolean walk(TriggerItem start, Event e) {
        block6: {
            assert (start != null && e != null);
            TriggerItem i = start;
            try {
                while (i != null) {
                    i = i.walk(e);
                }
                return true;
            }
            catch (StackOverflowError err) {
                Trigger t = start.getTrigger();
                File sc = t == null ? null : t.getScript();
                Skript.adminBroadcast("<red>The script '<gold>" + (sc == null ? "<unknown>" : sc.getName()) + "<red>' infinitely (or excessively) repeated itself!");
                if (Skript.debug()) {
                    err.printStackTrace();
                }
            }
            catch (Exception ex) {
                if (ex.getStackTrace().length == 0) break block6;
                Skript.exception((Throwable)ex, i, new String[0]);
            }
        }
        return false;
    }

    public String getIndentation() {
        String ind = this.indentation;
        if (ind == null) {
            int level = 0;
            TriggerItem i = this;
            while ((i = i.parent) != null) {
                ++level;
            }
            this.indentation = ind = StringUtils.multiply(indent, level);
        }
        return ind;
    }

    protected final void debug(Event e, boolean run) {
        if (!Skript.debug()) {
            return;
        }
        Skript.debug(String.valueOf(this.getIndentation()) + (run ? "" : "-") + this.toString(e, true));
    }

    @Override
    public final String toString() {
        return this.toString(null, false);
    }

    public TriggerItem setParent(@Nullable TriggerSection parent) {
        this.parent = parent;
        return this;
    }

    @Nullable
    public final TriggerSection getParent() {
        return this.parent;
    }

    @Nullable
    public final Trigger getTrigger() {
        TriggerItem i = this;
        while (i != null && !(i instanceof Trigger)) {
            i = i.getParent();
        }
        return (Trigger)i;
    }

    public TriggerItem setNext(@Nullable TriggerItem next) {
        this.next = next;
        return this;
    }

    @Nullable
    public TriggerItem getNext() {
        return this.next;
    }
}

