/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.hooks.regions;

import ch.njol.skript.Skript;
import ch.njol.skript.hooks.regions.RegionsPlugin;
import ch.njol.skript.hooks.regions.classes.Region;
import ch.njol.skript.util.AABB;
import ch.njol.skript.variables.Variables;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilID;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

public class WorldGuardHook
extends RegionsPlugin<WorldGuardPlugin> {
    boolean supportsUUIDs;

    static {
        Variables.yggdrasil.registerSingleClass(WorldGuardRegion.class);
    }

    @Override
    protected boolean init() {
        this.supportsUUIDs = Skript.methodExists(DefaultDomain.class, "getUniqueIds", new Class[0]);
        return super.init();
    }

    @Override
    public String getName() {
        return "WorldGuard";
    }

    @Override
    public boolean canBuild_i(Player p, Location l) {
        return ((WorldGuardPlugin)this.plugin).canBuild(p, l);
    }

    @Override
    public Collection<? extends Region> getRegionsAt_i(Location l) {
        ArrayList<WorldGuardRegion> r = new ArrayList<WorldGuardRegion>();
        if (l.getWorld() == null) {
            return Collections.emptyList();
        }
        RegionManager manager = ((WorldGuardPlugin)this.plugin).getRegionManager(l.getWorld());
        if (manager == null) {
            return r;
        }
        ApplicableRegionSet applicable = manager.getApplicableRegions(l);
        if (applicable == null) {
            return r;
        }
        Iterator i = applicable.iterator();
        while (i.hasNext()) {
            r.add(new WorldGuardRegion(l.getWorld(), (ProtectedRegion)i.next()));
        }
        return r;
    }

    @Override
    @Nullable
    public Region getRegion_i(World world, String name) {
        ProtectedRegion r = ((WorldGuardPlugin)this.plugin).getRegionManager(world).getRegion(name);
        if (r != null) {
            return new WorldGuardRegion(world, r);
        }
        return null;
    }

    @Override
    public boolean hasMultipleOwners_i() {
        return true;
    }

    @Override
    protected Class<? extends Region> getRegionClass() {
        return WorldGuardRegion.class;
    }

    @YggdrasilID(value="WorldGuardRegion")
    public final class WorldGuardRegion
    extends Region {
        final World world;
        private transient ProtectedRegion region;

        private WorldGuardRegion() {
            this.world = null;
        }

        public WorldGuardRegion(World w, ProtectedRegion r) {
            this.world = w;
            this.region = r;
        }

        @Override
        public boolean contains(Location l) {
            return l.getWorld().equals(this.world) && this.region.contains(l.getBlockX(), l.getBlockY(), l.getBlockZ());
        }

        @Override
        public boolean isMember(OfflinePlayer p) {
            if (WorldGuardHook.this.supportsUUIDs) {
                return this.region.isMember(((WorldGuardPlugin)WorldGuardHook.this.plugin).wrapOfflinePlayer(p));
            }
            return this.region.isMember(p.getName());
        }

        @Override
        public Collection<OfflinePlayer> getMembers() {
            if (WorldGuardHook.this.supportsUUIDs) {
                Set ids = this.region.getMembers().getUniqueIds();
                ArrayList<OfflinePlayer> r = new ArrayList<OfflinePlayer>(ids.size());
                for (UUID id : ids) {
                    r.add(Bukkit.getOfflinePlayer((UUID)id));
                }
                return r;
            }
            Set ps = this.region.getMembers().getPlayers();
            ArrayList<OfflinePlayer> r = new ArrayList<OfflinePlayer>(ps.size());
            for (String p : ps) {
                r.add(Bukkit.getOfflinePlayer((String)p));
            }
            return r;
        }

        @Override
        public boolean isOwner(OfflinePlayer p) {
            if (WorldGuardHook.this.supportsUUIDs) {
                return this.region.isOwner(((WorldGuardPlugin)WorldGuardHook.this.plugin).wrapOfflinePlayer(p));
            }
            return this.region.isOwner(p.getName());
        }

        @Override
        public Collection<OfflinePlayer> getOwners() {
            if (WorldGuardHook.this.supportsUUIDs) {
                Set ids = this.region.getOwners().getUniqueIds();
                ArrayList<OfflinePlayer> r = new ArrayList<OfflinePlayer>(ids.size());
                for (UUID id : ids) {
                    r.add(Bukkit.getOfflinePlayer((UUID)id));
                }
                return r;
            }
            Set ps = this.region.getOwners().getPlayers();
            ArrayList<OfflinePlayer> r = new ArrayList<OfflinePlayer>(ps.size());
            for (String p : ps) {
                r.add(Bukkit.getOfflinePlayer((String)p));
            }
            return r;
        }

        @Override
        public Iterator<Block> getBlocks() {
            BlockVector min = this.region.getMinimumPoint();
            BlockVector max = this.region.getMaximumPoint();
            return new AABB(this.world, new Vector(min.getBlockX(), min.getBlockY(), min.getBlockZ()), new Vector(max.getBlockX() + 1, max.getBlockY() + 1, max.getBlockZ() + 1)).iterator();
        }

        @Override
        public Fields serialize() throws NotSerializableException {
            Fields f = new Fields(this);
            f.putObject("region", this.region.getId());
            return f;
        }

        @Override
        public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
            String r = fields.getAndRemoveObject("region", String.class);
            fields.setFields(this);
            ProtectedRegion region = ((WorldGuardPlugin)WorldGuardHook.this.plugin).getRegionManager(this.world).getRegion(r);
            if (region == null) {
                throw new StreamCorruptedException("Invalid region " + r + " in world " + this.world);
            }
            this.region = region;
        }

        @Override
        public String toString() {
            return String.valueOf(this.region.getId()) + " in world " + this.world.getName();
        }

        @Override
        public RegionsPlugin<?> getPlugin() {
            return WorldGuardHook.this;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof WorldGuardRegion)) {
                return false;
            }
            return this.world.equals(((WorldGuardRegion)o).world) && this.region.equals((Object)((WorldGuardRegion)o).region);
        }

        @Override
        public int hashCode() {
            return this.world.hashCode() * 31 + this.region.hashCode();
        }
    }
}

