/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Upper/lower Case Text")
@Description(value={"Copy of given text in upper or lower case."})
@Examples(value={"\"oops!\" in upper case # OOPS!"})
@Since(value="2.2-dev16")
public class ExprStringCase
extends SimpleExpression<String> {
    private static final int UPPER = 0;
    private static final int LOWER = 1;
    @Nullable
    private Expression<String> origin;
    @Nullable
    private String literal;
    private int mode;

    static {
        Skript.registerExpression(ExprStringCase.class, String.class, ExpressionType.SIMPLE, "%string% in (0\u00a6upper|1\u00a6lower) case", "capitalized %string%");
    }

    private static String changeCase(@Nullable String str, int mode) {
        if (str == null) {
            return "";
        }
        if (mode == 0) {
            return str.toUpperCase();
        }
        if (mode == 1) {
            return str.toLowerCase();
        }
        return str;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (exprs[0] instanceof Literal) {
            this.literal = (String)((Literal)exprs[0]).getSingle();
        } else {
            this.origin = exprs[0];
        }
        this.mode = matchedPattern == 1 ? 0 : parseResult.mark;
        return true;
    }

    @Nullable
    protected String[] get(Event e) {
        String str = this.literal != null ? ExprStringCase.changeCase(this.literal, this.mode) : (this.origin != null ? ExprStringCase.changeCase(this.origin.getSingle(e), this.mode) : "");
        return new String[]{str};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (this.literal != null) {
            return ExprStringCase.changeCase(this.literal, this.mode);
        }
        if (this.origin != null && e != null) {
            return ExprStringCase.changeCase(this.origin.getSingle(e), this.mode);
        }
        return "";
    }
}

