/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityType;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="X of Item")
@Description(value={"An expression to be able to use a certain amount of items where the amount can be any expression. Please note that is expression is not stable and might be replaced in the future."})
@Examples(value={"give level of player of pickaxes to the player"})
@Since(value="1.2")
public class ExprXOf
extends PropertyExpression<Object, Object> {
    Expression<Number> amount;

    static {
        Skript.registerExpression(ExprXOf.class, Object.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, "%number% of %itemstacks/entitytype%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[1]);
        this.amount = exprs[0];
        return !(this.amount instanceof Literal) || !(this.getExpr() instanceof Literal);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        return this.getExpr().getReturnType();
    }

    @Override
    protected Object[] get(final Event e, Object[] source) {
        return this.get(source, new Converter<Object, Object>(){

            @Override
            @Nullable
            public Object convert(Object o) {
                Number a = ExprXOf.this.amount.getSingle(e);
                if (a == null) {
                    return null;
                }
                if (o instanceof ItemStack) {
                    ItemStack is = ((ItemStack)o).clone();
                    is.setAmount(a.intValue());
                    return is;
                }
                EntityType t = ((EntityType)o).clone();
                t.amount = a.intValue();
                return t;
            }
        });
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.amount.toString(e, debug)) + " of " + this.getExpr().toString(e, debug);
    }
}

