/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault(value=false)
public class DelayedChangeBlock
implements Block {
    final Block b;
    @Nullable
    private final BlockState newState;

    public DelayedChangeBlock(Block b) {
        assert (b != null);
        this.b = b;
        this.newState = null;
    }

    public DelayedChangeBlock(Block b, BlockState newState) {
        assert (b != null);
        this.b = b;
        this.newState = newState;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.b.setMetadata(metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.b.getMetadata(metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.b.hasMetadata(metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.b.removeMetadata(metadataKey, owningPlugin);
    }

    public byte getData() {
        return this.b.getData();
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return this.b.getRelative(modX, modY, modZ);
    }

    public Block getRelative(BlockFace face) {
        return this.b.getRelative(face);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.b.getRelative(face, distance);
    }

    public Material getType() {
        return this.b.getType();
    }

    public int getTypeId() {
        return this.b.getTypeId();
    }

    public byte getLightLevel() {
        return this.b.getLightLevel();
    }

    public byte getLightFromSky() {
        return this.b.getLightFromSky();
    }

    public byte getLightFromBlocks() {
        return this.b.getLightFromBlocks();
    }

    public World getWorld() {
        return this.b.getWorld();
    }

    public int getX() {
        return this.b.getX();
    }

    public int getY() {
        return this.b.getY();
    }

    public int getZ() {
        return this.b.getZ();
    }

    public Location getLocation() {
        return this.b.getLocation();
    }

    public Chunk getChunk() {
        return this.b.getChunk();
    }

    public void setData(final byte data) {
        if (this.newState != null) {
            this.newState.setRawData(data);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    DelayedChangeBlock.this.b.setData(data);
                }
            });
        }
    }

    public void setData(final byte data, final boolean applyPhysics) {
        if (this.newState != null) {
            this.newState.setRawData(data);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    DelayedChangeBlock.this.b.setData(data, applyPhysics);
                }
            });
        }
    }

    public void setType(final Material type) {
        if (this.newState != null) {
            this.newState.setType(type);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

                @Override
                public void run() {
                    DelayedChangeBlock.this.b.setType(type);
                }
            });
        }
    }

    public boolean setTypeId(final int type) {
        BlockState newState = this.newState;
        if (newState != null) {
            newState.setTypeId(type);
            return newState.getTypeId() != this.getTypeId();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.setTypeId(type);
            }
        });
        return true;
    }

    public boolean setTypeId(final int type, final boolean applyPhysics) {
        BlockState newState = this.newState;
        if (newState != null) {
            newState.setTypeId(type);
            return newState.getTypeId() != this.getTypeId();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.setTypeId(type, applyPhysics);
            }
        });
        return true;
    }

    public boolean setTypeIdAndData(final int type, final byte data, final boolean applyPhysics) {
        BlockState newState = this.newState;
        if (newState != null) {
            newState.setTypeId(type);
            newState.setRawData(data);
            return newState.getTypeId() != this.getTypeId() || newState.getRawData() != this.getData();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.setTypeIdAndData(type, data, applyPhysics);
            }
        });
        return true;
    }

    public BlockFace getFace(Block block) {
        return this.b.getFace(block);
    }

    public BlockState getState() {
        return this.b.getState();
    }

    public Biome getBiome() {
        return this.b.getBiome();
    }

    public void setBiome(Biome bio) {
        this.b.setBiome(bio);
    }

    public boolean isBlockPowered() {
        return this.b.isBlockPowered();
    }

    public boolean isBlockIndirectlyPowered() {
        return this.b.isBlockIndirectlyPowered();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.b.isBlockFacePowered(face);
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        return this.b.isBlockFaceIndirectlyPowered(face);
    }

    public int getBlockPower(BlockFace face) {
        return this.b.getBlockPower(face);
    }

    public int getBlockPower() {
        return this.b.getBlockPower();
    }

    public boolean isEmpty() {
        return this.getTypeId() == 0;
    }

    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    public double getTemperature() {
        return this.b.getTemperature();
    }

    public double getHumidity() {
        return this.b.getHumidity();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return this.b.getPistonMoveReaction();
    }

    public boolean breakNaturally() {
        if (this.newState != null) {
            return false;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.breakNaturally();
            }
        });
        return true;
    }

    public boolean breakNaturally(final ItemStack tool) {
        if (this.newState != null) {
            return false;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                DelayedChangeBlock.this.b.breakNaturally(tool);
            }
        });
        return true;
    }

    public Collection<ItemStack> getDrops() {
        return this.b.getDrops();
    }

    public Collection<ItemStack> getDrops(ItemStack tool) {
        return this.b.getDrops(tool);
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.getX());
            loc.setY((double)this.getY());
            loc.setZ((double)this.getZ());
            loc.setPitch(0.0f);
            loc.setYaw(0.0f);
        }
        return loc;
    }

    public void setType(Material arg0, boolean arg1) {
    }
}

