/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.util.NonNullPair;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public class Signature<T> {
    final String script;
    final String name;
    final List<Parameter<?>> parameters;
    @Nullable
    final ClassInfo<T> returnType;
    @Nullable
    final NonNullPair<String, Boolean> info;
    final boolean single;

    public Signature(String script, String name, List<Parameter<?>> parameters, @Nullable ClassInfo<T> returnType, @Nullable NonNullPair<String, Boolean> info, boolean single) {
        this.script = script;
        this.name = name;
        this.parameters = Collections.unmodifiableList(parameters);
        this.returnType = returnType;
        this.info = info;
        this.single = single;
    }

    public String getName() {
        return this.name;
    }

    public Parameter<?> getParameter(int index) {
        return this.parameters.get(index);
    }

    public List<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @Nullable
    public ClassInfo<T> getReturnType() {
        return this.returnType;
    }

    public boolean isSingle() {
        return this.single;
    }

    public int getMaxParameters() {
        return this.parameters.size();
    }

    public int getMinParameters() {
        int i = this.parameters.size() - 1;
        while (i >= 0) {
            if (this.parameters.get((int)i).def == null) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

