/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Functions {
    @Nullable
    public static ScriptFunction<?> currentFunction = null;
    static final Map<String, JavaFunction<?>> javaFunctions = new HashMap();
    static final Map<String, FunctionData> functions = new HashMap<String, FunctionData>();
    static final Map<String, Signature<?>> javaSignatures = new HashMap();
    static final Map<String, Signature<?>> signatures = new HashMap();
    static final List<FunctionReference<?>> postCheckNeeded = new ArrayList();
    public static final String functionNamePattern = "[\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*";
    private static final Pattern functionPattern = Pattern.compile("function ([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)(?: :: (.+))?", 2);
    private static final Pattern paramPattern = Pattern.compile("\\s*(.+?)\\s*:\\s*(.+?)(?:\\s*=\\s*(.+))?\\s*");
    private static final Collection<FunctionReference<?>> toValidate = new ArrayList();

    private Functions() {
    }

    public static final JavaFunction<?> registerFunction(JavaFunction<?> function) {
        Skript.checkAcceptRegistrations();
        if (!function.name.matches(functionNamePattern)) {
            throw new SkriptAPIException("Invalid function name '" + function.name + "'");
        }
        if (functions.containsKey(function.name)) {
            throw new SkriptAPIException("Duplicate function " + function.name);
        }
        functions.put(function.name, new FunctionData(function));
        javaFunctions.put(function.name, function);
        Signature sign = function.getSignature();
        javaSignatures.put(function.name, sign);
        signatures.put(function.name, sign);
        return function;
    }

    static final void registerCaller(FunctionReference<?> r) {
        FunctionData d = functions.get(r.functionName);
        assert (d != null);
        d.calls.add(r);
    }

    @Nullable
    public static final Function<?> loadFunction(SectionNode node) {
        SkriptLogger.setNode(node);
        String definition = node.getKey();
        assert (definition != null);
        Matcher m = functionPattern.matcher(definition);
        if (!m.matches()) {
            return Functions.error("Invalid function definition. Please check for typos and that the function's name only contains letters and underscores. Refer to the documentation for more information.");
        }
        String name = m.group(1);
        Signature<?> sign = signatures.get(name);
        List<Parameter<?>> params = sign.parameters;
        ClassInfo c = sign.returnType;
        NonNullPair<String, Boolean> p = sign.info;
        if (Skript.debug() || node.debug()) {
            Skript.debug("function " + name + "(" + StringUtils.join(params, ", ") + ")" + (c != null && p != null ? " :: " + Utils.toEnglishPlural(c.getCodeName(), p.getSecond()) : "") + ":");
        }
        ScriptFunction f = new ScriptFunction(name, params.toArray(new Parameter[params.size()]), node, c, p == null ? false : p.getSecond() == false);
        return f;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Signature<?> loadSignature(String script, SectionNode node) {
        NonNullPair<String, Boolean> p;
        ClassInfo<?> c;
        SkriptLogger.setNode(node);
        String definition = node.getKey();
        assert (definition != null);
        Matcher m = functionPattern.matcher(definition);
        if (!m.matches()) {
            return Functions.signError("Invalid function definition. Please check for typos and that the function's name only contains letters and underscores. Refer to the documentation for more information.");
        }
        String name = m.group(1);
        String args = m.group(2);
        String returnType = m.group(3);
        ArrayList params = new ArrayList();
        int j = 0;
        int i = 0;
        while (i <= args.length()) {
            if (i == -1) {
                return Functions.signError("Invalid text/variables/parentheses in the arguments of this function");
            }
            if (i == args.length() || args.charAt(i) == ',') {
                void var13_14;
                String arg = args.substring(j, i);
                Matcher n = paramPattern.matcher(arg);
                if (!n.matches()) {
                    return Functions.signError("The " + StringUtils.fancyOrderNumber(params.size() + 1) + " argument's definition is invalid. It should look like 'name: type' or 'name: type = default value'.");
                }
                String paramName = n.group(1);
                for (Parameter parameter : params) {
                    if (!parameter.name.toLowerCase(Locale.ENGLISH).equals(paramName.toLowerCase(Locale.ENGLISH))) continue;
                    return Functions.signError("Each argument's name must be unique, but the name '" + paramName + "' occurs at least twice.");
                }
                ClassInfo<?> classInfo = Classes.getClassInfoFromUserInput(n.group(2));
                NonNullPair<String, Boolean> pl = Utils.getEnglishPlural(n.group(2));
                if (classInfo == null) {
                    ClassInfo<?> classInfo2 = Classes.getClassInfoFromUserInput(pl.getFirst());
                }
                if (var13_14 == null) {
                    return Functions.signError("Cannot recognise the type '" + n.group(2) + "'");
                }
                Parameter p3 = Parameter.newInstance(paramName, var13_14, pl.getSecond() == false, n.group(3));
                if (p3 == null) {
                    return null;
                }
                params.add(p3);
                j = i + 1;
            }
            if (i == args.length()) break;
            i = SkriptParser.next(args, i, ParseContext.DEFAULT);
        }
        if (returnType == null) {
            c = null;
            p = null;
        } else {
            c = Classes.getClassInfoFromUserInput(returnType);
            p = Utils.getEnglishPlural(returnType);
            if (c == null) {
                c = Classes.getClassInfoFromUserInput(p.getFirst());
            }
            if (c == null) {
                return Functions.signError("Cannot recognise the type '" + returnType + "'");
            }
        }
        Signature sign = new Signature(script, name, params, c, p, p == null ? false : p.getSecond() == false);
        signatures.put(name, sign);
        return sign;
    }

    @Nullable
    private static final Function<?> error(String error) {
        Skript.error(error);
        return null;
    }

    @Nullable
    private static final Signature<?> signError(String error) {
        Skript.error(error);
        return null;
    }

    @Nullable
    public static final Function<?> getFunction(String name) {
        FunctionData d = functions.get(name);
        if (d == null) {
            return null;
        }
        return d.function;
    }

    @Nullable
    public static final Signature<?> getSignature(String name) {
        return signatures.get(name);
    }

    public static final int clearFunctions(File script) {
        int r = 0;
        Iterator<FunctionData> iter = functions.values().iterator();
        while (iter.hasNext()) {
            FunctionData d = iter.next();
            if (!(d.function instanceof ScriptFunction) || !script.equals(((ScriptFunction)d.function).trigger.getScript())) continue;
            iter.remove();
            signatures.remove(d.function.name);
            ++r;
            Iterator<FunctionReference<?>> it = d.calls.iterator();
            while (it.hasNext()) {
                FunctionReference<?> c = it.next();
                if (script.equals(c.script)) {
                    it.remove();
                    continue;
                }
                toValidate.add(c);
            }
        }
        return r;
    }

    public static final void validateFunctions() {
        for (FunctionReference<?> c : toValidate) {
            c.validateFunction(false);
        }
        toValidate.clear();
    }

    public static final void clearFunctions() {
        Iterator<FunctionData> iter = functions.values().iterator();
        while (iter.hasNext()) {
            FunctionData d = iter.next();
            if (d.function instanceof ScriptFunction) {
                iter.remove();
                continue;
            }
            d.calls.clear();
        }
        signatures.clear();
        signatures.putAll(javaSignatures);
        assert (toValidate.isEmpty()) : toValidate;
        toValidate.clear();
    }

    public static Iterable<JavaFunction<?>> getJavaFunctions() {
        return javaFunctions.values();
    }

    static final class FunctionData {
        final Function<?> function;
        final Collection<FunctionReference<?>> calls = new ArrayList();

        public FunctionData(Function<?> function) {
            this.function = function;
        }
    }
}

