/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTargetEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Target")
@Description(value={"For players this is the entity at the crosshair, while for mobs and experience orbs it represents the entity they are attacking/following (if any)."})
@Examples(value={"on entity target:", "    entity's target is a player", "    send \"You're being followed by an %entity%!\" to target of entity"})
@Since(value="")
public class ExprTarget
extends PropertyExpression<LivingEntity, Entity> {
    @Nullable
    EntityData<?> type;

    static {
        Skript.registerExpression(ExprTarget.class, Entity.class, ExpressionType.PROPERTY, "[the] target[[ed] %-*entitydata%] [of %livingentities%]", "%livingentities%'[s] target[[ed] %-*entitydata%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.type = exprs[matchedPattern] == null ? null : (EntityData)exprs[matchedPattern].getSingle(null);
        this.setExpr(exprs[1 - matchedPattern]);
        return true;
    }

    protected Entity[] get(final Event e, LivingEntity[] source) {
        return this.get(source, new Converter<LivingEntity, Entity>(){

            @Override
            @Nullable
            public Entity convert(LivingEntity en) {
                if (ExprTarget.this.getTime() >= 0 && e instanceof EntityTargetEvent && en.equals(((EntityTargetEvent)e).getEntity()) && !Delay.isDelayed(e)) {
                    Entity t = ((EntityTargetEvent)e).getTarget();
                    if (t == null || ExprTarget.this.type != null && !ExprTarget.this.type.isInstance(t)) {
                        return null;
                    }
                    return t;
                }
                return Utils.getTarget(en, ExprTarget.this.type);
            }
        });
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.type != null ? this.type.getType() : Entity.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the target" + (this.type == null ? "" : "ed " + this.type) + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(e, debug));
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, EntityTargetEvent.class, this.getExpr());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return CollectionUtils.array(LivingEntity.class);
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            LivingEntity target = delta == null ? null : (LivingEntity)delta[0];
            LivingEntity[] livingEntityArray = (LivingEntity[])this.getExpr().getArray(e);
            int n = livingEntityArray.length;
            int n2 = 0;
            while (n2 < n) {
                LivingEntity entity = livingEntityArray[n2];
                if (this.getTime() >= 0 && e instanceof EntityTargetEvent && entity.equals(((EntityTargetEvent)e).getEntity()) && !Delay.isDelayed(e)) {
                    ((EntityTargetEvent)e).setTarget((Entity)target);
                } else if (entity instanceof Creature) {
                    ((Creature)entity).setTarget(target);
                }
                ++n2;
            }
        } else {
            super.change(e, delta, mode);
        }
    }
}

