/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Speed")
@Description(value={"A player's walking or flying speed. Both can be changed, but values must be between -1 and 1 (excessive values will be changed to -1 or 1 respectively). Negative values reverse directions.", "Please note that changing a player's speed will change his FOV just like potions do."})
@Examples(value={"set the player's walk speed to 1", "increase the argument's fly speed by 0.1"})
@Since(value="")
public class ExprSpeed
extends SimplePropertyExpression<Player, Float> {
    private boolean walk;

    static {
        ExprSpeed.register(ExprSpeed.class, Float.class, "(0\u00a6walk[ing]|1\u00a6fl(y[ing]|ight))[( |-])speed", "players");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!Skript.isRunningMinecraft(1, 4)) {
            Skript.error("fly and walk speed can only be used in Minecraft 1.4 and newer");
            return false;
        }
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.walk = parseResult.mark == 0;
        return true;
    }

    @Override
    public Float convert(Player p) {
        return Float.valueOf(this.walk ? p.getWalkSpeed() : p.getFlySpeed());
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return new Class[]{Number.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        float input = delta == null ? 0.0f : ((Number)delta[0]).floatValue();
        Player[] playerArray = (Player[])this.getExpr().getArray(e);
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            float newSpeed;
            Player p = playerArray[n2];
            float oldSpeed = this.walk ? p.getWalkSpeed() : p.getFlySpeed();
            switch (mode) {
                case SET: {
                    newSpeed = input;
                    break;
                }
                case ADD: {
                    newSpeed = oldSpeed + input;
                    break;
                }
                case REMOVE: {
                    newSpeed = oldSpeed - input;
                    break;
                }
                default: {
                    newSpeed = this.walk ? 0.2f : 0.1f;
                }
            }
            float d = Math2.fit(-1.0f, newSpeed, 1.0f);
            if (this.walk) {
                p.setWalkSpeed(d);
            } else {
                p.setFlySpeed(d);
            }
            ++n2;
        }
    }

    @Override
    public Class<Float> getReturnType() {
        return Float.class;
    }

    @Override
    protected String getPropertyName() {
        return this.walk ? "walk speed" : "fly speed";
    }
}

