/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Checker;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class EvtClick
extends SkriptEvent {
    private static final boolean twoHanded = Skript.isRunningMinecraft(1, 9);
    private static final int RIGHT = 1;
    private static final int LEFT = 2;
    private static final int ANY = 3;
    @Nullable
    private Literal<?> types = null;
    @Nullable
    private Literal<ItemType> tools;
    private int click = 3;

    static {
        Class clickEvent = twoHanded ? PlayerInteractAtEntityEvent.class : PlayerInteractEntityEvent.class;
        Class[] eventTypes = CollectionUtils.array(PlayerInteractEvent.class, clickEvent);
        Skript.registerEvent("Click", EvtClick.class, eventTypes, "[(1\u00a6right|2\u00a6left)(| |-)][mouse(| |-)]click[ing] [on %-entitydata/itemtype%] [(with|using|holding) %itemtype%]", "[(1\u00a6right|2\u00a6left)(| |-)][mouse(| |-)]click[ing] (with|using|holding) %itemtype% on %entitydata/itemtype%").description("Called when a user clicks on a block, an entity or air with or without an item in their hand.", "Please note that rightclick events with an empty hand while not looking at a block are not sent to the server, so there's no way to detect them.").examples("on click", "on rightclick holding a fishing rod", "on leftclick on a stone or obsidian", "on rightclick on a creeper", "on click with a sword").since("1.0");
    }

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        this.click = parser.mark == 0 ? 3 : parser.mark;
        this.types = args[matchedPattern];
        if (this.types != null && !ItemType.class.isAssignableFrom(this.types.getReturnType())) {
            if (this.click == 2) {
                Skript.error("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event.", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            if (this.click == 3) {
                Skript.warning("A leftclick on an entity is an attack and thus not covered by the 'click' event, but the 'damage' event. Change this event to a rightclick to disable this warning message.");
            }
        }
        this.tools = args[1 - matchedPattern];
        return true;
    }

    @Override
    public boolean check(final Event e) {
        Block block;
        Entity entity;
        if (e instanceof PlayerInteractEntityEvent) {
            PlayerInteractEntityEvent clickEvent = (PlayerInteractEntityEvent)e;
            if (twoHanded) {
                Player player = clickEvent.getPlayer();
                assert (player != null);
                boolean useOffHand = EvtClick.checkUseOffHand(player, this.click, null, clickEvent.getRightClicked());
                if (useOffHand && clickEvent.getHand() == EquipmentSlot.HAND || !useOffHand && clickEvent.getHand() == EquipmentSlot.OFF_HAND) {
                    return false;
                }
            }
            if (this.click == 2 || this.types == null) {
                return false;
            }
            entity = clickEvent.getRightClicked();
            block = null;
        } else if (e instanceof PlayerInteractEvent) {
            int click;
            PlayerInteractEvent clickEvent = (PlayerInteractEvent)e;
            if (twoHanded) {
                Player player = clickEvent.getPlayer();
                assert (player != null);
                boolean useOffHand = EvtClick.checkUseOffHand(player, this.click, clickEvent.getClickedBlock(), null);
                if (useOffHand && clickEvent.getHand() == EquipmentSlot.HAND || !useOffHand && clickEvent.getHand() == EquipmentSlot.OFF_HAND) {
                    return false;
                }
            }
            Action a = clickEvent.getAction();
            switch (a) {
                case LEFT_CLICK_BLOCK: 
                case LEFT_CLICK_AIR: {
                    click = 2;
                    break;
                }
                case RIGHT_CLICK_BLOCK: 
                case RIGHT_CLICK_AIR: {
                    click = 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            if ((this.click & click) == 0) {
                return false;
            }
            block = clickEvent.getClickedBlock();
            entity = null;
        } else {
            assert (false);
            return false;
        }
        if (e instanceof PlayerInteractEvent && this.tools != null && !this.tools.check(e, new Checker<ItemType>(){

            @Override
            public boolean check(ItemType t) {
                return t.isOfType(((PlayerInteractEvent)e).getItem());
            }
        })) {
            return false;
        }
        if (this.types != null) {
            return this.types.check(e, new Checker<Object>(){

                @Override
                public boolean check(Object o) {
                    if (entity != null) {
                        return o instanceof EntityData ? ((EntityData)o).isInstance(entity) : Comparator.Relation.EQUAL.is(DefaultComparators.entityItemComparator.compare(EntityData.fromEntity(entity), (ItemType)o));
                    }
                    return o instanceof EntityData ? false : ((ItemType)o).isOfType(block);
                }
            });
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.click == 2 ? "left" : (this.click == 1 ? "right" : "")) + "click" + (this.types != null ? " on " + this.types.toString(e, debug) : "") + (this.tools != null ? " holding " + this.tools.toString(e, debug) : "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkUseOffHand(Player player, int clickType, @Nullable Block block, @Nullable Entity entity) {
        if (clickType != 1) {
            return false;
        }
        boolean mainUsable = false;
        boolean offUsable = false;
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        Material mainMat = mainHand.getType();
        Material offMat = offHand.getType();
        assert (mainMat != null);
        assert (offMat != null);
        switch (offHand.getType()) {
            case IRON_SPADE: 
            case FLINT_AND_STEEL: 
            case BOW: 
            case WOOD_SPADE: 
            case STONE_SPADE: 
            case DIAMOND_SPADE: 
            case GOLD_SPADE: 
            case WOOD_HOE: 
            case STONE_HOE: 
            case IRON_HOE: 
            case DIAMOND_HOE: 
            case GOLD_HOE: 
            case BUCKET: 
            case SNOW_BALL: 
            case EGG: 
            case FISHING_ROD: 
            case SHEARS: 
            case ENDER_PEARL: 
            case MONSTER_EGG: 
            case LEASH: 
            case SPLASH_POTION: 
            case SHIELD: {
                offUsable = true;
                break;
            }
            default: {
                offUsable = false;
            }
        }
        if (offMat.isBlock() && offMat != Material.AIR || PlayerUtils.canEat(player, offMat)) {
            offUsable = true;
        }
        switch (mainHand.getType()) {
            case IRON_SPADE: 
            case FLINT_AND_STEEL: 
            case BOW: 
            case WOOD_SPADE: 
            case STONE_SPADE: 
            case DIAMOND_SPADE: 
            case GOLD_SPADE: 
            case WOOD_HOE: 
            case STONE_HOE: 
            case IRON_HOE: 
            case DIAMOND_HOE: 
            case GOLD_HOE: 
            case BUCKET: 
            case SNOW_BALL: 
            case EGG: 
            case FISHING_ROD: 
            case SHEARS: 
            case ENDER_PEARL: 
            case EYE_OF_ENDER: 
            case MONSTER_EGG: 
            case LEASH: 
            case SPLASH_POTION: {
                mainUsable = true;
                break;
            }
            default: {
                mainUsable = false;
            }
        }
        if (mainMat.isBlock() && mainMat != Material.AIR || PlayerUtils.canEat(player, mainMat)) {
            mainUsable = true;
        }
        boolean blockUsable = false;
        boolean mainOnly = false;
        if (block != null) {
            switch (block.getType()) {
                case DISPENSER: 
                case CHEST: 
                case WORKBENCH: 
                case FURNACE: 
                case SIGN_POST: 
                case WOODEN_DOOR: 
                case WALL_SIGN: 
                case LEVER: 
                case STONE_BUTTON: 
                case TRAP_DOOR: 
                case FENCE_GATE: 
                case ENCHANTMENT_TABLE: 
                case BREWING_STAND: 
                case CAULDRON: 
                case ENDER_CHEST: 
                case COMMAND: 
                case BEACON: 
                case WOOD_BUTTON: 
                case ANVIL: 
                case TRAPPED_CHEST: 
                case HOPPER: 
                case DROPPER: 
                case IRON_TRAPDOOR: 
                case SPRUCE_FENCE_GATE: 
                case BIRCH_FENCE_GATE: 
                case JUNGLE_FENCE_GATE: 
                case DARK_OAK_FENCE_GATE: 
                case ACACIA_FENCE_GATE: 
                case SPRUCE_DOOR: 
                case BIRCH_DOOR: 
                case JUNGLE_DOOR: 
                case ACACIA_DOOR: 
                case DARK_OAK_DOOR: 
                case IRON_DOOR: 
                case BED: 
                case ITEM_FRAME: {
                    blockUsable = true;
                    break;
                }
                case CAKE_BLOCK: {
                    mainOnly = true;
                    break;
                }
                default: {
                    blockUsable = false;
                    break;
                }
            }
        } else if (entity != null) {
            switch (entity.getType()) {
                case ITEM_FRAME: {
                    mainOnly = true;
                    break;
                }
                default: {
                    mainOnly = false;
                }
            }
            if (entity instanceof Vehicle) {
                mainOnly = true;
            }
        }
        boolean isSneaking = player.isSneaking();
        if (blockUsable) {
            if (!isSneaking) return false;
            if (offHand.getType() != Material.AIR) {
                return false;
            }
            if (mainHand.getType() != Material.AIR) {
                return true;
            }
        } else if (mainOnly) {
            return false;
        }
        if (mainUsable) {
            return false;
        }
        if (offUsable) {
            return true;
        }
        if (mainHand.getType() == Material.AIR) return offHand.getType() != Material.AIR;
        return false;
    }
}

