/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Sheep;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Shear")
@Description(value={"Shears or 'un-shears' a sheep. Please note that no wool is dropped, this only sets the 'sheared' state of the sheep."})
@Examples(value={"on rightclick on a sheep holding a sword:", "\tshear the clicked sheep"})
@Since(value="2.0")
public class EffShear
extends Effect {
    private Expression<LivingEntity> sheep;
    private boolean shear;

    static {
        Skript.registerEffect(EffShear.class, "shear %livingentities%", "un[-]shear %livingentities%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.sheep = exprs[0];
        this.shear = matchedPattern == 0;
        return true;
    }

    @Override
    protected void execute(Event e) {
        LivingEntity[] livingEntityArray = this.sheep.getArray(e);
        int n = livingEntityArray.length;
        int n2 = 0;
        while (n2 < n) {
            LivingEntity en = livingEntityArray[n2];
            if (en instanceof Sheep) {
                ((Sheep)en).setSheared(this.shear);
            }
            ++n2;
        }
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.shear ? "" : "un") + "shear " + this.sheep.toString(e, debug);
    }
}

