/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.ClassResolver;
import ch.njol.yggdrasil.DefaultYggdrasilInputStream;
import ch.njol.yggdrasil.DefaultYggdrasilOutputStream;
import ch.njol.yggdrasil.FieldHandler;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.JRESerializer;
import ch.njol.yggdrasil.PseudoEnum;
import ch.njol.yggdrasil.SimpleClassResolver;
import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilID;
import ch.njol.yggdrasil.YggdrasilInputStream;
import ch.njol.yggdrasil.YggdrasilOutputStream;
import ch.njol.yggdrasil.YggdrasilSerializable;
import ch.njol.yggdrasil.YggdrasilSerializer;
import ch.njol.yggdrasil.xml.YggXMLInputStream;
import ch.njol.yggdrasil.xml.YggXMLOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jdt.annotation.Nullable;

@NotThreadSafe
public final class Yggdrasil {
    public static final int MAGIC_NUMBER = 1499948800;
    public static final short LATEST_VERSION = 1;
    public final short version;
    private final List<ClassResolver> classResolvers = new ArrayList<ClassResolver>();
    private final List<FieldHandler> fieldHandlers = new ArrayList<FieldHandler>();
    private final SimpleClassResolver simpleClassResolver = new SimpleClassResolver();

    public Yggdrasil() {
        this(1);
    }

    public Yggdrasil(short version) {
        if (version <= 0 || version > 1) {
            throw new YggdrasilException("Unsupported version number");
        }
        this.version = version;
        this.classResolvers.add(new JRESerializer());
        this.classResolvers.add(this.simpleClassResolver);
    }

    public YggdrasilOutputStream newOutputStream(OutputStream out) throws IOException {
        return new DefaultYggdrasilOutputStream(this, out);
    }

    public YggdrasilInputStream newInputStream(InputStream in) throws IOException {
        return new DefaultYggdrasilInputStream(this, in);
    }

    @Deprecated
    public YggXMLOutputStream newXMLOutputStream(OutputStream out) throws IOException {
        return new YggXMLOutputStream(this, out);
    }

    @Deprecated
    public YggdrasilInputStream newXMLInputStream(InputStream in) throws IOException {
        return new YggXMLInputStream(this, in);
    }

    public void registerClassResolver(ClassResolver r) {
        if (!this.classResolvers.contains(r)) {
            this.classResolvers.add(r);
        }
    }

    public void registerSingleClass(Class<?> c, String id) {
        this.simpleClassResolver.registerClass(c, id);
    }

    public void registerSingleClass(Class<?> c) {
        YggdrasilID id = c.getAnnotation(YggdrasilID.class);
        if (id == null) {
            throw new IllegalArgumentException(c.toString());
        }
        this.simpleClassResolver.registerClass(c, id.value());
    }

    public void registerFieldHandler(FieldHandler h) {
        if (!this.fieldHandlers.contains(h)) {
            this.fieldHandlers.add(h);
        }
    }

    public final boolean isSerializable(Class<?> c) {
        try {
            return c.isPrimitive() || c == Object.class || (Enum.class.isAssignableFrom(c) || PseudoEnum.class.isAssignableFrom(c)) && this.getIDNoError(c) != null || (YggdrasilSerializable.class.isAssignableFrom(c) || this.getSerializer(c) != null) && this.newInstance(c) != c;
        }
        catch (StreamCorruptedException e) {
            return false;
        }
        catch (NotSerializableException e) {
            return false;
        }
    }

    @Nullable
    YggdrasilSerializer<?> getSerializer(Class<?> c) {
        for (ClassResolver r : this.classResolvers) {
            if (!(r instanceof YggdrasilSerializer) || r.getID(c) == null) continue;
            return (YggdrasilSerializer)r;
        }
        return null;
    }

    public Class<?> getClass(String id) throws StreamCorruptedException {
        if ("Object".equals(id)) {
            return Object.class;
        }
        for (ClassResolver r : this.classResolvers) {
            Class<?> c = r.getClass(id);
            if (c == null) continue;
            assert (Tag.byName(id) == null && (Tag.getType(c) == Tag.T_OBJECT || Tag.getType(c) == Tag.T_ENUM)) : "Tag IDs should not be matched: " + id + " (class resolver: " + r + ")";
            assert (id.equals(r.getID(c))) : r + " returned " + c + " for id " + id + ", but returns id " + r.getID(c) + " for that class";
            return c;
        }
        throw new StreamCorruptedException("No class found for ID " + id);
    }

    @Nullable
    private String getIDNoError(Class<?> c) {
        if (c == Object.class) {
            return "Object";
        }
        assert (Tag.getType(c) == Tag.T_OBJECT || Tag.getType(c) == Tag.T_ENUM);
        if (Enum.class.isAssignableFrom(c) && c.getSuperclass() != Enum.class) {
            Class<?> s = c.getSuperclass();
            assert (s != null);
            c = s;
        }
        if (PseudoEnum.class.isAssignableFrom(c)) {
            c = PseudoEnum.getDeclaringClass(c);
        }
        for (ClassResolver r : this.classResolvers) {
            String id = r.getID(c);
            if (id == null) continue;
            assert (Tag.byName(id) == null) : "Class IDs should not match Tag IDs: " + id + " (class resolver: " + r + ")";
            Class<?> c2 = r.getClass(id);
            assert (c2 != null && !(r instanceof YggdrasilSerializer ? !id.equals(r.getID(c2)) : r.getClass(id) != c)) : r + " returned id " + id + " for " + c + ", but returns " + c2 + " for that id";
            return id;
        }
        return null;
    }

    public String getID(Class<?> c) throws NotSerializableException {
        String id = this.getIDNoError(c);
        if (id == null) {
            throw new NotSerializableException("No ID found for " + c);
        }
        if (!this.isSerializable(c)) {
            throw new NotSerializableException(c.getCanonicalName());
        }
        return id;
    }

    public static final String getID(Field f) {
        YggdrasilID yid = f.getAnnotation(YggdrasilID.class);
        if (yid != null) {
            return yid.value();
        }
        return f.getName();
    }

    public static final String getID(Enum<?> e) {
        try {
            return Yggdrasil.getID(e.getDeclaringClass().getDeclaredField(e.name()));
        }
        catch (NoSuchFieldException ex) {
            assert (false) : e;
            return e.name();
        }
    }

    public static final <T extends Enum<T>> Enum<T> getEnumConstant(Class<T> c, String id) throws StreamCorruptedException {
        Field[] fields;
        Field[] fieldArray = fields = c.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            assert (f != null);
            if (Yggdrasil.getID(f).equals(id)) {
                return Enum.valueOf(c, f.getName());
            }
            ++n2;
        }
        if (YggdrasilSerializable.YggdrasilRobustEnum.class.isAssignableFrom(c)) {
            T[] cs = c.getEnumConstants();
            if (cs.length == 0) {
                throw new StreamCorruptedException(c + " does not have any enum constants");
            }
            Enum<?> e = ((YggdrasilSerializable.YggdrasilRobustEnum)cs[0]).excessiveConstant(id);
            if (e == null) {
                throw new YggdrasilException("YggdrasilRobustEnum " + c + " returned null from excessiveConstant(" + id + ")");
            }
            if (!c.isInstance(e)) {
                throw new YggdrasilException(c + " returned a foreign enum constant: " + e.getClass() + "." + e);
            }
            return e;
        }
        throw new StreamCorruptedException("Enum constant " + id + " does not exist in " + c);
    }

    public void excessiveField(Object o, Fields.FieldContext field) throws StreamCorruptedException {
        for (FieldHandler h : this.fieldHandlers) {
            if (!h.excessiveField(o, field)) continue;
            return;
        }
        throw new StreamCorruptedException("Excessive field " + field.id + " in class " + o.getClass().getCanonicalName() + " was not handled");
    }

    public void missingField(Object o, Field f) throws StreamCorruptedException {
        for (FieldHandler h : this.fieldHandlers) {
            if (!h.missingField(o, f)) continue;
            return;
        }
        throw new StreamCorruptedException("Missing field " + Yggdrasil.getID(f) + " in class " + o.getClass().getCanonicalName() + " was not handled");
    }

    public void incompatibleField(Object o, Field f, Fields.FieldContext field) throws StreamCorruptedException {
        for (FieldHandler h : this.fieldHandlers) {
            if (!h.incompatibleField(o, f, field)) continue;
            return;
        }
        throw new StreamCorruptedException("Incompatible field " + Yggdrasil.getID(f) + " in class " + o.getClass().getCanonicalName() + " of incompatible " + field.getType() + " was not handled");
    }

    public void saveToFile(Object o, File f) throws IOException {
        FileOutputStream fout = null;
        Closeable yout = null;
        try {
            fout = new FileOutputStream(f);
            yout = this.newOutputStream(fout);
            ((YggdrasilOutputStream)yout).writeObject(o);
            yout.flush();
        }
        finally {
            if (yout != null) {
                yout.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    @Nullable
    public <T> T loadFromFile(File f, Class<T> expectedType) throws IOException {
        FileInputStream fin = null;
        Closeable yin = null;
        try {
            fin = new FileInputStream(f);
            yin = this.newInputStream(fin);
            T t = ((YggdrasilInputStream)yin).readObject(expectedType);
            return t;
        }
        finally {
            if (yin != null) {
                yin.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    @Nullable
    final Object newInstance(Class<?> c) throws StreamCorruptedException, NotSerializableException {
        YggdrasilSerializer<?> s = this.getSerializer(c);
        if (s != null) {
            if (!s.canBeInstantiated(c)) {
                block15: {
                    try {
                        Object o = s.deserialize(c, new Fields(this));
                        if (o == null) break block15;
                        return null;
                    }
                    catch (StreamCorruptedException e) {
                        return null;
                    }
                }
                throw new YggdrasilException("YggdrasilSerializer " + s + " returned null from deserialize(" + c + ", new Fields())");
            }
            Object o = s.newInstance(c);
            if (o == null) {
                throw new YggdrasilException("YggdrasilSerializer " + s + " returned null from newInstance(" + c + ")");
            }
            return o;
        }
        try {
            Constructor<?> constr = c.getDeclaredConstructor(new Class[0]);
            constr.setAccessible(true);
            return constr.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new StreamCorruptedException("Cannot create an instance of " + c + " because it has no nullary constructor");
        }
        catch (SecurityException e) {
            throw new StreamCorruptedException("Cannot create an instance of " + c + " because the security manager didn't allow it");
        }
        catch (InstantiationException e) {
            throw new StreamCorruptedException("Cannot create an instance of " + c + " because it is abstract");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        System.err.println("Command line not supported yet");
        System.exit(1);
    }
}

