/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.SkriptConfig;
import ch.njol.skript.util.Timespan;
import ch.njol.yggdrasil.YggdrasilSerializable;
import org.eclipse.jdt.annotation.Nullable;

public class Date
implements Comparable<Date>,
YggdrasilSerializable {
    private long timestamp;

    public Date() {
        this.timestamp = System.currentTimeMillis();
    }

    public Date(long timestamp) {
        this.timestamp = timestamp;
    }

    public Timespan difference(Date other) {
        return new Timespan(Math.abs(this.timestamp - other.timestamp));
    }

    @Override
    public int compareTo(@Nullable Date other) {
        long d;
        long l = d = other == null ? this.timestamp : this.timestamp - other.timestamp;
        return d < 0L ? -1 : (d > 0L ? 1 : 0);
    }

    public String toString() {
        return SkriptConfig.formatDate(this.timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void add(Timespan span) {
        this.timestamp += span.getMilliSeconds();
    }

    public void subtract(Timespan span) {
        this.timestamp -= span.getMilliSeconds();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Date)) {
            return false;
        }
        Date other = (Date)obj;
        return this.timestamp == other.timestamp;
    }
}

