/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.util.SimpleEvent;
import ch.njol.skript.variables.Variables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptFunction<T>
extends Function<T> {
    final Trigger trigger;
    private boolean returnValueSet = false;
    @Nullable
    private T[] returnValue = null;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public ScriptFunction(String name, Parameter<?>[] parameters, SectionNode node, @Nullable ClassInfo<T> returnType, boolean single) {
        super(name, parameters, returnType, single);
        Functions.functions.put(name, new Functions.FunctionData(this));
        Functions.currentFunction = this;
        try {
            this.trigger = new Trigger(node.getConfig().getFile(), "function " + name, new SimpleEvent(), ScriptLoader.loadItems(node));
        }
        finally {
            Functions.currentFunction = null;
        }
    }

    public final void setReturnValue(FunctionEvent e, @Nullable T[] value) {
        assert (!this.returnValueSet);
        this.returnValueSet = true;
        this.returnValue = value;
    }

    @Override
    @Nullable
    public T[] execute(FunctionEvent e, Object[][] params) {
        int i = 0;
        while (i < this.parameters.length) {
            Parameter p = this.parameters[i];
            Object[] val = params[i];
            if (p.single) {
                Variables.setVariable(p.name, val[0], e, true);
            } else {
                int j = 0;
                while (j < val.length) {
                    Variables.setVariable(String.valueOf(p.name) + "::" + (j + 1), val[j], e, true);
                    ++j;
                }
            }
            ++i;
        }
        this.trigger.execute(e);
        this.returnValueSet = false;
        return this.returnValue;
    }
}

