/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Direction;
import ch.njol.skript.util.Utils;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.material.Directional;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BlockUtils {
    private static final BlockFace[] torch;
    private static final BlockFace[] button;
    private static final BlockFace[] ladder;
    private static final BlockFace[] wallSign;
    private static final BlockFace[] trapdoor;
    private static final BlockFace[] lever;
    private static final BlockFace[] cocoa;
    private static final BlockFace[] tripwireHook;
    private static final BlockFace[][] attached;
    private static final BlockFace[] bed;
    private static final BlockFace[] gate;
    private static final int[] solid;
    private static final boolean[] isSolid;

    static {
        BlockFace[] blockFaceArray = new BlockFace[6];
        blockFaceArray[1] = BlockFace.WEST;
        blockFaceArray[2] = BlockFace.EAST;
        blockFaceArray[3] = BlockFace.NORTH;
        blockFaceArray[4] = BlockFace.SOUTH;
        blockFaceArray[5] = BlockFace.DOWN;
        torch = blockFaceArray;
        BlockFace[] blockFaceArray2 = new BlockFace[13];
        blockFaceArray2[1] = BlockFace.WEST;
        blockFaceArray2[2] = BlockFace.EAST;
        blockFaceArray2[3] = BlockFace.NORTH;
        blockFaceArray2[4] = BlockFace.SOUTH;
        blockFaceArray2[9] = BlockFace.WEST;
        blockFaceArray2[10] = BlockFace.EAST;
        blockFaceArray2[11] = BlockFace.NORTH;
        blockFaceArray2[12] = BlockFace.SOUTH;
        button = blockFaceArray2;
        BlockFace[] blockFaceArray3 = new BlockFace[6];
        blockFaceArray3[2] = BlockFace.SOUTH;
        blockFaceArray3[3] = BlockFace.NORTH;
        blockFaceArray3[4] = BlockFace.EAST;
        blockFaceArray3[5] = BlockFace.WEST;
        ladder = blockFaceArray3;
        wallSign = ladder;
        trapdoor = new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST};
        lever = new BlockFace[]{BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN, BlockFace.DOWN, BlockFace.UP, BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN, BlockFace.DOWN, BlockFace.UP};
        cocoa = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
        tripwireHook = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        attached = new BlockFace[256][];
        BlockUtils.attached[Material.TORCH.getId()] = torch;
        BlockUtils.attached[Material.STONE_BUTTON.getId()] = button;
        BlockUtils.attached[Material.LADDER.getId()] = ladder;
        BlockUtils.attached[Material.WALL_SIGN.getId()] = wallSign;
        BlockUtils.attached[Material.TRAP_DOOR.getId()] = trapdoor;
        BlockUtils.attached[Material.LEVER.getId()] = lever;
        if (Skript.fieldExists(Material.class, "COCOA")) {
            BlockUtils.attached[Material.COCOA.getId()] = cocoa;
            BlockUtils.attached[Material.TRIPWIRE_HOOK.getId()] = tripwireHook;
        }
        if (Skript.fieldExists(Material.class, "WOOD_BUTTON")) {
            BlockUtils.attached[Material.WOOD_BUTTON.getId()] = button;
        }
        bed = new BlockFace[]{BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.EAST};
        gate = new BlockFace[]{BlockFace.WEST, BlockFace.NORTH};
        solid = new int[]{1, 2, 3, 4, 5, 7, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 29, 33, 35, 41, 42, 43, 45, 46, 47, 48, 49, 52, 54, 56, 57, 58, 60, 61, 62, 73, 74, 79, 80, 82, 84, 86, 87, 88, 89, 91, 95, 97, 98, 99, 100, 103, 110, 112, 120, 121, 123, 124, 125, 129, 130, 133, 137, 138, 146, 152, 153, 155, 158, 159, 161, 162, 170, 172, 173, 174};
        isSolid = new boolean[256];
        int[] nArray = solid;
        int n = solid.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            BlockUtils.isSolid[i] = true;
            ++n2;
        }
    }

    public static boolean set(Block b, int type, byte dataMin, byte dataMax, boolean applyPhysics) {
        boolean any;
        boolean bl = any = dataMin == -1 && dataMax == -1;
        if (dataMin == -1) {
            dataMin = 0;
        }
        if (dataMax == -1) {
            dataMax = (byte)15;
        }
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException("Invalid block type id " + type);
        }
        if (dataMin < 0 || dataMin > dataMax || dataMax > 15) {
            throw new IllegalArgumentException("Invalid data range " + dataMin + " to " + dataMax);
        }
        BlockFace[] attach = attached[type];
        if (attach != null) {
            BlockFace f;
            byte data;
            int n;
            int n2;
            byte[] byArray;
            if (dataMin >= attach.length) {
                b.setTypeIdAndData(type, (byte)Utils.random(dataMin, dataMax + 1), applyPhysics);
                return true;
            }
            if (CollectionUtils.indexOf(attach, BlockFace.DOWN, (int)dataMin, (int)(dataMax = (byte)Math.min(dataMax, attach.length - 1))) != -1 && BlockUtils.isSolid(b.getRelative(BlockFace.DOWN).getTypeId())) {
                byArray = CollectionUtils.permutation(dataMin, dataMax);
                n2 = byArray.length;
                n = 0;
                while (n < n2) {
                    data = byArray[n];
                    if (attach[data] == BlockFace.DOWN) {
                        b.setTypeIdAndData(type, data, applyPhysics);
                        return true;
                    }
                    ++n;
                }
                assert (false);
            }
            byArray = CollectionUtils.permutation(dataMin, dataMax);
            n2 = byArray.length;
            n = 0;
            while (n < n2) {
                data = byArray[n];
                f = attach[data];
                if (f != null && BlockUtils.isSolid(b.getRelative(f).getTypeId())) {
                    b.setTypeIdAndData(type, data, applyPhysics);
                    return true;
                }
                ++n;
            }
            if (CollectionUtils.indexOf(attach, BlockFace.DOWN, (int)dataMin, (int)dataMax) != -1 && b.getRelative(BlockFace.DOWN).getType() != Material.AIR) {
                byArray = CollectionUtils.permutation(dataMin, dataMax);
                n2 = byArray.length;
                n = 0;
                while (n < n2) {
                    data = byArray[n];
                    if (attach[data] == BlockFace.DOWN) {
                        b.setTypeIdAndData(type, data, applyPhysics);
                        return true;
                    }
                    ++n;
                }
                assert (false);
            }
            byArray = CollectionUtils.permutation(dataMin, dataMax);
            n2 = byArray.length;
            n = 0;
            while (n < n2) {
                data = byArray[n];
                f = attach[data];
                if (f != null && b.getRelative(f).getType() != Material.AIR) {
                    b.setTypeIdAndData(type, data, applyPhysics);
                    return true;
                }
                ++n;
            }
            b.setTypeIdAndData(type, (byte)Utils.random(dataMin, dataMax + 1), applyPhysics);
            return true;
        }
        if (type == Material.IRON_DOOR_BLOCK.getId() || type == Material.WOODEN_DOOR.getId()) {
            int up = b.getRelative(BlockFace.UP).getTypeId();
            int down = b.getRelative(BlockFace.DOWN).getTypeId();
            if (up == 0 || up == type && b.getRelative(BlockFace.UP).getData() >= 8) {
                if (dataMin >= 8) {
                    return false;
                }
                if (!BlockUtils.isSolid(down)) {
                    return false;
                }
                dataMax = (byte)Math.min(dataMax, 8);
                byte data = (byte)Utils.random(dataMin, dataMax + 1);
                if (up != type) {
                    b.getRelative(BlockFace.UP).setTypeIdAndData(type, (byte)8, false);
                }
                b.setTypeIdAndData(type, data, applyPhysics);
                return true;
            }
            if (down == 0 || down == type && b.getRelative(BlockFace.DOWN).getData() < 8) {
                if (dataMax < 8) {
                    return false;
                }
                if (!BlockUtils.isSolid(b.getRelative(BlockFace.DOWN, 2).getTypeId())) {
                    return false;
                }
                dataMin = (byte)Math.max(dataMin, 8);
                byte data = (byte)Utils.random(dataMin, dataMax + 1);
                if (down != type) {
                    b.getRelative(BlockFace.DOWN).setTypeIdAndData(type, (byte)0, false);
                }
                b.setTypeIdAndData(type, data, applyPhysics);
                return true;
            }
            return false;
        }
        if (type == Material.BED_BLOCK.getId()) {
            byte[] byArray = CollectionUtils.permutation(dataMin, dataMax);
            int n = byArray.length;
            int down = 0;
            while (down < n) {
                byte data = byArray[down];
                boolean head = (data & 8) == 8;
                BlockFace f = bed[data & 3];
                if (head) {
                    if (b.getRelative(f, -1).getTypeId() == 0) {
                        b.getRelative(f, -1).setTypeIdAndData(type, (byte)(data & 0xFFFFFFF7), false);
                        b.setTypeIdAndData(type, data, applyPhysics);
                        return true;
                    }
                } else if (b.getRelative(f).getTypeId() == 0) {
                    b.getRelative(f).setTypeIdAndData(type, (byte)(data | 8), false);
                    b.setTypeIdAndData(type, data, applyPhysics);
                    return true;
                }
                ++down;
            }
            return false;
        }
        if (type == Material.FENCE_GATE.getId()) {
            boolean[] tried = new boolean[gate.length];
            byte[] byArray = CollectionUtils.permutation(dataMin, dataMax);
            int n = byArray.length;
            int n3 = 0;
            while (n3 < n) {
                byte data = byArray[n3];
                if (!tried[data & 1]) {
                    BlockFace f = gate[data & 1];
                    Block b1 = b.getRelative(f);
                    Block b2 = b.getRelative(f, -1);
                    int m1 = b1.getTypeId();
                    int m2 = b2.getTypeId();
                    if ((m1 == Material.FENCE.getId() || m1 == 113 || m1 == Material.FENCE_GATE.getId() && (b1.getData() & 1) == (data & 1)) && (m2 == Material.FENCE.getId() || m2 == 113 || m2 == Material.FENCE_GATE.getId() && (b2.getData() & 1) == (data & 1))) {
                        b.setTypeIdAndData(type, data, applyPhysics);
                        return true;
                    }
                    tried[data & 1] = true;
                }
                ++n3;
            }
            b.setTypeIdAndData(type, (byte)Utils.random(dataMin, dataMax + 1), applyPhysics);
            return true;
        }
        if (type == 175 && b.getRelative(BlockFace.UP).getType() == Material.AIR) {
            byte data = (byte)Utils.random(dataMin, dataMax + 1);
            b.getRelative(BlockFace.UP).setTypeIdAndData(type, (byte)(data | 4), false);
            b.setTypeIdAndData(type, (byte)(data & 0xFFFFFFFB), applyPhysics);
            return true;
        }
        b.setTypeIdAndData(type, any ? (byte)0 : (byte)Utils.random(dataMin, dataMax + 1), applyPhysics);
        return true;
    }

    public static final boolean isSolid(int type) {
        if (type < 0 || type >= isSolid.length) {
            throw new IllegalArgumentException(String.valueOf(type) + " is not a block id");
        }
        return isSolid[type];
    }

    public static Iterable<Block> getBlocksAround(Block b) {
        return Arrays.asList(b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.SOUTH), b.getRelative(BlockFace.WEST));
    }

    public static Iterable<BlockFace> getFaces() {
        return Arrays.asList(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST);
    }

    @Nullable
    public static Location getLocation(@Nullable Block b) {
        if (b == null) {
            return null;
        }
        Location l = b.getLocation().add(0.5, 0.5, 0.5);
        Material m = b.getType();
        if (Directional.class.isAssignableFrom(m.getData())) {
            BlockFace f = ((Directional)m.getNewData(b.getData())).getFacing();
            l.setPitch(Direction.getPitch(Math.sin(f.getModY())));
            l.setYaw(Direction.getYaw(Math.atan2(f.getModZ(), f.getModX())));
        }
        return l;
    }
}

