/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.log;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.eclipse.jdt.annotation.Nullable;

public class ParseLogHandler
extends LogHandler {
    @Nullable
    private LogEntry error = null;
    private final List<LogEntry> log = new ArrayList<LogEntry>();
    boolean printedErrorOrLog = false;

    @Override
    public LogHandler.LogResult log(LogEntry entry) {
        if (entry.getLevel().intValue() >= Level.SEVERE.intValue()) {
            LogEntry e = this.error;
            if (e == null || entry.getQuality() > e.getQuality()) {
                this.error = entry;
                if (e != null) {
                    e.discarded("overridden by '" + entry.getMessage() + "' (" + (Object)((Object)ErrorQuality.get(entry.getQuality())) + " > " + (Object)((Object)ErrorQuality.get(e.getQuality())) + ")");
                }
            }
        } else {
            this.log.add(entry);
        }
        return LogHandler.LogResult.CACHED;
    }

    @Override
    public void onStop() {
        if (!this.printedErrorOrLog && Skript.testing()) {
            SkriptLogger.LOGGER.warning("Parse log wasn't instructed to print anything at " + SkriptLogger.getCaller());
        }
    }

    public void error(String error, ErrorQuality quality) {
        this.log(new LogEntry(SkriptLogger.SEVERE, quality, error));
    }

    public void clear() {
        for (LogEntry e : this.log) {
            e.discarded("cleared");
        }
        this.log.clear();
    }

    public void printLog() {
        this.printedErrorOrLog = true;
        this.stop();
        SkriptLogger.logAll(this.log);
        if (this.error != null) {
            this.error.discarded("not printed");
        }
    }

    public void printLog(CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            this.printLog();
        } else {
            for (LogEntry e : this.log) {
                sender.sendMessage(Utils.replaceEnglishChatStyles(e.getMessage()));
            }
        }
    }

    public void printError() {
        this.printError(null);
    }

    public void printError(@Nullable String def) {
        this.printedErrorOrLog = true;
        this.stop();
        LogEntry error = this.error;
        if (error != null) {
            SkriptLogger.log(error);
        } else if (def != null) {
            SkriptLogger.log(new LogEntry(SkriptLogger.SEVERE, ErrorQuality.SEMANTIC_ERROR, def));
        }
        for (LogEntry e : this.log) {
            e.discarded("not printed");
        }
    }

    public void printError(String def, ErrorQuality quality) {
        this.printedErrorOrLog = true;
        this.stop();
        LogEntry error = this.error;
        if (error != null && error.quality >= quality.quality()) {
            SkriptLogger.log(error);
        } else {
            SkriptLogger.log(new LogEntry(SkriptLogger.SEVERE, quality, def));
        }
        for (LogEntry e : this.log) {
            e.discarded("not printed");
        }
    }

    public int getNumErrors() {
        return this.error == null ? 0 : 1;
    }

    public boolean hasError() {
        return this.error != null;
    }

    @Nullable
    public LogEntry getError() {
        return this.error;
    }

    public Collection<LogEntry> getLog() {
        return new ArrayList<LogEntry>(this.log);
    }

    public void submit(ParserInstance pi) {
        pi.submitErrorLog(this);
    }

    public void submitError(ParserInstance pi, @Nullable String def, ErrorQuality quality) {
        if (def != null) {
            this.error(def, quality);
        }
        this.submit(pi);
    }

    public void submitError(ParserInstance pi, @Nullable String def) {
        this.submitError(pi, def, ErrorQuality.SEMANTIC_ERROR);
    }

    public void submitLog(ParserInstance pi) {
        pi.submitParseLog(this);
    }
}

