/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.Location;

@Name(value="Altitude")
@Description(value={"Effectively an alias of 'y-<a href='#ExprCoordinate'>coordinate</a> of \u2026', it represents the height of some object above bedrock."})
@Examples(value={"on damage:", "\taltitude of the attacker is higher that the altitude of the victim", "\tset damage to damage * 1.2"})
@Since(value="1.4.3")
public class ExprAltitude
extends SimplePropertyExpression<Location, Double> {
    static {
        ExprAltitude.register(ExprAltitude.class, Double.class, "altitude[s]", "locations");
    }

    @Override
    public Double convert(Location l) {
        return l.getY();
    }

    @Override
    protected String getPropertyName() {
        return "altitude";
    }

    @Override
    public Class<Double> getReturnType() {
        return Double.class;
    }
}

