/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.localization.FormattedMessage;
import ch.njol.skript.localization.Message;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.Task;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.DatatypeConverter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

public class Updater {
    public static final String RELEASES_URL = "https://api.github.com/repos/bensku/Skript/releases";
    private static final Gson gson = new Gson();
    static final AtomicReference<String> error = new AtomicReference();
    public static volatile UpdateState state = UpdateState.NOT_STARTED;
    public static final List<ResponseEntry> infos = new ArrayList<ResponseEntry>();
    public static final AtomicReference<ResponseEntry> latest = new AtomicReference();
    public static final Message m_not_started = new Message("updater.not started");
    public static final Message m_checking = new Message("updater.checking");
    public static final Message m_check_in_progress = new Message("updater.check in progress");
    public static final FormattedMessage m_check_error = new FormattedMessage("updater.check error", error);
    public static final Message m_running_latest_version = new Message("updater.running latest version");
    public static final Message m_running_latest_version_beta = new Message("updater.running latest version (beta)");
    public static final FormattedMessage m_update_available = new FormattedMessage("updater.update available", latest, Skript.getVersion());
    public static final FormattedMessage m_downloading = new FormattedMessage("updater.downloading", latest);
    public static final Message m_download_in_progress = new Message("updater.download in progress");
    public static final FormattedMessage m_download_error = new FormattedMessage("updater.download error", error);
    public static final FormattedMessage m_downloaded = new FormattedMessage("updater.downloaded", latest);
    public static final Message m_internal_error = new Message("updater.internal error");
    public static final Message m_custom_version = new Message("updater.custom version");
    @Nullable
    static Task checkerTask;
    public static final AtomicReference<CommandSender> executor;

    static {
        executor = new AtomicReference();
    }

    public static void start() {
        Skript.debug("Initializing updater");
        long period = SkriptConfig.checkForNewVersion.value() != false ? SkriptConfig.updateCheckInterval.value().getTicks_i() : -1L;
        if (checkerTask == null || !checkerTask.isAlive()) {
            checkerTask = new CheckerTask((Plugin)Skript.getInstance(), period);
        }
        Skript.info("Starting updater thread");
        checkerTask.setNextExecution(0L);
    }

    public static List<ResponseEntry> deserialize(String str) {
        assert (str != null) : "Cannot deserialize null string";
        Type listType = new TypeToken<List<ResponseEntry>>(){}.getType();
        List responses = (List)gson.fromJson(str, listType);
        assert (responses != null);
        return responses;
    }

    public static Calendar parseReleaseTime(String date) {
        assert (date != null) : "Cannot parse null date!";
        return DatatypeConverter.parseDateTime((String)date);
    }

    public static class CheckerTask
    extends Task {
        private CommandSender sender;

        public CheckerTask(Plugin plugin, long period) {
            super(plugin, 1L, period, true);
            CommandSender sender = executor.get();
            if (sender == null) {
                sender = Bukkit.getConsoleSender();
            }
            assert (sender != null);
            this.sender = sender;
        }

        public String tryLoadReleases(URL url) throws IOException, SocketTimeoutException {
            Skript.debug("Trying to load releases from " + url + "...");
            Scanner scan = null;
            try {
                scan = new Scanner(url.openStream(), "UTF-8");
                String out = scan.useDelimiter("\\A").next();
                if (out == null) {
                    throw new IOException("Null output from scanner!");
                }
                String string = out;
                return string;
            }
            finally {
                Skript.debug("Closing scanner NOW!");
                if (scan != null) {
                    scan.close();
                }
            }
        }

        public boolean performUpdate(List<ResponseEntry> releases) {
            ResponseEntry current = null;
            String ver = Skript.getInstance().getDescription().getVersion();
            boolean allowPrereleases = SkriptConfig.updateToPrereleases.value();
            ResponseEntry update = null;
            for (ResponseEntry release : releases) {
                if (ver.endsWith(release.tag_name)) {
                    Skript.debug("Found current release: " + release);
                    current = release;
                    break;
                }
                if (update != null || !allowPrereleases && release.prerelease) continue;
                update = release;
            }
            if (current == null) {
                state = UpdateState.RUNNING_CUSTOM;
                return false;
            }
            if (update == null) {
                state = UpdateState.RUNNING_LATEST;
                return false;
            }
            latest.set(update);
            infos.clear();
            infos.addAll(releases);
            return true;
        }

        @Override
        public void run() {
            Skript.debug("Beginning update checking");
            state = UpdateState.CHECKING;
            URL url = null;
            try {
                url = new URL(Updater.RELEASES_URL);
            }
            catch (MalformedURLException e) {
                Skript.info(this.sender, "" + m_internal_error);
                e.printStackTrace();
                return;
            }
            assert (url != null);
            int maxTries = SkriptConfig.updaterDownloadTries.value();
            int tries = 0;
            String response = null;
            while (response == null) {
                try {
                    response = this.tryLoadReleases(url);
                }
                catch (SocketTimeoutException e) {
                    Skript.debug("Socket timeout in updater, but we can probably try again!");
                }
                catch (IOException e) {
                    error.set(ExceptionUtils.toString(e));
                    Skript.info(this.sender, "" + m_check_error);
                }
                if (++tries < maxTries || response != null) continue;
                error.set("Can't reach update server");
                Skript.info(this.sender, "" + m_check_error);
                state = UpdateState.ERROR;
                return;
            }
            assert (response != null);
            List<ResponseEntry> entries = Updater.deserialize(response);
            if (this.performUpdate(entries)) {
                state = UpdateState.UPDATE_AVAILABLE;
                infos.addAll(entries);
                latest.set(entries.get(0));
                Skript.info(this.sender, "" + m_update_available);
                SkriptConfig.automaticallyDownloadNewVersion.value().booleanValue();
            } else {
                switch (state) {
                    case RUNNING_LATEST: {
                        Skript.info(this.sender, "" + m_running_latest_version);
                        break;
                    }
                    case RUNNING_CUSTOM: {
                        Skript.info(this.sender, "" + m_custom_version);
                        break;
                    }
                    default: {
                        Skript.error(this.sender, "" + m_internal_error);
                        Thread.dumpStack();
                    }
                }
            }
        }
    }

    public static class DownloaderTask
    extends Task {
        private CommandSender sender;

        public DownloaderTask(Plugin plugin) {
            super(plugin, 0L, true);
            CommandSender sender = executor.get();
            if (sender == null) {
                sender = Bukkit.getConsoleSender();
            }
            assert (sender != null);
            this.sender = sender;
        }

        @Override
        public void run() {
            URL url;
            ResponseEntry update = latest.get();
            try {
                url = new URL(update.assets.get((int)0).browser_download_url);
            }
            catch (MalformedURLException e) {
                Skript.info(this.sender, "" + m_internal_error);
                e.printStackTrace();
                return;
            }
            assert (url != null);
        }
    }

    @NonNullByDefault(value=false)
    public class ResponseEntry {
        public String url;
        public String assets_url;
        public String upload_url;
        public String html_url;
        public int id;
        public String tag_name;
        public String target_commitish;
        public String name;
        public boolean draft;
        public boolean prerelease;
        public String created_at;
        public String published_at;
        public List<AssetsEntry> assets;
        public String body;

        public String toString() {
            return this.tag_name;
        }

        public class AssetsEntry {
            public int size;
            public int download_count;
            public String browser_download_url;
        }
    }

    public static enum UpdateState {
        NOT_STARTED,
        CHECKING,
        RUNNING_LATEST,
        RUNNING_CUSTOM,
        UPDATE_AVAILABLE,
        DOWNLOADING,
        DOWNLOADED,
        ERROR;

    }
}

