/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.Utils;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.eclipse.jdt.annotation.Nullable;

public class EnchantmentType
implements YggdrasilSerializable {
    private static final String LANGUAGE_NODE = "enchantments";
    private final Enchantment type;
    private final int level;
    static final Map<Enchantment, String> enchantmentNames = new HashMap<Enchantment, String>();
    static final Map<String, Enchantment> enchantmentPatterns = new HashMap<String, Enchantment>();
    private static final Pattern pattern;

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                enchantmentNames.clear();
                Enchantment[] enchantmentArray = Enchantment.values();
                int n = enchantmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Enchantment e = enchantmentArray[n2];
                    String[] names = Language.getList("enchantments.names." + e.getName());
                    enchantmentNames.put(e, names[0]);
                    String[] stringArray = names;
                    int n3 = names.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String n5 = stringArray[n4];
                        enchantmentPatterns.put(n5.toLowerCase(), e);
                        ++n4;
                    }
                    ++n2;
                }
            }
        });
        pattern = Pattern.compile(".+ \\d+");
    }

    private EnchantmentType() {
        this.type = null;
        this.level = -1;
    }

    public EnchantmentType(Enchantment type, int level) {
        assert (type != null);
        this.type = type;
        this.level = level;
    }

    public int getLevel() {
        return this.level == -1 ? 1 : this.level;
    }

    public int getInternalLevel() {
        return this.level;
    }

    @Nullable
    public Enchantment getType() {
        return this.type;
    }

    public boolean has(ItemType item) {
        Map<Enchantment, Integer> enchs = item.getEnchantments();
        if (enchs == null) {
            return false;
        }
        Integer l = enchs.get(this.type);
        if (l == null) {
            return false;
        }
        if (this.level == -1) {
            return true;
        }
        return l == this.level;
    }

    public String toString() {
        return String.valueOf(EnchantmentType.toString(this.type)) + (this.level == -1 ? "" : " " + this.level);
    }

    public static String toString(Enchantment e) {
        return enchantmentNames.get(e);
    }

    public static String toString(Enchantment e, int flags) {
        return enchantmentNames.get(e);
    }

    @Nullable
    public static EnchantmentType parse(String s) {
        if (pattern.matcher(s).matches()) {
            Enchantment ench = EnchantmentType.parseEnchantment(s.substring(0, s.lastIndexOf(32)));
            if (ench == null) {
                return null;
            }
            return new EnchantmentType(ench, Utils.parseInt(s.substring(s.lastIndexOf(32) + 1)));
        }
        Enchantment ench = EnchantmentType.parseEnchantment(s);
        if (ench == null) {
            return null;
        }
        return new EnchantmentType(ench, -1);
    }

    @Nullable
    public static Enchantment parseEnchantment(String s) {
        return enchantmentPatterns.get(s.toLowerCase());
    }

    public static final Collection<String> getNames() {
        return enchantmentNames.values();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.level;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnchantmentType)) {
            return false;
        }
        EnchantmentType other = (EnchantmentType)obj;
        if (this.level != other.level) {
            return false;
        }
        return this.type.equals((Object)other.type);
    }
}

