/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.parser;

import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.parser.ScriptManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public class LoaderInstance
implements Runnable {
    private String name;
    private File f;
    private ScriptManager manager;
    private ExecutorService pool;

    public LoaderInstance(String name, File f, ScriptManager manager, ExecutorService pool) {
        this.name = name;
        this.f = f;
        this.manager = manager;
        this.pool = pool;
    }

    @Override
    public void run() {
        if (this.f.isDirectory()) {
            File[] fileArray = this.f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f2 = fileArray[n2];
                this.pool.execute(new LoaderInstance(String.valueOf(this.name) + "/" + f2.getName(), f2, this.manager, this.pool));
                ++n2;
            }
            return;
        }
        try {
            Config config = new Config(this.f, true, false, ":");
            for (Node cnode : config.getMainNode()) {
                if (!(cnode instanceof SectionNode)) {
                    Skript.error("invalid line - all code has to be put into triggers");
                    continue;
                }
                SectionNode node = (SectionNode)cnode;
                String key = node.getKey();
                if (key == null || !key.toLowerCase().startsWith("function ")) continue;
                Functions.loadSignature(config.getFileName(), node, ParserInstance.DUMMY);
            }
            this.manager.loadReady(this.f.getName(), config);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

