/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.command.ScriptCommandEvent;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.LiteralList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.ExprFunctionCall;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class SkriptParser {
    final String expr;
    public static final int PARSE_EXPRESSIONS = 1;
    public static final int PARSE_LITERALS = 2;
    public static final int ALL_FLAGS = 3;
    private final int flags;
    private final ParserInstance pi;
    public final ParseContext context;
    public static final String wildcard = "[^\"]*?(?:\"[^\"]*?\"[^\"]*?)*?";
    public static final String stringMatcher = "\"[^\"]*?(?:\"\"[^\"]*)*?\"";
    private static final Pattern varPattern = Pattern.compile("((the )?var(iable)? )?\\{([^{}]|%\\{|\\}%)+\\}", 2);
    public static final Pattern listSplitPattern = Pattern.compile("\\s*,?\\s+(and|n?or)\\s+|\\s*,\\s*", 2);
    private static final String MULTIPLE_AND_OR = "List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists.";
    private static final String MISSING_AND_OR = "List is missing 'and' or 'or', defaulting to 'and'";
    private boolean suppressMissingAndOrWarnings = false;
    private static final Pattern functionCallPattern = Pattern.compile("([\\p{IsAlphabetic}][\\p{IsAlphabetic}\\p{IsDigit}_]*)\\((.*)\\)");
    private static final Message m_quotes_error = new Message("skript.quotes error");
    private static final Message m_brackets_error = new Message("skript.brackets error");

    public SkriptParser(ParserInstance pi, String expr) {
        this(pi, expr, 3);
    }

    public SkriptParser(ParserInstance pi, String expr, int flags) {
        this(pi, expr, flags, ParseContext.DEFAULT);
    }

    public SkriptParser(ParserInstance pi, String expr, int flags, ParseContext context) {
        assert (expr != null);
        assert ((flags & 3) != 0);
        this.expr = expr.trim();
        this.flags = flags;
        this.context = context;
        this.pi = pi;
    }

    public SkriptParser(SkriptParser other, String expr) {
        this(other.pi, expr, other.flags, other.context);
    }

    @Nullable
    public static final <T> Literal<? extends T> parseLiteral(String expr, Class<T> c, ParseContext context) {
        if ((expr = expr.trim()).isEmpty()) {
            return null;
        }
        return new UnparsedLiteral(expr).getConvertedExpression(context, c);
    }

    @Nullable
    public static final <T extends SyntaxElement> T parse(ParserInstance pi, String expr, Iterator<? extends SyntaxElementInfo<T>> source, @Nullable String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            pi.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        T e = new SkriptParser(pi, expr).parse(source);
        if (e != null) {
            log.submitLog(pi);
            return e;
        }
        log.submitError(pi, defaultError);
        return null;
    }

    @Nullable
    public static final <T extends SyntaxElement> T parseStatic(ParserInstance pi, String expr, Iterator<? extends SyntaxElementInfo<? extends T>> source, @Nullable String defaultError) {
        if ((expr = expr.trim()).isEmpty()) {
            pi.error(defaultError);
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        T e = new SkriptParser(pi, expr, 2).parse(source);
        if (e != null) {
            log.submitLog(pi);
            return e;
        }
        log.submitError(pi, defaultError);
        return null;
    }

    @Nullable
    private final <T extends SyntaxElement> T parse(Iterator<? extends SyntaxElementInfo<? extends T>> source) {
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        while (source.hasNext()) {
            SyntaxElementInfo<? extends T> info = source.next();
            int i = 0;
            while (i < info.patterns.length) {
                block17: {
                    log.clear();
                    try {
                        String pattern = info.patterns[i];
                        assert (pattern != null);
                        ParseResult res = this.parse_i(pattern, 0, 0);
                        if (res == null) break block17;
                        int x = -1;
                        int j = 0;
                        while ((x = SkriptParser.nextUnescaped(pattern, '%', x + 1)) != -1) {
                            String name;
                            int x2 = SkriptParser.nextUnescaped(pattern, '%', x + 1);
                            if (res.exprs[j] == null && !(name = pattern.substring(x + 1, x2)).startsWith("-")) {
                                ExprInfo vi = SkriptParser.getExprInfo(name);
                                DefaultExpression<?> expr = vi.classes[0].getDefaultExpression();
                                if (expr == null) {
                                    throw new SkriptAPIException("The class '" + vi.classes[0].getCodeName() + "' does not provide a default expression. Either allow null (with %-" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!(expr instanceof Literal) && (vi.flagMask & 1) == 0) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a literal. Either allow null (with %-*" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                expr.setParserInstance(this.pi);
                                if (expr instanceof Literal && (vi.flagMask & 2) == 0) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is a literal. Either allow null (with %-~" + vi.classes[0].getCodeName() + "%) or make it mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (!vi.isPlural[0] && !expr.isSingle()) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' is not a single-element expression. Change your pattern to allow multiple elements or make the expression mandatory [pattern: " + info.patterns[i] + "]");
                                }
                                if (vi.time != 0 && !expr.setTime(vi.time)) {
                                    throw new SkriptAPIException("The default expression of '" + vi.classes[0].getCodeName() + "' does not have distinct time states. [pattern: " + info.patterns[i] + "]");
                                }
                                if (!expr.init()) break block17;
                                res.exprs[j] = expr;
                            }
                            x = x2;
                            ++j;
                        }
                        SyntaxElement t = (SyntaxElement)info.c.newInstance();
                        t.setParserInstance(this.pi);
                        if (t.init(res.exprs, i, this.pi.hasDelayBefore, res)) {
                            log.submit(this.pi);
                            return (T)t;
                        }
                    }
                    catch (InstantiationException e) {
                        assert (false);
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block17;
                        throw new AssertionError();
                    }
                }
                ++i;
            }
        }
        log.submit(this.pi);
        return null;
    }

    @Nullable
    private static final <T> Variable<T> parseVariable(ParserInstance pi, String expr, Class<? extends T>[] returnTypes) {
        if (varPattern.matcher(expr).matches()) {
            return Variable.newInstance(pi, expr.substring(expr.indexOf(123) + 1, expr.lastIndexOf(125)), returnTypes);
        }
        return null;
    }

    @Nullable
    private final <T> Expression<? extends T> parseSingleExpr(boolean allowUnparsedLiteral, @Nullable LogEntry error, Class<? extends T> ... types) {
        Expression<String> e;
        assert (types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        if (this.expr.isEmpty()) {
            return null;
        }
        if (this.context != ParseContext.COMMAND && this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
            return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseSingleExpr(allowUnparsedLiteral, error, types);
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        if (this.context == ParseContext.DEFAULT || this.context == ParseContext.EVENT) {
            Variable<? extends T> var = SkriptParser.parseVariable(this.pi, this.expr, types);
            if (var != null) {
                log.submitLog(this.pi);
                return var;
            }
            if (log.hasError()) {
                log.submit(this.pi);
                return null;
            }
            FunctionReference<? extends T> fr = this.parseFunction(types);
            if (fr != null) {
                log.submitLog(this.pi);
                return new ExprFunctionCall<T>(fr);
            }
            if (log.hasError()) {
                log.submit(this.pi);
                return null;
            }
        }
        log.clear();
        if ((this.flags & 1) != 0) {
            e = this.expr.startsWith("\"") && this.expr.endsWith("\"") && this.expr.length() != 1 && (types[0] == Object.class || CollectionUtils.contains(types, String.class)) ? VariableString.newInstance(this.pi, this.expr.substring(1, this.expr.length() - 1)) : (Expression)SkriptParser.parse(this.pi, this.expr, Skript.getExpressions(types), null);
            if (e != null) {
                Class<Object> t;
                Class<? extends T>[] classArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    t = classArray[n2];
                    if (t.isAssignableFrom(e.getReturnType())) {
                        log.submitLog(this.pi);
                        return e;
                    }
                    ++n2;
                }
                classArray = types;
                n = types.length;
                n2 = 0;
                while (n2 < n) {
                    t = classArray[n2];
                    Expression r = e.getConvertedExpression(t);
                    if (r != null) {
                        log.submitLog(this.pi);
                        return r;
                    }
                    ++n2;
                }
                log.submitError(this.pi, String.valueOf(e.toString(null, false)) + " " + Language.get("is") + " " + SkriptParser.notOfType(types), ErrorQuality.NOT_AN_EXPRESSION);
                return null;
            }
            log.clear();
        }
        if ((this.flags & 2) == 0) {
            log.submit(this.pi);
            return null;
        }
        if (types[0] == Object.class) {
            if (!allowUnparsedLiteral) {
                log.submit(this.pi);
                return null;
            }
            log.clear();
            log.submitLog(this.pi);
            e = log.getError();
            return new UnparsedLiteral(this.expr, (LogEntry)(e != null && (error == null || ((LogEntry)((Object)e)).quality > error.quality) ? e : error));
        }
        Class<? extends T>[] classArray = types;
        int n = types.length;
        int n3 = 0;
        while (n3 < n) {
            Class<? extends T> c = classArray[n3];
            log.clear();
            assert (c != null);
            T t = Classes.parse(this.pi, this.expr, c, this.context);
            if (t != null) {
                log.submitLog(this.pi);
                return new SimpleLiteral<T>(t, false);
            }
            ++n3;
        }
        log.submit(this.pi);
        return null;
    }

    private SkriptParser suppressMissingAndOrWarnings() {
        this.suppressMissingAndOrWarnings = true;
        return this;
    }

    @SafeVarargs
    @Nullable
    public final <T> Expression<? extends T> parseExpression(Class<? extends T> ... types) {
        int a;
        Expression<? extends T> r;
        if (this.expr.length() == 0) {
            return null;
        }
        assert (types != null && types.length > 0);
        assert (types.length == 1 || !CollectionUtils.contains(types, Object.class));
        boolean isObject = types.length == 1 && types[0] == Object.class;
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        if (isObject && (this.flags & 2) != 0) {
            SkriptParser p = new SkriptParser(this.pi, this.expr, 2, this.context);
            Class[] classArray = new Class[]{Number.class, Time.class, ItemType.class, ItemStack.class};
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                Expression<T> e = p.parseExpression(c);
                if (e != null) {
                    log.printLog();
                    return e;
                }
                log.clear();
                ++n2;
            }
        }
        if ((r = this.parseSingleExpr(false, null, types)) != null) {
            log.submitLog(this.pi);
            return r;
        }
        log.clear();
        ArrayList<Expression<? extends T>> ts = new ArrayList<Expression<? extends T>>();
        Kleenean and = Kleenean.UNKNOWN;
        boolean isLiteralList = true;
        ArrayList<int[]> pieces = new ArrayList<int[]>();
        Matcher m = listSplitPattern.matcher(this.expr);
        int i = 0;
        int j = 0;
        while (i >= 0 && i <= this.expr.length()) {
            if (i == this.expr.length() || m.region(i, this.expr.length()).lookingAt()) {
                pieces.add(new int[]{j, i});
                if (i == this.expr.length()) break;
                j = i = m.end();
            }
            i = SkriptParser.next(this.expr, i, this.context);
        }
        if (i != this.expr.length()) {
            assert (i == -1 && this.context != ParseContext.COMMAND) : String.valueOf(i) + "; " + this.expr;
            log.submitError(this.pi, "Invalid brackets/variables/text in '" + this.expr + "'", ErrorQuality.NOT_AN_EXPRESSION);
            return null;
        }
        if (pieces.size() == 1) {
            if (this.expr.startsWith("(") && this.expr.endsWith(")") && SkriptParser.next(this.expr, 0, this.context) == this.expr.length()) {
                log.clear();
                log.submitLog(this.pi);
                return new SkriptParser(this, this.expr.substring(1, this.expr.length() - 1)).parseExpression(types);
            }
            if (isObject && (this.flags & 2) != 0) {
                log.clear();
                log.submitLog(this.pi);
                return new UnparsedLiteral(this.expr, log.getError());
            }
            log.submit(this.pi);
            return null;
        }
        block2: for (int b = 0; b < pieces.size(); b += a) {
            a = pieces.size() - b;
            while (a >= 1) {
                if (b != 0 || a != pieces.size()) {
                    int x = ((int[])pieces.get(b))[0];
                    int y = ((int[])pieces.get(b + a - 1))[1];
                    String subExpr = this.expr.substring(x, y).trim();
                    assert (subExpr.length() < this.expr.length()) : subExpr;
                    Expression<? extends T> t = subExpr.startsWith("(") && subExpr.endsWith(")") && SkriptParser.next(subExpr, 0, this.context) == subExpr.length() ? new SkriptParser(this, subExpr).parseExpression(types) : new SkriptParser(this, subExpr).parseSingleExpr(a == 1, log.getError(), types);
                    if (t != null) {
                        String d;
                        isLiteralList &= t instanceof Literal;
                        ts.add(t);
                        if (b == 0 || (d = this.expr.substring(((int[])pieces.get(b - 1))[1], x).trim()).equals(",")) continue block2;
                        if (and.isUnknown()) {
                            and = Kleenean.get(!d.equalsIgnoreCase("or"));
                            continue block2;
                        }
                        if (and == Kleenean.get(!d.equalsIgnoreCase("or"))) continue block2;
                        this.pi.warning("List has multiple 'and' or 'or', will default to 'and'. Use brackets if you want to define multiple lists. List: " + this.expr);
                        and = Kleenean.TRUE;
                        continue block2;
                    }
                }
                --a;
            }
            log.submit(this.pi);
            return null;
        }
        log.submitLog(this.pi);
        if (ts.size() == 1) {
            return (Expression)ts.get(0);
        }
        if (and.isUnknown() && !this.suppressMissingAndOrWarnings) {
            this.pi.warning("List is missing 'and' or 'or', defaulting to 'and': " + this.expr);
        }
        Class[] exprRetTypes = new Class[ts.size()];
        i = 0;
        while (i < ts.size()) {
            exprRetTypes[i] = ((Expression)ts.get(i)).getReturnType();
            ++i;
        }
        if (isLiteralList) {
            Literal[] ls = ts.toArray(new Literal[ts.size()]);
            assert (ls != null);
            return new LiteralList(ls, Utils.getSuperType(exprRetTypes), !and.isFalse());
        }
        Expression[] es = ts.toArray(new Expression[ts.size()]);
        assert (es != null);
        return new ExpressionList(es, Utils.getSuperType(exprRetTypes), !and.isFalse());
    }

    @Nullable
    public final <T> FunctionReference<T> parseFunction(Class<? extends T> ... types) {
        Expression[] params;
        if (this.context != ParseContext.DEFAULT && this.context != ParseContext.EVENT) {
            return null;
        }
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        Matcher m = functionCallPattern.matcher(this.expr);
        if (!m.matches()) {
            log.submitLog(this.pi);
            return null;
        }
        if ((this.flags & 1) == 0) {
            this.pi.error("Functions cannot be used here.");
            log.submit(this.pi);
            return null;
        }
        String functionName = m.group(1);
        String args = m.group(2);
        if (args.length() != 0) {
            Expression<T> ps = new SkriptParser(this.pi, args, this.flags | 2, this.context).suppressMissingAndOrWarnings().parseExpression(Object.class);
            if (ps == null) {
                log.submit(this.pi);
                return null;
            }
            if (ps instanceof ExpressionList) {
                if (!ps.getAnd()) {
                    log.submitError(this.pi, "Function arguments must be separated by commas and optionally an 'and', but not an 'or'. Put the 'or' into a second set of parentheses if you want to make it a single parameter, e.g. 'give(player, (sword or axe))'");
                    return null;
                }
                params = ((ExpressionList)ps).getExpressions();
            } else {
                params = new Expression[]{ps};
            }
        } else {
            params = new Expression[]{};
        }
        FunctionReference<T> e = new FunctionReference<T>(functionName, this.pi.getNode(), this.pi.config != null ? this.pi.config.getFile() : null, types, params);
        if (!e.validateFunction(true)) {
            log.submit(this.pi);
            return null;
        }
        log.submitLog(this.pi);
        return e;
    }

    public static boolean parseArguments(ParserInstance pi, String args, ScriptCommand command, ScriptCommandEvent event) {
        SkriptParser parser = new SkriptParser(pi, args, 2, ParseContext.COMMAND);
        ParseResult res = parser.parse_i(command.getPattern(), 0, 0);
        if (res == null) {
            return false;
        }
        List<Argument<?>> as = command.getArguments();
        assert (as.size() == res.exprs.length);
        int i = 0;
        while (i < res.exprs.length) {
            if (res.exprs[i] == null) {
                as.get(i).setToDefault(event);
            } else {
                as.get(i).set(event, res.exprs[i].getArray(event));
            }
            ++i;
        }
        return true;
    }

    public static boolean parseArguments(String args, ScriptCommand command, ScriptCommandEvent event) {
        return SkriptParser.parseArguments(ParserInstance.DUMMY, args, command, event);
    }

    @Nullable
    public static ParseResult parse(ParserInstance pi, String text, String pattern) {
        return new SkriptParser(pi, text, 2, ParseContext.COMMAND).parse_i(pattern, 0, 0);
    }

    @Nullable
    public static ParseResult parse(String text, String pattern) {
        return SkriptParser.parse(ParserInstance.DUMMY, text, pattern);
    }

    @Nullable
    public static NonNullPair<SkriptEventInfo<?>, SkriptEvent> parseEvent(ParserInstance pi, String event, String defaultError) {
        RetainingLogHandler log = SkriptLogger.startRetainingLog();
        NonNullPair<SkriptEventInfo<?>, SkriptEvent> e = new SkriptParser(pi, event, 2, ParseContext.EVENT).parseEvent();
        if (e != null) {
            pi.submitParseLog(log);
            return e;
        }
        pi.submitParseLog(log);
        return null;
    }

    @Nullable
    private NonNullPair<SkriptEventInfo<?>, SkriptEvent> parseEvent() {
        assert (this.context == ParseContext.EVENT);
        assert (this.flags == 2);
        ParseLogHandler log = SkriptLogger.startParseLogHandler();
        for (SkriptEventInfo<?> info : Skript.getEvents()) {
            int i = 0;
            while (i < info.patterns.length) {
                block11: {
                    SkriptEvent e;
                    block12: {
                        log.clear();
                        String pattern = info.patterns[i];
                        assert (pattern != null);
                        ParseResult res = this.parse_i(pattern, 0, 0);
                        if (res == null) break block11;
                        e = (SkriptEvent)info.c.newInstance();
                        e.setParserInstance(this.pi);
                        Literal[] ls = (Literal[])Arrays.copyOf(res.exprs, res.exprs.length, Literal[].class);
                        assert (ls != null);
                        if (e.init(ls, i, res)) break block12;
                        log.printError();
                        return null;
                    }
                    try {
                        log.submitLog(this.pi);
                        return new NonNullPair(info, e);
                    }
                    catch (InstantiationException e2) {
                        assert (false);
                    }
                    catch (IllegalAccessException e3) {
                        if ($assertionsDisabled) break block11;
                        throw new AssertionError();
                    }
                }
                ++i;
            }
        }
        log.submit(this.pi);
        return null;
    }

    private static int nextBracket(String pattern, char closingBracket, char openingBracket, int start, boolean isGroup) throws MalformedPatternException {
        int n = 0;
        int i = start;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == closingBracket) {
                if (n == 0) {
                    if (!isGroup) {
                        throw new MalformedPatternException(pattern, "Unexpected closing bracket '" + closingBracket + "'");
                    }
                    return i;
                }
                --n;
            } else if (pattern.charAt(i) == openingBracket) {
                ++n;
            }
            ++i;
        }
        if (isGroup) {
            throw new MalformedPatternException(pattern, "Missing closing bracket '" + closingBracket + "'");
        }
        return -1;
    }

    private static int nextUnescaped(String pattern, char c, int from) {
        int i = from;
        while (i < pattern.length()) {
            if (pattern.charAt(i) == '\\') {
                ++i;
            } else if (pattern.charAt(i) == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int countUnescaped(String pattern, char c) {
        return SkriptParser.countUnescaped(pattern, c, 0, pattern.length());
    }

    static int countUnescaped(String pattern, char c, int start, int end) {
        assert (start >= 0 && start <= end && end <= pattern.length()) : String.valueOf(start) + ", " + end + "; " + pattern.length();
        int r = 0;
        int i = start;
        while (i < end) {
            char x = pattern.charAt(i);
            if (x == '\\') {
                ++i;
            } else if (x == c) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    private static int nextQuote(String s, int from) {
        int i = from;
        while (i < s.length()) {
            if (s.charAt(i) == '\"') {
                if (i == s.length() - 1 || s.charAt(i + 1) != '\"') {
                    return i;
                }
                ++i;
            }
            ++i;
        }
        return -1;
    }

    public static final String notOfType(Class<?> ... cs) {
        if (cs.length == 1) {
            Class<?> c = cs[0];
            assert (c != null);
            return String.valueOf(Language.get("not")) + " " + Classes.getSuperClassInfo(c).getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            Class<?> c = cs[k];
            assert (c != null);
            b.append(Classes.getSuperClassInfo(c).getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static final String notOfType(ClassInfo<?> ... cs) {
        if (cs.length == 1) {
            return String.valueOf(Language.get("not")) + " " + cs[0].getName().withIndefiniteArticle();
        }
        StringBuilder b = new StringBuilder(String.valueOf(Language.get("neither")) + " ");
        int k = 0;
        while (k < cs.length) {
            if (k != 0) {
                if (k != cs.length - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + Language.get("nor") + " ");
                }
            }
            b.append(cs[k].getName().withIndefiniteArticle());
            ++k;
        }
        return b.toString();
    }

    public static final int next(String expr, int i, ParseContext context) {
        if (i >= expr.length()) {
            return -1;
        }
        if (i < 0) {
            throw new StringIndexOutOfBoundsException(i);
        }
        if (context == ParseContext.COMMAND) {
            return i + 1;
        }
        char c = expr.charAt(i);
        if (c == '\"') {
            int i2 = SkriptParser.nextQuote(expr, i + 1);
            return i2 < 0 ? -1 : i2 + 1;
        }
        if (c == '{') {
            int i2 = VariableString.nextVariableBracket(expr, i + 1);
            return i2 < 0 ? -1 : i2 + 1;
        }
        if (c == '(') {
            int j = i + 1;
            while (j >= 0 && j < expr.length()) {
                if (expr.charAt(j) == ')') {
                    return j + 1;
                }
                j = SkriptParser.next(expr, j, context);
            }
            return -1;
        }
        return i + 1;
    }

    private static final int getGroupLevel(String pattern, int j) {
        assert (j >= 0 && j <= pattern.length()) : String.valueOf(j) + "; " + pattern;
        int level = 0;
        int i = 0;
        while (i < j) {
            char c = pattern.charAt(i);
            if (c == '\\') {
                ++i;
            } else if (c == '(') {
                ++level;
            } else if (c == ')') {
                if (level == 0) {
                    throw new MalformedPatternException(pattern, "Unexpected closing bracket ')'");
                }
                --level;
            }
            ++i;
        }
        return level;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private final ParseResult parse_i(String pattern, int i, int j) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [35[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static final NonNullPair<String, boolean[]> validatePattern(ParserInstance pi, String pattern) {
        ArrayList<Boolean> ps = new ArrayList<Boolean>();
        int groupLevel = 0;
        int optionalLevel = 0;
        LinkedList<Character> groups = new LinkedList<Character>();
        StringBuilder b = new StringBuilder(pattern.length());
        int last = 0;
        int i = 0;
        while (i < pattern.length()) {
            int j;
            char c = pattern.charAt(i);
            if (c == '(') {
                ++groupLevel;
                groups.addLast(Character.valueOf(c));
            } else if (c == '|') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error(pi, "Cannot use the pipe character '|' outside of groups. Escape it if you want to match a literal pipe: '\\|'");
                }
                groups.removeLast();
                groups.addLast(Character.valueOf(c));
            } else if (c == ')') {
                if (groupLevel == 0 || ((Character)groups.peekLast()).charValue() != '(' && ((Character)groups.peekLast()).charValue() != '|') {
                    return SkriptParser.error(pi, "Unexpected closing group bracket ')'. Escape it if you want to match a literal bracket: '\\)'");
                }
                if (((Character)groups.peekLast()).charValue() == '(') {
                    return SkriptParser.error(pi, "(...|...) groups have to contain at least one pipe character '|' to separate it into parts. Escape the brackets if you want to match literal brackets: \"\\(not a group\\)\"");
                }
                --groupLevel;
                groups.removeLast();
            } else if (c == '[') {
                ++optionalLevel;
                groups.addLast(Character.valueOf(c));
            } else if (c == ']') {
                if (optionalLevel == 0 || ((Character)groups.peekLast()).charValue() != '[') {
                    return SkriptParser.error(pi, "Unexpected closing optional bracket ']'. Escape it if you want to match a literal bracket: '\\]'");
                }
                --optionalLevel;
                groups.removeLast();
            } else if (c == '<') {
                j = pattern.indexOf(62, i + 1);
                if (j == -1) {
                    return SkriptParser.error(pi, "Missing closing regex bracket '>'. Escape the '<' if you want to match a literal bracket: '\\<'");
                }
                try {
                    Pattern.compile(pattern.substring(i + 1, j));
                }
                catch (PatternSyntaxException e) {
                    return SkriptParser.error(pi, "Invalid Regular Expression '" + pattern.substring(i + 1, j) + "': " + e.getLocalizedMessage());
                }
                i = j;
            } else {
                if (c == '>') {
                    return SkriptParser.error(pi, "Unexpected closing regex bracket '>'. Escape it if you want to match a literal bracket: '\\>'");
                }
                if (c == '%') {
                    j = pattern.indexOf(37, i + 1);
                    if (j == -1) {
                        return SkriptParser.error(pi, "Missing end sign '%' of expression. Escape the percent sign to match a literal '%': '\\%'");
                    }
                    NonNullPair<String, Boolean> p = Utils.getEnglishPlural(pattern.substring(i + 1, j));
                    ClassInfo<?> ci = Classes.getClassInfoFromUserInput(p.getFirst());
                    if (ci == null) {
                        return SkriptParser.error(pi, "The type '" + p.getFirst() + "' could not be found. Please check your spelling or escape the percent signs if you want to match literal %s: \"\\%not an expression\\%\"");
                    }
                    ps.add(p.getSecond());
                    b.append(pattern.substring(last, i + 1));
                    b.append(Utils.toEnglishPlural(ci.getCodeName(), p.getSecond()));
                    last = j;
                    i = j;
                } else if (c == '\\') {
                    if (i == pattern.length() - 1) {
                        return SkriptParser.error(pi, "Pattern must not end in an unescaped backslash. Add another backslash to escape it, or remove it altogether.");
                    }
                    ++i;
                }
            }
            ++i;
        }
        b.append(pattern.substring(last));
        boolean[] plurals = new boolean[ps.size()];
        int i2 = 0;
        while (i2 < plurals.length) {
            plurals[i2] = (Boolean)ps.get(i2);
            ++i2;
        }
        return new NonNullPair<String, boolean[]>(b.toString(), plurals);
    }

    @Nullable
    private static final NonNullPair<String, boolean[]> error(ParserInstance pi, String error) {
        pi.error("Invalid pattern: " + error);
        return null;
    }

    public static final boolean validateLine(ParserInstance pi, String line) {
        if (StringUtils.count(line, '\"') % 2 != 0) {
            pi.error(m_quotes_error.toString());
            return false;
        }
        int i = 0;
        while (i < line.length()) {
            if (i == -1) {
                pi.error(m_brackets_error.toString());
                return false;
            }
            i = SkriptParser.next(line, i, ParseContext.DEFAULT);
        }
        return true;
    }

    private static ExprInfo getExprInfo(String s) throws MalformedPatternException, IllegalArgumentException, SkriptAPIException {
        int a;
        ExprInfo r = new ExprInfo(StringUtils.count(s, '/') + 1);
        r.isOptional = s.startsWith("-");
        if (r.isOptional) {
            s = s.substring(1);
        }
        if (s.startsWith("*")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFE;
        } else if (s.startsWith("~")) {
            s = s.substring(1);
            r.flagMask &= 0xFFFFFFFD;
        }
        if (!r.isOptional) {
            r.isOptional = s.startsWith("-");
            if (r.isOptional) {
                s = s.substring(1);
            }
        }
        if ((a = s.indexOf("@")) != -1) {
            r.time = Integer.parseInt(s.substring(a + 1));
            s = s.substring(0, a);
        }
        String[] classes = s.split("/");
        assert (classes.length == r.classes.length);
        int i = 0;
        while (i < classes.length) {
            NonNullPair<String, Boolean> p = Utils.getEnglishPlural(classes[i]);
            r.classes[i] = Classes.getClassInfo(p.getFirst());
            r.isPlural[i] = p.getSecond();
            ++i;
        }
        return r;
    }

    private static final class ExprInfo {
        final ClassInfo<?>[] classes;
        final boolean[] isPlural;
        boolean isOptional;
        int flagMask = -1;
        int time = 0;

        public ExprInfo(int length) {
            this.classes = new ClassInfo[length];
            this.isPlural = new boolean[length];
        }
    }

    private static final class MalformedPatternException
    extends RuntimeException {
        private static final long serialVersionUID = -5133477361763823946L;

        public MalformedPatternException(String pattern, String message) {
            this(pattern, message, null);
        }

        public MalformedPatternException(String pattern, String message, @Nullable Throwable cause) {
            super(String.valueOf(message) + " [pattern: " + pattern + "]", cause);
        }
    }

    public static final class ParseResult {
        public final Expression<?>[] exprs;
        public final List<MatchResult> regexes = new ArrayList<MatchResult>(1);
        public final String expr;
        public int mark = 0;

        public ParseResult(SkriptParser parser, String pattern) {
            this.expr = parser.expr;
            this.exprs = new Expression[SkriptParser.countUnescaped(pattern, '%') / 2];
        }
    }
}

