/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Saturation")
@Description(value={"The saturation of a player."})
@Examples(value={"saturation of player is 20 #Not hungry!"})
@Since(value="2.2-Fixes-V10")
public class ExprSaturation
extends PropertyExpression<Player, Number> {
    static {
        Skript.registerExpression(ExprSaturation.class, Number.class, ExpressionType.SIMPLE, "[the] saturation [of %players%]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        return true;
    }

    protected Number[] get(Event e, Player[] source) {
        return this.get(source, new Converter<Player, Number>(){

            @Override
            @Nullable
            public Number convert(Player p) {
                return Float.valueOf(p.getSaturation());
            }
        });
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Number.class};
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            assert (delta != null);
            Player[] playerArray = (Player[])this.getExpr().getArray(e);
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                assert (p != null) : this.getExpr();
                p.setSaturation(((Number)delta[0]).floatValue());
                ++n2;
            }
        } else {
            super.change(e, delta, mode);
        }
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the saturation" + (this.getExpr().isDefault() ? "" : " of " + this.getExpr().toString(e, debug));
    }
}

