/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Passenger")
@Description(value={"The passenger of a vehicle, or the rider of a mob.", "See also: <a href='#ExprVehicle'>vehicle</a>"})
@Examples(value={"passenger of the minecart is a creeper or a cow", "the saddled pig's passenger is a player"})
@Since(value="2.0")
public class ExprPassenger
extends SimplePropertyExpression<Entity, Entity> {
    static {
        ExprPassenger.register(ExprPassenger.class, Entity.class, "passenger[s]", "entities");
    }

    protected Entity[] get(final Event e, Entity[] source) {
        return this.get(source, new Converter<Entity, Entity>(){

            @Override
            @Nullable
            public Entity convert(Entity v) {
                if (ExprPassenger.this.getTime() >= 0 && e instanceof VehicleEnterEvent && v.equals(((VehicleEnterEvent)e).getVehicle()) && !Delay.isDelayed(e)) {
                    return ((VehicleEnterEvent)e).getEntered();
                }
                if (ExprPassenger.this.getTime() >= 0 && e instanceof VehicleExitEvent && v.equals(((VehicleExitEvent)e).getVehicle()) && !Delay.isDelayed(e)) {
                    return ((VehicleExitEvent)e).getExited();
                }
                return v.getPassenger();
            }
        });
    }

    @Override
    @Nullable
    public Entity convert(Entity e) {
        assert (false);
        return e.getPassenger();
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Entity.class, EntityData.class};
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            assert (delta != null);
            Entity[] vs = (Entity[])this.getExpr().getArray(e);
            if (vs.length == 0) {
                return;
            }
            Object o = delta[0];
            if (o instanceof Entity) {
                ((Entity)o).leaveVehicle();
                Entity v = CollectionUtils.getRandom(vs);
                assert (v != null);
                v.eject();
                v.setPassenger((Entity)o);
            } else if (o instanceof EntityData) {
                Entity[] entityArray = vs;
                int n = vs.length;
                int n2 = 0;
                while (n2 < n) {
                    Entity v = entityArray[n2];
                    Object p = ((EntityData)o).spawn(v.getLocation());
                    if (p != null) {
                        v.setPassenger(p);
                    }
                    ++n2;
                }
            } else assert (false);
        } else {
            super.change(e, delta, mode);
        }
    }

    @Override
    protected String getPropertyName() {
        return "passenger";
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), VehicleEnterEvent.class, VehicleExitEvent.class);
    }
}

