/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Colour Armour")
@Description(value={"Colours leather armour in a given <a href='../classes/#color'>colour</a>. You can also use RGB codes if you feel limited with the 16 default colours. RGB codes are three numbers from 0 to 255 in the order <code>(red, green, blue)</code>, where <code>(0,0,0)</code> is black and <code>(255,255,255)</code> is white."})
@Examples(value={"dye player's helmet blue", "colour the player's tool red"})
@Since(value="2.0")
public class EffColorArmor
extends Effect {
    private Expression<?> items;
    @Nullable
    private Expression<Color> color;
    @Nullable
    private Expression<Number>[] rgb;

    static {
        Skript.registerEffect(EffColorArmor.class, "(dye|colo[u]r|paint) %slots/itemstack% %color%", "(dye|colo[u]r|paint) %slots/itemstack% \\(%number%, %number%, %number%\\)");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.items = exprs[0];
        if (!Slot.class.isAssignableFrom(this.items.getReturnType()) && !Changer.ChangerUtils.acceptsChange(this.items, Changer.ChangeMode.SET, ItemStack.class)) {
            Skript.error(this.items + " cannot be coloured as it cannot be changed at all.");
            return false;
        }
        if (matchedPattern == 0) {
            this.color = exprs[1];
        } else {
            this.rgb = new Expression[]{exprs[1], exprs[2], exprs[3]};
        }
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        Expression<Color> color = this.color;
        if (color != null) {
            return "dye " + this.items.toString(e, debug) + " " + color.toString(e, debug);
        }
        Expression<Number>[] rgb = this.rgb;
        assert (rgb != null);
        return "dye " + this.items.toString(e, debug) + " (" + rgb[0].toString(e, debug) + "," + rgb[1].toString(e, debug) + "," + rgb[2].toString(e, debug) + ")";
    }

    @Override
    protected void execute(Event e) {
        org.bukkit.Color c;
        if (this.color != null) {
            Color cl = this.color.getSingle(e);
            if (cl == null) {
                return;
            }
            c = cl.getBukkitColor();
        } else {
            Expression<Number>[] rgb = this.rgb;
            assert (rgb != null);
            Number r = rgb[0].getSingle(e);
            Number g = rgb[1].getSingle(e);
            Number b = rgb[2].getSingle(e);
            if (r == null || g == null || b == null) {
                return;
            }
            c = org.bukkit.Color.fromRGB((int)Math2.fit(0, r.intValue(), 255), (int)Math2.fit(0, g.intValue(), 255), (int)Math2.fit(0, b.intValue(), 255));
        }
        ?[] objArray = this.items.getArray(e);
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack i;
            Object o = objArray[n2];
            ItemStack itemStack = i = o instanceof Slot ? ((Slot)o).getItem() : (ItemStack)o;
            if (i != null) {
                if (i.getType() == Material.LEATHER_BOOTS || i.getType() == Material.LEATHER_CHESTPLATE || i.getType() == Material.LEATHER_HELMET || i.getType() == Material.LEATHER_LEGGINGS) {
                    LeatherArmorMeta m = (LeatherArmorMeta)i.getItemMeta();
                    m.setColor(c);
                    i.setItemMeta((ItemMeta)m);
                }
                if (o instanceof Slot) {
                    ((Slot)o).setItem(i);
                } else {
                    this.items.change(e, new ItemStack[]{i}, Changer.ChangeMode.SET);
                    return;
                }
            }
            ++n2;
        }
    }
}

