/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.ScriptFunction;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.parser.ScriptManager;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.PluralizingArgsMessage;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Date;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public final class ScriptLoader {
    private static final Message m_no_errors = new Message("skript.no errors");
    private static final Message m_no_scripts = new Message("skript.no scripts");
    private static final PluralizingArgsMessage m_scripts_loaded = new PluralizingArgsMessage("skript.scripts loaded");
    @Nullable
    public static Config currentScript = null;
    @Nullable
    private static Class<? extends Event>[] currentEvents = null;
    private static final Map<String, ItemType> currentAliases = new HashMap<String, ItemType>();
    static final HashMap<String, String> currentOptions = new HashMap();
    private static final ScriptManager manager = new ScriptManager();
    private static final ScriptInfo loadedScripts = new ScriptInfo();
    private static String indentation = "";
    private static final FileFilter scriptFilter = new FileFilter(){

        @Override
        public boolean accept(@Nullable File f) {
            return f != null && (f.isDirectory() || StringUtils.endsWithIgnoreCase(f.getName(), ".sk")) && !f.getName().startsWith("-");
        }
    };
    private static final Map<Thread, ParserInstance> parseThreads = new ConcurrentHashMap<Thread, ParserInstance>();

    private ScriptLoader() {
    }

    public static Map<String, ItemType> getScriptAliases() {
        return currentAliases;
    }

    static ScriptInfo loadScripts(CommandSender viewer) {
        ScriptInfo i;
        File scriptsFolder = new File(Skript.getInstance().getDataFolder(), "scripts" + File.separator);
        if (!scriptsFolder.isDirectory()) {
            scriptsFolder.mkdirs();
        }
        ErrorDescLogHandler h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(null, null, m_no_errors.toString()));
        try {
            Language.setUseLocal(false);
            i = ScriptLoader.loadScripts(scriptsFolder, viewer);
        }
        finally {
            Language.setUseLocal(true);
            h.stop();
        }
        SkriptEventHandler.registerBukkitEvents();
        return i;
    }

    public static final ScriptInfo loadScripts(File directory, CommandSender viewer) {
        boolean wasLocal = Language.setUseLocal(false);
        try {
            File[] files = directory.listFiles(scriptFilter);
            assert (files != null);
            ScriptInfo scriptInfo = ScriptLoader.loadScripts(files, viewer);
            return scriptInfo;
        }
        finally {
            if (wasLocal) {
                Language.setUseLocal(true);
            }
        }
    }

    public static final ScriptInfo loadScripts(File[] files, CommandSender viewer) {
        ScriptInfo i = new ScriptInfo();
        manager.loadAndEnable(files, viewer);
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ScriptInfo enableScripts(List<ParserInstance> parsed, CommandSender viewer) {
        Date start = new Date();
        Skript.debug("Enabling scripts...");
        ScriptInfo i = new ScriptInfo();
        for (ParserInstance pi : parsed) {
            assert (pi != null);
            ScriptLoader.enableScript(pi, i, viewer);
        }
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.add(i);
        }
        if (i.files == 0) {
            Skript.info(viewer, m_no_scripts.toString());
        }
        if (Skript.logNormal() && i.files > 0) {
            Skript.info(viewer, m_scripts_loaded.toString(i.files, i.triggers, i.commands, start.difference(new Date())));
        }
        SkriptEventHandler.registerBukkitEvents();
        parseThreads.clear();
        return i;
    }

    private static final void enableScript(ParserInstance pi, ScriptInfo i, CommandSender viewer) {
        CountingLogHandler numErrors = SkriptLogger.startLogHandler(new CountingLogHandler(SkriptLogger.SEVERE));
        Skript.debug("Enabling script " + pi.config.getFileName());
        try {
            for (ScriptCommand scriptCommand : pi.commands) {
                ++i.commands;
                Commands.registerCommand(scriptCommand);
            }
            for (ScriptFunction scriptFunction : pi.functions) {
                ++i.functions;
                Functions.functions.put(scriptFunction.getName(), new Functions.FunctionData(scriptFunction));
            }
            for (Map.Entry entry2 : pi.triggers.entrySet()) {
                ++i.triggers;
                SkriptEventHandler.addTrigger((Class[])entry2.getKey(), (Trigger)entry2.getValue());
            }
            for (Map.Entry entry3 : pi.selfRegisteringTriggers.entrySet()) {
                ((SelfRegisteringSkriptEvent)((NonNullPair)entry3.getKey()).getSecond()).register((Trigger)entry3.getValue());
                SkriptEventHandler.addSelfRegisteringTrigger((Trigger)entry3.getValue());
            }
            if (viewer instanceof ConsoleCommandSender) {
                pi.log.printLog();
            } else {
                pi.log.getLog().forEach(entry -> {
                    if (entry.level.intValue() >= Level.SEVERE.intValue()) {
                        viewer.sendMessage(String.valueOf(Skript.SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(entry.getMessage()));
                    } else {
                        viewer.sendMessage(Utils.replaceEnglishChatStyles(entry.getMessage()));
                    }
                });
            }
        }
        finally {
            numErrors.stop();
        }
        ++i.files;
    }

    static final ScriptInfo unloadScripts(File folder) {
        ScriptInfo r = ScriptLoader.unloadScripts_(folder);
        Functions.validateFunctions();
        return r;
    }

    private static final ScriptInfo unloadScripts_(File folder) {
        File[] files;
        ScriptInfo info = new ScriptInfo();
        File[] fileArray = files = folder.listFiles(scriptFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                info.add(ScriptLoader.unloadScripts_(f));
            } else if (f.getName().endsWith(".sk")) {
                info.add(ScriptLoader.unloadScript_(f));
            }
            ++n2;
        }
        return info;
    }

    static final ScriptInfo unloadScript(File script) {
        ScriptInfo r = ScriptLoader.unloadScript_(script);
        Functions.clearFunctions(script);
        return r;
    }

    public static final ScriptInfo unloadScripts(File[] files) {
        Skript.debug("Unloading (some) scripts...");
        ScriptInfo i = new ScriptInfo();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            assert (f != null);
            ScriptInfo r = ScriptLoader.unloadScript(f);
            i.commands += r.commands;
            ++i.files;
            i.functions += r.functions;
            i.triggers += r.functions;
            ++n2;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ScriptInfo unloadScript_(File script) {
        ScriptInfo info = SkriptEventHandler.removeTriggers(script);
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            loadedScripts.subtract(info);
        }
        return info;
    }

    @Nullable
    static Trigger loadTrigger(SectionNode node) {
        NonNullPair<SkriptEventInfo<?>, SkriptEvent> parsedEvent;
        ParserInstance pi = ParserInstance.DUMMY;
        String event = node.getKey();
        if (event == null) {
            assert (false) : node;
            return null;
        }
        if (event.toLowerCase().startsWith("on ")) {
            event = event.substring("on ".length());
        }
        if ((parsedEvent = SkriptParser.parseEvent(pi, event, "can't understand this event: '" + node.getKey() + "'")) == null) {
            assert (false);
            return null;
        }
        pi.setCurrentEvent("unit test", parsedEvent.getFirst().events);
        try {
            Trigger trigger = new Trigger(null, event, parsedEvent.getSecond(), pi.loadItems(node));
            return trigger;
        }
        finally {
            pi.deleteCurrentEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedScripts() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedCommands() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.commands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedFunctions() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.functions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int loadedTriggers() {
        ScriptInfo scriptInfo = loadedScripts;
        synchronized (scriptInfo) {
            return ScriptLoader.loadedScripts.triggers;
        }
    }

    public static final boolean isCurrentEvent(@Nullable Class<? extends Event> event) {
        return CollectionUtils.containsSuperclass(ScriptLoader.getCurrentEvents(), event);
    }

    @SafeVarargs
    public static final boolean isCurrentEvent(Class<? extends Event> ... events) {
        return CollectionUtils.containsAnySuperclass(ScriptLoader.getCurrentEvents(), events);
    }

    @Nullable
    public static Class<? extends Event>[] getCurrentEvents() {
        return parseThreads.get(Thread.currentThread()).getCurrentEvents();
    }

    public static void registerParseThread(ParserInstance pi) {
        parseThreads.put(Thread.currentThread(), pi);
    }

    public static class ScriptInfo {
        public int files;
        public int triggers;
        public int commands;
        public int functions;

        public ScriptInfo() {
        }

        public ScriptInfo(int numFiles, int numTriggers, int numCommands, int numFunctions) {
            this.files = numFiles;
            this.triggers = numTriggers;
            this.commands = numCommands;
            this.functions = numFunctions;
        }

        public void add(ScriptInfo other) {
            this.files += other.files;
            this.triggers += other.triggers;
            this.commands += other.commands;
            this.functions += other.functions;
        }

        public void subtract(ScriptInfo other) {
            this.files -= other.files;
            this.triggers -= other.triggers;
            this.commands -= other.commands;
            this.functions -= other.functions;
        }
    }
}

