/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.hooks.ParticlesPlugin;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.util.Color;
import ch.njol.skript.util.Direction;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.eclipse.jdt.annotation.Nullable;

public final class VisualEffect
implements SyntaxElement,
YggdrasilSerializable {
    public static boolean EFFECT_LIB = false;
    private static final String LANGUAGE_NODE = "visual effects";
    private static final String TYPE_ID = "VisualEffect.Type";
    @Nullable
    static SyntaxElementInfo<VisualEffect> info;
    static final List<Type> types;
    static final Noun[] names;
    private Type type;
    @Nullable
    private Object data;
    private float speed = 0.0f;
    private float dX;
    private float dY;
    private float dZ = 0.0f;
    @Nullable
    private org.bukkit.Color color;

    static {
        Variables.yggdrasil.registerSingleClass(Type.class, TYPE_ID);
        Variables.yggdrasil.registerSingleClass(Effect.class, "Bukkit_Effect");
        Variables.yggdrasil.registerSingleClass(EntityEffect.class, "Bukkit_EntityEffect");
        types = new ArrayList<Type>(Type.values().length);
        names = new Noun[Type.values().length];
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                Type[] ts = Type.values();
                types.clear();
                ArrayList<String> patterns = new ArrayList<String>(ts.length);
                int i = 0;
                while (i < ts.length) {
                    String node = "visual effects." + ts[i].name();
                    String pattern = Language.get_(String.valueOf(node) + ".pattern");
                    if (pattern == null) {
                        if (Skript.testing()) {
                            Skript.warning("Missing pattern at '" + node + ".pattern" + "' in the " + Language.getName() + " language file");
                        }
                    } else {
                        types.add(ts[i]);
                        if (ts[i].isColorable()) {
                            patterns.add(pattern);
                        } else {
                            String dVarExpr = Language.get_("visual effects.area_expression");
                            if (dVarExpr == null) {
                                dVarExpr = "";
                            }
                            patterns.add(String.valueOf(pattern) + " " + dVarExpr);
                        }
                    }
                    if (names[i] == null) {
                        VisualEffect.names[i] = new Noun(String.valueOf(node) + ".name");
                    }
                    ++i;
                }
                String[] ps = patterns.toArray(new String[patterns.size()]);
                if (!$assertionsDisabled && ps == null) {
                    throw new AssertionError();
                }
                info = new SyntaxElementInfo<VisualEffect>(ps, VisualEffect.class);
            }
        });
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = types.get(matchedPattern);
        if (this.type.isColorable()) {
            Expression<?>[] expressionArray = exprs;
            int n = exprs.length;
            int n2 = 0;
            while (n2 < n) {
                Expression<?> expr = expressionArray[n2];
                if (expr != null) {
                    if (expr.getReturnType() == Color.class) {
                        this.color = ((Color)expr.getSingle(null)).getBukkitColor();
                    } else {
                        this.data = expr.getSingle(null);
                    }
                }
                ++n2;
            }
        } else {
            int numberParams = 0;
            Expression<?>[] expressionArray = exprs;
            int n = exprs.length;
            int n3 = 0;
            while (n3 < n) {
                Expression<?> expr = expressionArray[n3];
                if (expr.getReturnType() == Long.class || expr.getReturnType() == Integer.class || expr.getReturnType() == Number.class) {
                    ++numberParams;
                }
                ++n3;
            }
            int dPos = 0;
            Expression<?> expr = exprs[0];
            if (expr.getReturnType() != Long.class && expr.getReturnType() != Integer.class && expr.getReturnType() != Number.class) {
                dPos = 1;
                this.data = exprs[0].getSingle(null);
            }
            if (numberParams == 1) {
                this.speed = ((Number)exprs[dPos].getSingle(null)).floatValue();
            } else if (numberParams == 3) {
                this.dX = ((Number)exprs[dPos].getSingle(null)).floatValue();
                this.dY = ((Number)exprs[dPos + 1].getSingle(null)).floatValue();
                this.dZ = ((Number)exprs[dPos + 2].getSingle(null)).floatValue();
            } else if (numberParams == 4) {
                this.dX = ((Number)exprs[dPos].getSingle(null)).floatValue();
                this.dY = ((Number)exprs[dPos + 1].getSingle(null)).floatValue();
                this.dZ = ((Number)exprs[dPos + 2].getSingle(null)).floatValue();
                this.speed = ((Number)exprs[dPos + 3].getSingle(null)).floatValue();
            }
        }
        return true;
    }

    public boolean isEntityEffect() {
        return this.type.effect instanceof EntityEffect;
    }

    @Nullable
    public static final VisualEffect parse(String s, ParserInstance pi) {
        SyntaxElementInfo<VisualEffect> info = VisualEffect.info;
        if (info == null) {
            return null;
        }
        return SkriptParser.parseStatic(pi, Noun.stripIndefiniteArticle(s), new SingleItemIterator<SyntaxElementInfo<VisualEffect>>(info), null);
    }

    public void play(@Nullable Player[] ps, Location l, @Nullable Entity e) {
        this.play(ps, l, e, 0, 32);
    }

    public void play(@Nullable Player[] ps, Location l, @Nullable Entity e, int count, int radius) {
        assert (e == null || l.equals((Object)e.getLocation()));
        if (this.isEntityEffect()) {
            if (e != null) {
                e.playEffect((EntityEffect)this.type.effect);
            }
        } else if (EFFECT_LIB && ((Effect)this.type.effect).getType() == Effect.Type.PARTICLE) {
            ParticlesPlugin<?> plugin = ParticlesPlugin.plugin;
            assert (plugin != null);
            plugin.playEffect(ps, l, count, radius, this.type, this.data, this.speed, this.dX, this.dY, this.dZ, this.color);
        } else if (ps == null) {
            int id = 0;
            byte dataId = 0;
            Object pData = this.type.getData(this.data, l);
            if (pData instanceof Material) {
                id = ((Material)pData).getId();
            } else if (pData instanceof MaterialData) {
                id = ((MaterialData)pData).getItemTypeId();
                dataId = ((MaterialData)pData).getData();
            }
            l.getWorld().spigot().playEffect(l, (Effect)this.type.effect, id, (int)dataId, this.dX, this.dY, this.dZ, this.speed, count, radius);
        } else {
            Player[] playerArray = ps;
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                p.playEffect(l, (Effect)this.type.effect, this.type.getData(this.data, l));
                ++n2;
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int flags) {
        return names[this.type.ordinal()].toString(flags);
    }

    public static String getAllNames() {
        return StringUtils.join(names, ", ");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        Object d = this.data;
        result = 31 * result + (d == null ? 0 : d.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VisualEffect)) {
            return false;
        }
        VisualEffect other = (VisualEffect)obj;
        if (this.type != other.type) {
            return false;
        }
        Object d = this.data;
        return !(d == null ? other.data != null : !d.equals(other.data));
    }

    public static class Type
    extends Enum<Type>
    implements YggdrasilSerializable {
        public static final /* enum */ Type ENDER_SIGNAL = new Type(Effect.ENDER_SIGNAL);
        public static final /* enum */ Type MOBSPAWNER_FLAMES = new Type(Effect.MOBSPAWNER_FLAMES);
        public static final /* enum */ Type POTION_BREAK = new Type(Effect.POTION_BREAK){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                return new PotionEffect(raw == null ? PotionEffectType.SPEED : (PotionEffectType)raw, 1, 0);
            }
        };
        public static final /* enum */ Type SMOKE = new Type(Effect.SMOKE){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                if (raw == null) {
                    return BlockFace.SELF;
                }
                return Direction.getFacing(((Direction)raw).getDirection(l), false);
            }
        };
        public static final /* enum */ Type HURT = new Type(EntityEffect.HURT);
        public static final /* enum */ Type SHEEP_EAT = new Type(EntityEffect.SHEEP_EAT);
        public static final /* enum */ Type WOLF_HEARTS = new Type(EntityEffect.WOLF_HEARTS);
        public static final /* enum */ Type WOLF_SHAKE = new Type(EntityEffect.WOLF_SHAKE);
        public static final /* enum */ Type WOLF_SMOKE = new Type(EntityEffect.WOLF_SMOKE);
        public static final /* enum */ Type FIREWORKS_SPARK = new Type(Effect.FIREWORKS_SPARK);
        public static final /* enum */ Type CRIT = new Type(Effect.CRIT);
        public static final /* enum */ Type MAGIC_CRIT = new Type(Effect.MAGIC_CRIT);
        public static final /* enum */ Type POTION_SWIRL = new Type(Effect.POTION_SWIRL){

            @Override
            public boolean isColorable() {
                return true;
            }
        };
        public static final /* enum */ Type POTION_SWIRL_TRANSPARENT = new Type(Effect.POTION_SWIRL_TRANSPARENT){

            @Override
            public boolean isColorable() {
                return true;
            }
        };
        public static final /* enum */ Type SPELL = new Type(Effect.SPELL);
        public static final /* enum */ Type INSTANT_SPELL = new Type(Effect.INSTANT_SPELL);
        public static final /* enum */ Type WITCH_SPELL = new Type(Effect.WITCH_MAGIC);
        public static final /* enum */ Type NOTE = new Type(Effect.NOTE);
        public static final /* enum */ Type PORTAL = new Type(Effect.PORTAL);
        public static final /* enum */ Type FLYING_GLYPH = new Type(Effect.FLYING_GLYPH);
        public static final /* enum */ Type FLAME = new Type(Effect.FLAME);
        public static final /* enum */ Type LAVA_POP = new Type(Effect.LAVA_POP);
        public static final /* enum */ Type FOOTSTEP = new Type(Effect.FOOTSTEP);
        public static final /* enum */ Type SPLASH = new Type(Effect.SPLASH);
        public static final /* enum */ Type PARTICLE_SMOKE = new Type(Effect.PARTICLE_SMOKE);
        public static final /* enum */ Type EXPLOSION_HUGE = new Type(Effect.EXPLOSION_HUGE);
        public static final /* enum */ Type EXPLOSION_LARGE = new Type(Effect.EXPLOSION_LARGE);
        public static final /* enum */ Type EXPLOSION = new Type(Effect.EXPLOSION);
        public static final /* enum */ Type VOID_FOG = new Type(Effect.VOID_FOG);
        public static final /* enum */ Type SMALL_SMOKE = new Type(Effect.SMALL_SMOKE);
        public static final /* enum */ Type CLOUD = new Type(Effect.CLOUD);
        public static final /* enum */ Type COLOURED_DUST = new Type(Effect.COLOURED_DUST){

            @Override
            public boolean isColorable() {
                return true;
            }
        };
        public static final /* enum */ Type SNOWBALL_BREAK = new Type(Effect.SNOWBALL_BREAK);
        public static final /* enum */ Type WATER_DRIP = new Type(Effect.WATERDRIP);
        public static final /* enum */ Type LAVA_DRIP = new Type(Effect.LAVADRIP);
        public static final /* enum */ Type SNOW_SHOVEL = new Type(Effect.SNOW_SHOVEL);
        public static final /* enum */ Type SLIME = new Type(Effect.SLIME);
        public static final /* enum */ Type HEART = new Type(Effect.HEART);
        public static final /* enum */ Type ANGRY_VILLAGER = new Type(Effect.VILLAGER_THUNDERCLOUD);
        public static final /* enum */ Type HAPPY_VILLAGER = new Type(Effect.HAPPY_VILLAGER);
        public static final /* enum */ Type LARGE_SMOKE = new Type(Effect.LARGE_SMOKE);
        public static final /* enum */ Type ITEM_CRACK = new Type(Effect.ITEM_BREAK){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                if (raw == null) {
                    return Material.IRON_SWORD;
                }
                if (raw instanceof ItemType) {
                    ItemStack rand = ((ItemType)raw).getRandom();
                    if (rand == null) {
                        return Material.IRON_SWORD;
                    }
                    Material type = rand.getType();
                    if (!$assertionsDisabled && type == null) {
                        throw new AssertionError();
                    }
                    return type;
                }
                return raw;
            }
        };
        public static final /* enum */ Type BLOCK_BREAK = new Type(Effect.TILE_BREAK){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                if (raw == null) {
                    return Material.STONE.getData();
                }
                if (raw instanceof ItemType) {
                    ItemStack rand = ((ItemType)raw).getRandom();
                    if (rand == null) {
                        return Material.STONE.getData();
                    }
                    MaterialData type = rand.getData();
                    if (!$assertionsDisabled && type == null) {
                        throw new AssertionError();
                    }
                    return type;
                }
                return raw;
            }
        };
        public static final /* enum */ Type BLOCK_DUST = new Type(Effect.TILE_DUST){

            @Override
            public Object getData(@Nullable Object raw, Location l) {
                if (raw == null) {
                    return Material.STONE.getData();
                }
                if (raw instanceof ItemType) {
                    ItemStack rand = ((ItemType)raw).getRandom();
                    if (rand == null) {
                        return Material.STONE.getData();
                    }
                    MaterialData type = rand.getData();
                    if (!$assertionsDisabled && type == null) {
                        throw new AssertionError();
                    }
                    return type;
                }
                return raw;
            }
        };
        final Object effect;
        @Nullable
        final String name;
        private static final /* synthetic */ Type[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Type[]{ENDER_SIGNAL, MOBSPAWNER_FLAMES, POTION_BREAK, SMOKE, HURT, SHEEP_EAT, WOLF_HEARTS, WOLF_SHAKE, WOLF_SMOKE, FIREWORKS_SPARK, CRIT, MAGIC_CRIT, POTION_SWIRL, POTION_SWIRL_TRANSPARENT, SPELL, INSTANT_SPELL, WITCH_SPELL, NOTE, PORTAL, FLYING_GLYPH, FLAME, LAVA_POP, FOOTSTEP, SPLASH, PARTICLE_SMOKE, EXPLOSION_HUGE, EXPLOSION_LARGE, EXPLOSION, VOID_FOG, SMALL_SMOKE, CLOUD, COLOURED_DUST, SNOWBALL_BREAK, WATER_DRIP, LAVA_DRIP, SNOW_SHOVEL, SLIME, HEART, ANGRY_VILLAGER, HAPPY_VILLAGER, LARGE_SMOKE, ITEM_CRACK, BLOCK_BREAK, BLOCK_DUST};
        }

        private Type(Effect effect) {
            this.effect = effect;
            this.name = effect.getName();
        }

        private Type(EntityEffect effect) {
            this.effect = effect;
            this.name = null;
        }

        @Nullable
        public Object getData(@Nullable Object raw, Location l) {
            assert (raw == null);
            return null;
        }

        public boolean isColorable() {
            return false;
        }

        @Nullable
        public String getMinecraftName() {
            return this.name;
        }

        public static Type[] values() {
            Type[] typeArray = ENUM$VALUES;
            int n = typeArray.length;
            Type[] typeArray2 = new Type[n];
            System.arraycopy(ENUM$VALUES, 0, typeArray2, 0, n);
            return typeArray2;
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }
    }
}

