/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.parser;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.parser.LoaderInstance;
import ch.njol.skript.lang.parser.ParserInstance;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptManager {
    private AtomicInteger waitLoading = new AtomicInteger();
    private Map<String, Config> loadMap = new ConcurrentHashMap<String, Config>();
    private AtomicInteger waitParsing = new AtomicInteger();
    private List<ParserInstance> parsed = Collections.synchronizedList(new ArrayList());
    private ExecutorService pool = Executors.newCachedThreadPool();
    @Nullable
    private Thread lockedThread;
    private static final ReentrantLock lock = new ReentrantLock(true);
    private CommandSender viewer;

    public void loadAndEnable(final File[] files, final CommandSender viewer) {
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                Skript.debug("Trying to load scripts asynchronously...");
                final List<ParserInstance> parsed = ScriptManager.this.load(files);
                Skript.debug("Done parsing scripts");
                new BukkitRunnable(){

                    public void run() {
                        ScriptLoader.unloadScripts(files);
                        ScriptLoader.enableScripts(parsed, viewer);
                    }
                }.runTask((Plugin)Skript.getInstance());
            }
        });
    }

    public List<ParserInstance> load(File[] files) {
        lock.lock();
        Skript.debug("Lock acquired for loading scripts");
        this.lockedThread = Thread.currentThread();
        int numScripts = files.length;
        if (numScripts == 0) {
            return Collections.emptyList();
        }
        this.loadMap = new ConcurrentHashMap<String, Config>();
        this.waitLoading.set(numScripts);
        this.parsed = Collections.synchronizedList(new ArrayList());
        this.waitParsing.set(numScripts);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f != null) {
                this.pool.execute(new LoaderInstance(f.getName(), f, this, this.pool));
            }
            ++n2;
        }
        while (this.waitLoading.get() > 0) {
            LockSupport.park();
        }
        for (Map.Entry<String, Config> entry : this.loadMap.entrySet()) {
            this.pool.execute(new ParserInstance(entry.getKey(), entry.getValue(), this));
        }
        while (this.waitParsing.get() > 0) {
            LockSupport.park();
        }
        lock.unlock();
        this.parsed.sort(null);
        return new ArrayList<ParserInstance>(this.parsed);
    }

    public void loadReady(String file, Config config) {
        int counter = this.waitLoading.decrementAndGet();
        this.loadMap.put(file, config);
        if (counter < 1) {
            LockSupport.unpark(this.lockedThread);
        }
    }

    public void parseReady(ParserInstance pi) {
        int counter = this.waitParsing.decrementAndGet();
        this.parsed.add(pi);
        if (counter < 1) {
            LockSupport.unpark(this.lockedThread);
        }
    }
}

