/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.parser.ParserInstance;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class Conditional
extends TriggerSection {
    private final Condition cond;
    @Nullable
    private TriggerSection elseClause = null;
    private ParserInstance pi;

    public Conditional(Condition cond, SectionNode node, ParserInstance pi) {
        super(node, pi);
        this.cond = cond;
        this.pi = pi;
    }

    @Override
    @Nullable
    protected TriggerItem walk(Event e) {
        if (this.cond.run(e)) {
            return this.walk(e, true);
        }
        this.debug(e, false);
        if (this.elseClause != null) {
            return this.elseClause;
        }
        return this.getNext();
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.cond.toString(e, debug);
    }

    public void loadElseClause(SectionNode node) {
        assert (this.elseClause == null || this.elseClause instanceof Conditional);
        if (this.elseClause != null) {
            ((Conditional)this.elseClause).loadElseClause(node);
            return;
        }
        this.elseClause = new TriggerSection(node, this.pi){

            @Override
            @Nullable
            public TriggerItem walk(Event e) {
                return this.walk(e, true);
            }

            @Override
            public String toString(@Nullable Event e, boolean debug) {
                return "else";
            }
        }.setParent(this.getParent()).setNext(this.getNext());
    }

    public void loadElseIf(Condition cond, SectionNode n) {
        assert (this.elseClause == null || this.elseClause instanceof Conditional);
        if (this.elseClause != null) {
            ((Conditional)this.elseClause).loadElseIf(cond, n);
            return;
        }
        this.elseClause = new Conditional(cond, n, this.pi).setParent(this.getParent()).setNext(this.getNext());
    }

    public boolean hasElseClause() {
        return this.elseClause != null && !(this.elseClause instanceof Conditional);
    }

    @Override
    public Conditional setNext(@Nullable TriggerItem next) {
        super.setNext(next);
        if (this.elseClause != null) {
            this.elseClause.setNext(next);
        }
        return this;
    }

    @Override
    public Conditional setParent(@Nullable TriggerSection parent) {
        super.setParent(parent);
        if (this.elseClause != null) {
            this.elseClause.setParent(parent);
        }
        return this;
    }
}

