/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Kleenean;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Targeted Block")
@Description(value={"The block at the crosshair. This regards all blocks that are not air as fully opaque, e.g. torches will be like a solid stone block for this expression."})
@Examples(value={"# A command to set the block a player looks at to a specific type:", "command /setblock <material>:", "    trigger:", "        set targeted block to argument"})
@Since(value="1.0")
public class ExprTargetedBlock
extends PropertyExpression<Player, Block> {
    private boolean actualTargetedBlock;
    @Nullable
    private static Event last;
    private static final WeakHashMap<Player, Block> targetedBlocks;
    private static long blocksValidForTick;

    static {
        Skript.registerExpression(ExprTargetedBlock.class, Block.class, ExpressionType.COMBINED, "[the] target[ed] block[s] [of %players%]", "%players%'[s] target[ed] block[s]", "[the] actual[ly] target[ed] block[s] [of %players%]", "%players%'[s] actual[ly] target[ed] block[s]");
        last = null;
        targetedBlocks = new WeakHashMap();
        blocksValidForTick = 0L;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.setExpr(exprs[0]);
        this.actualTargetedBlock = matchedPattern >= 2;
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return "the targeted block" + (this.getExpr().isSingle() ? "" : "s") + " of " + this.getExpr().toString(e, debug);
        }
        return Classes.getDebugMessage(this.getAll(e));
    }

    @Nullable
    Block getTargetedBlock(@Nullable Player p, Event e) {
        if (p == null) {
            return null;
        }
        long time = ((World)Bukkit.getWorlds().get(0)).getFullTime();
        if (last != e || time != blocksValidForTick) {
            targetedBlocks.clear();
            blocksValidForTick = time;
            last = e;
        }
        if (!this.actualTargetedBlock && this.getTime() <= 0 && targetedBlocks.containsKey(p)) {
            return targetedBlocks.get(p);
        }
        try {
            Block b = Skript.methodExists(Player.class, "getTargetBlock", Set.class, Integer.TYPE) ? p.getTargetBlock(null, SkriptConfig.maxTargetBlockDistance.value().intValue()) : p.getTargetBlock(null, SkriptConfig.maxTargetBlockDistance.value().intValue());
            if (b.getType() == Material.AIR) {
                b = null;
            }
            targetedBlocks.put(p, b);
            return b;
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    protected Block[] get(final Event e, Player[] source) {
        return this.get(source, new Converter<Player, Block>(){

            @Override
            @Nullable
            public Block convert(Player p) {
                return ExprTargetedBlock.this.getTargetedBlock(p, e);
            }
        });
    }

    @Override
    public Class<Block> getReturnType() {
        return Block.class;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public boolean setTime(int time) {
        super.setTime(time);
        return true;
    }
}

