/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.Math2;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Rounding")
@Description(value={"Rounds numbers normally, up (ceiling) or down (floor) respectively"})
@Examples(value={"set {var} to rounded health of player", "set line 1 of the block to round(1.5 * player's level)", "set {_x} to floor({_y}) - ceil({_x})", "add rounded down argument to the player's health"})
@Since(value="2.0")
public class ExprRound
extends PropertyExpression<Number, Long> {
    int action;

    static {
        Skript.registerExpression(ExprRound.class, Long.class, ExpressionType.PROPERTY, "(a|the|) round[ed] down %number%", "(a|the|) round[ed] %number%", "(a|the|) round[ed] up %number%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.action = matchedPattern - 1;
        return true;
    }

    protected Long[] get(Event e, Number[] source) {
        return this.get(source, new Converter<Number, Long>(){

            @Override
            public Long convert(Number n) {
                if (n instanceof Integer) {
                    return n.longValue();
                }
                if (n instanceof Long) {
                    return (Long)n;
                }
                return ExprRound.this.action == -1 ? Math2.floor(n.doubleValue()) : (ExprRound.this.action == 0 ? Math2.round(n.doubleValue()) : Math2.ceil(n.doubleValue()));
            }
        });
    }

    @Override
    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return String.valueOf(this.action == -1 ? "floor" : (this.action == 0 ? "round" : "ceil")) + "(" + this.getExpr().toString(e, debug) + ")";
    }
}

