/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.ScriptOptions;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Loop value")
@Description(value={"The currently looped value."})
@Examples(value={"# countdown:", "loop 10 times:", "\tmessage \"%11 - loop-number%\"", "\twait a second", "# generate a 10x10 floor made of randomly coloured wool below the player:", "loop blocks from the block below the player to the block 10 east of the block below the player:", "\tloop blocks from the loop-block to the block 10 north of the loop-block:", "\t\tset loop-block-2 to any wool"})
@Since(value="1.0")
public class ExprLoopValue
extends SimpleExpression<Object> {
    private String name;
    private Loop loop;
    boolean isVariableLoop = false;
    boolean isIndex = false;

    static {
        Skript.registerExpression(ExprLoopValue.class, Object.class, ExpressionType.SIMPLE, "[the] loop-<.+>");
    }

    @Override
    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.name = parser.expr;
        String s = parser.regexes.get(0).group();
        int i = -1;
        Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(s);
        if (m.matches()) {
            s = m.group(1);
            i = Utils.parseInt(m.group(2));
        }
        Class<?> c = Classes.getClassFromUserInput(s);
        int j = 1;
        Loop loop = null;
        boolean b = ScriptOptions.getInstance().usesNewLoops(this.pi.config.getFile());
        for (Loop l : this.pi.currentLoops) {
            if (!(c != null && c.isAssignableFrom(l.getLoopedExpression().getReturnType()) || b && "value".equals(s)) && !l.getLoopedExpression().isLoopOf(s)) continue;
            if (j < i) {
                ++j;
                continue;
            }
            if (loop != null) {
                Skript.error("There are multiple loops that match loop-" + s + ". Use loop-" + s + "-1/2/3/etc. to specify which loop's value you want.", ErrorQuality.SEMANTIC_ERROR);
                return false;
            }
            loop = l;
            if (j == i) break;
        }
        if (loop == null) {
            Skript.error("There's no loop that matches 'loop-" + s + "'", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        if (loop.getLoopedExpression() instanceof Variable) {
            this.isVariableLoop = true;
            if (((Variable)loop.getLoopedExpression()).isIndexLoop(s)) {
                this.isIndex = true;
            }
        }
        this.loop = loop;
        return true;
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    @Nullable
    protected <R> ConvertedExpression<Object, ? extends R> getConvertedExpr(final Class<R> ... to) {
        if (this.isVariableLoop && !this.isIndex) {
            return new ConvertedExpression(this, Utils.getSuperType(to), new Converter<Object, R>(){

                @Override
                @Nullable
                public R convert(Object o) {
                    return Converters.convert(o, to);
                }
            });
        }
        return super.getConvertedExpr(to);
    }

    @Override
    public Class<? extends Object> getReturnType() {
        if (this.isIndex) {
            return String.class;
        }
        return this.loop.getLoopedExpression().getReturnType();
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        if (this.isVariableLoop) {
            Map.Entry current = (Map.Entry)this.loop.getCurrent(e);
            if (current == null) {
                return null;
            }
            if (this.isIndex) {
                return new String[]{(String)current.getKey()};
            }
            Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
            one[0] = current.getValue();
            return one;
        }
        Object[] one = (Object[])Array.newInstance(this.getReturnType(), 1);
        one[0] = this.loop.getCurrent(e);
        return one;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return this.name;
        }
        if (this.isVariableLoop) {
            Map.Entry current = (Map.Entry)this.loop.getCurrent(e);
            if (current == null) {
                return Classes.getDebugMessage(null);
            }
            return this.isIndex ? "\"" + (String)current.getKey() + "\"" : Classes.getDebugMessage(current.getValue());
        }
        return Classes.getDebugMessage(this.loop.getCurrent(e));
    }
}

