/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.events.bukkit.ExperienceSpawnEvent;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Experience;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Experience")
@Description(value={"How much experience was spawned in an <a href='../events/#experience_spawn'>experience spawn</a> event. Can be changed."})
@Examples(value={"on experience spawn:", "\tadd 5 to the spawned experience"})
@Since(value="2.1")
@Events(value={"experience spawn"})
public class ExprExperience
extends SimpleExpression<Experience> {
    static {
        Skript.registerExpression(ExprExperience.class, Experience.class, ExpressionType.SIMPLE, "[the] (spawned|dropped|) [e]xp[erience] [orb[s]]");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!this.pi.isCurrentEvent((Class<? extends Event>)ExperienceSpawnEvent.class)) {
            Skript.error("The experience expression can only be used in experience spawn events");
            return false;
        }
        return true;
    }

    @Nullable
    protected Experience[] get(Event e) {
        if (!(e instanceof ExperienceSpawnEvent)) {
            return new Experience[0];
        }
        return new Experience[]{new Experience(((ExperienceSpawnEvent)e).getSpawnedXP())};
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case ADD: 
            case REMOVE: 
            case REMOVE_ALL: 
            case DELETE: {
                return new Class[]{Experience[].class, Number[].class};
            }
            case SET: {
                return new Class[]{Experience.class, Number.class};
            }
            case RESET: {
                return null;
            }
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (!(e instanceof ExperienceSpawnEvent)) {
            return;
        }
        if (delta == null) {
            ((ExperienceSpawnEvent)e).setSpawnedXP(0);
            return;
        }
        double d = 0.0;
        Object[] objectArray = delta;
        int n = delta.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            double v = o instanceof Experience ? (double)((Experience)o).getXP() : ((Number)o).doubleValue();
            switch (mode) {
                case ADD: 
                case SET: {
                    d += v;
                    break;
                }
                case REMOVE: 
                case REMOVE_ALL: {
                    d -= v;
                    break;
                }
                case DELETE: 
                case RESET: {
                    assert (false);
                    break;
                }
            }
            ++n2;
        }
        ((ExperienceSpawnEvent)e).setSpawnedXP(Math.max(0, (int)Math.round((double)((ExperienceSpawnEvent)e).getSpawnedXP() + d)));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Experience> getReturnType() {
        return Experience.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the experience";
    }
}

