/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.NullableChecker;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import ch.njol.util.coll.iterator.NonNullIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Entities")
@Description(value={"all entities in all world, in a specific world or in a radius around a certain location, e.g. 'all players', 'all creepers in the player's world', or 'players in radius 100 of the player'."})
@Examples(value={"kill all creepers in the player's world", "send \"Psst!\" to all players witin 100 meters of the player", "give a diamond to all ops", "heal all tamed wolves in radius 2000 around {town center}"})
@Since(value="1.2.1")
public class ExprEntities
extends SimpleExpression<Entity> {
    Expression<? extends EntityData<?>> types;
    @Nullable
    Expression<World> worlds;
    @Nullable
    private Expression<Number> radius;
    @Nullable
    private Expression<Location> center;
    @Nullable
    private Expression<? extends Entity> centerEntity;
    Class<? extends Entity> returnType = Entity.class;
    private int matchedPattern;

    static {
        Skript.registerExpression(ExprEntities.class, Entity.class, ExpressionType.PATTERN_MATCHES_EVERYTHING, "[all] %*entitydatas% [(in|of) [world[s]] %-worlds%]", "[all] entities of type[s] %entitydatas% [(in|of) [world[s]] %-worlds%]", "[all] %*entitydatas% (within|[with]in radius) %number% [(block[s]|met(er|re)[s])] (of|around) %location%", "[all] entities of type[s] %entitydatas% in radius %number% (of|around) %location%");
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.matchedPattern = matchedPattern;
        this.types = exprs[0];
        if (matchedPattern % 2 == 0) {
            EntityData[] entityDataArray = (EntityData[])((Literal)this.types).getAll();
            int n = entityDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityData d = entityDataArray[n2];
                if (d.isPlural().isFalse() || d.isPlural().isUnknown() && !StringUtils.startsWithIgnoreCase(parseResult.expr, "all")) {
                    return false;
                }
                ++n2;
            }
        }
        if (matchedPattern < 2) {
            this.worlds = exprs[exprs.length - 1];
        } else {
            this.radius = exprs[exprs.length - 2];
            this.center = exprs[exprs.length - 1];
            BlockingLogHandler log = SkriptLogger.startLogHandler(new BlockingLogHandler());
            try {
                this.centerEntity = this.center.getSource().getConvertedExpression(Entity.class);
            }
            finally {
                log.stop();
            }
        }
        if (this.types instanceof Literal && ((EntityData[])((Literal)this.types).getAll()).length == 1) {
            this.returnType = ((EntityData)((Literal)this.types).getSingle()).getType();
        }
        return true;
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return this.returnType;
    }

    @Nullable
    protected Entity[] get(Event e) {
        if (this.matchedPattern >= 2) {
            Iterator<? extends Entity> iter = this.iterator(e);
            if (iter == null || !iter.hasNext()) {
                return new Entity[0];
            }
            ArrayList<Entity> l = new ArrayList<Entity>();
            while (iter.hasNext()) {
                l.add(iter.next());
            }
            return l.toArray((Entity[])Array.newInstance(this.returnType, l.size()));
        }
        return EntityData.getAll((EntityData[])this.types.getAll(e), this.returnType, this.worlds != null ? this.worlds.getArray(e) : null);
    }

    @Override
    public boolean isLoopOf(String s) {
        if (!(this.types instanceof Literal)) {
            return false;
        }
        BlockingLogHandler h = SkriptLogger.startLogHandler(new BlockingLogHandler());
        try {
            EntityData<?> d = EntityData.parseWithoutIndefiniteArticle(s, this.pi);
            if (d != null) {
                EntityData[] entityDataArray = (EntityData[])((Literal)this.types).getAll();
                int n = entityDataArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EntityData t = entityDataArray[n2];
                    assert (t != null);
                    if (!d.isSupertypeOf(t)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        finally {
            h.stop();
        }
        return false;
    }

    @Override
    @Nullable
    public Iterator<? extends Entity> iterator(Event e) {
        if (this.matchedPattern >= 2) {
            Location l;
            if (this.centerEntity != null) {
                Entity en = this.centerEntity.getSingle(e);
                if (en == null) {
                    return null;
                }
                l = en.getLocation();
            } else {
                assert (this.center != null);
                l = this.center.getSingle(e);
                if (l == null) {
                    return null;
                }
            }
            assert (this.radius != null);
            Number n = this.radius.getSingle(e);
            if (n == null) {
                return null;
            }
            double d = n.doubleValue();
            Collection es = l.getWorld().getNearbyEntities(l, d, d, d);
            final double radiusSquared = d * d * 1.00001;
            final EntityData[] ts = this.types.getAll(e);
            return new CheckedIterator<Entity>(es.iterator(), new NullableChecker<Entity>(){

                @Override
                public boolean check(@Nullable Entity e) {
                    if (e == null || e.getLocation().distanceSquared(l) > radiusSquared) {
                        return false;
                    }
                    EntityData[] entityDataArray = ts;
                    int n = ts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EntityData t = entityDataArray[n2];
                        if (t.isInstance(e)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
        }
        if (this.worlds == null && this.returnType == Player.class) {
            return super.iterator(e);
        }
        return new NonNullIterator<Entity>(e){
            private final World[] ws;
            private int w;
            private final EntityData<?>[] ts;
            @Nullable
            private Iterator<? extends Entity> curIter;
            {
                this.ws = ExprEntities.this.worlds == null ? Bukkit.getWorlds().toArray(new World[0]) : ExprEntities.this.worlds.getArray(event);
                this.w = -1;
                this.ts = ExprEntities.this.types.getAll(event);
                this.curIter = null;
            }

            /*
             * Exception decompiling
             */
            @Override
            @Nullable
            protected Entity getNext() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[UNCONDITIONALDOLOOP]], but top level block is 2[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "all entities of types " + this.types.toString(e, debug) + (this.worlds != null ? " in " + this.worlds.toString(e, debug) : (this.radius != null && this.center != null ? " in radius " + this.radius.toString(e, debug) + " around " + this.center.toString(e, debug) : ""));
    }
}

