/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.parser;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.command.Commands;
import ch.njol.skript.command.ScriptCommand;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.EntryNode;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.config.SimpleNode;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Conditional;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Loop;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SelfRegisteringSkriptEvent;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.While;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.parser.ScriptManager;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Callback;
import ch.njol.util.Kleenean;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class ScriptProcessor
implements Runnable {
    private Config config;
    private ScriptManager manager;
    Map<String, ItemType> aliases;
    Map<String, String> options;
    private int numCommands;
    private int numFunctions;
    private int numTriggers;
    private List<ScriptCommand> commands;
    private List<Trigger> selfRegisteringTriggers;
    private Map<Class<? extends Event>[], Trigger> triggers;
    private String indentation = "";
    private Kleenean hasDelayBefore = Kleenean.FALSE;
    @Nullable
    private Class<? extends Event>[] currentEvents = null;
    @Nullable
    private String currentEventName = null;

    public ScriptProcessor(Config config, ScriptManager manager) {
        this.config = config;
        this.manager = manager;
        this.aliases = new HashMap<String, ItemType>();
        this.options = new HashMap<String, String>();
        this.commands = new ArrayList<ScriptCommand>();
        this.selfRegisteringTriggers = new ArrayList<Trigger>();
        this.triggers = new HashMap<Class<? extends Event>[], Trigger>();
    }

    @SafeVarargs
    public final void setCurrentEvent(String name, Class<? extends Event> ... events) {
        this.currentEventName = name;
        this.currentEvents = events;
        this.hasDelayBefore = Kleenean.FALSE;
    }

    public void deleteCurrentEvent() {
        this.currentEventName = null;
        this.currentEvents = null;
        this.hasDelayBefore = Kleenean.FALSE;
    }

    public String replaceOptions(String s) {
        String r = StringUtils.replaceAll((CharSequence)s, "\\{@(.+?)\\}", new Callback<String, Matcher>(){

            @Override
            @Nullable
            public String run(Matcher m) {
                String option = ScriptProcessor.this.options.get(m.group(1));
                if (option == null) {
                    Skript.error("undefined option " + m.group());
                    return m.group();
                }
                return option;
            }
        });
        assert (r != null);
        return r;
    }

    public List<TriggerItem> loadItems(SectionNode node) {
        if (Skript.debug()) {
            this.indentation = String.valueOf(this.indentation) + "    ";
        }
        ArrayList<TriggerItem> items = new ArrayList<TriggerItem>();
        Kleenean hadDelayBeforeLastIf = Kleenean.FALSE;
        for (Node n : node) {
            Kleenean hadDelayBefore;
            Statement cond;
            String l;
            String name;
            SkriptLogger.setNode(n);
            if (n instanceof SimpleNode) {
                Statement stmt;
                SimpleNode e = (SimpleNode)n;
                String s = this.replaceOptions(e.getKey());
                if (!SkriptParser.validateLine(s) || (stmt = Statement.parse(s, "Can't understand this condition/effect: " + s)) == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(this.indentation) + stmt.toString(null, true));
                }
                items.add(stmt);
                if (!(stmt instanceof Delay)) continue;
                this.hasDelayBefore = Kleenean.TRUE;
                continue;
            }
            if (!(n instanceof SectionNode) || !SkriptParser.validateLine(name = this.replaceOptions(n.getKey()))) continue;
            if (StringUtils.startsWithIgnoreCase(name, "loop ")) {
                Expression<Object> loopedExpr;
                l = name.substring("loop ".length());
                RetainingLogHandler h = SkriptLogger.startRetainingLog();
                try {
                    loopedExpr = new SkriptParser(l).parseExpression(Object.class);
                    if (loopedExpr != null) {
                        loopedExpr = loopedExpr.getConvertedExpression(Object.class);
                    }
                    if (loopedExpr == null) {
                        h.printErrors("Can't understand this loop: '" + name + "'");
                        continue;
                    }
                    h.printLog();
                }
                finally {
                    h.stop();
                }
                if (loopedExpr.isSingle()) {
                    Skript.error("Can't loop " + loopedExpr + " because it's only a single value");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(this.indentation) + "loop " + loopedExpr.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore2 = this.hasDelayBefore;
                items.add(new Loop(loopedExpr, (SectionNode)n));
                if (hadDelayBefore2 == Kleenean.TRUE || this.hasDelayBefore == Kleenean.FALSE) continue;
                this.hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "while ")) {
                l = name.substring("while ".length());
                Statement c = Condition.parse(l, "Can't understand this condition: " + l);
                if (c == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(this.indentation) + "while " + c.toString(null, true) + ":");
                }
                Kleenean hadDelayBefore3 = this.hasDelayBefore;
                items.add(new While((Condition)c, (SectionNode)n));
                if (hadDelayBefore3 == Kleenean.TRUE || this.hasDelayBefore == Kleenean.FALSE) continue;
                this.hasDelayBefore = Kleenean.UNKNOWN;
                continue;
            }
            if (name.equalsIgnoreCase("else")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else' has to be placed just after an 'if' or 'else if' section");
                    continue;
                }
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(this.indentation) + "else:");
                }
                Kleenean hadDelayAfterLastIf = this.hasDelayBefore;
                this.hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseClause((SectionNode)n);
                this.hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(this.hasDelayBefore));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "else if ")) {
                if (items.size() == 0 || !(items.get(items.size() - 1) instanceof Conditional) || ((Conditional)items.get(items.size() - 1)).hasElseClause()) {
                    Skript.error("'else if' has to be placed just after another 'if' or 'else if' section");
                    continue;
                }
                cond = Condition.parse(name = name.substring("else if ".length()), "can't understand this condition: '" + name + "'");
                if (cond == null) continue;
                if (Skript.debug() || n.debug()) {
                    Skript.debug(String.valueOf(this.indentation) + "else if " + cond.toString(null, true));
                }
                Kleenean hadDelayAfterLastIf = this.hasDelayBefore;
                this.hasDelayBefore = hadDelayBeforeLastIf;
                ((Conditional)items.get(items.size() - 1)).loadElseIf((Condition)cond, (SectionNode)n);
                this.hasDelayBefore = hadDelayBeforeLastIf.or(hadDelayAfterLastIf.and(this.hasDelayBefore.and(Kleenean.UNKNOWN)));
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(name, "if ")) {
                name = name.substring(3);
            }
            if ((cond = Condition.parse(name, "can't understand this condition: '" + name + "'")) == null) continue;
            if (Skript.debug() || n.debug()) {
                Skript.debug(String.valueOf(this.indentation) + cond.toString(null, true) + ":");
            }
            hadDelayBeforeLastIf = hadDelayBefore = this.hasDelayBefore;
            items.add(new Conditional((Condition)cond, (SectionNode)n));
            this.hasDelayBefore = hadDelayBefore.or(this.hasDelayBefore.and(Kleenean.UNKNOWN));
        }
        int i = 0;
        while (i < items.size() - 1) {
            ((TriggerItem)items.get(i)).setNext(items.get(i + 1));
            ++i;
        }
        SkriptLogger.setNode(node);
        if (Skript.debug()) {
            this.indentation = this.indentation.substring(0, this.indentation.length() - 4);
        }
        return items;
    }

    @Override
    public void run() {
        for (Node cnode : this.config.getMainNode()) {
            Trigger trigger;
            NonNullPair parsedEvent;
            if (!(cnode instanceof SectionNode)) {
                Skript.error("invalid line - all code has to be put into triggers");
                continue;
            }
            SectionNode node = (SectionNode)cnode;
            String event = node.getKey();
            if (event == null) continue;
            if (event.equalsIgnoreCase("aliases")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in aliases section");
                        continue;
                    }
                    ItemType t = Aliases.parseAlias(((EntryNode)n).getValue());
                    if (t == null) continue;
                    this.aliases.put(((EntryNode)n).getKey().toLowerCase(), t);
                }
                continue;
            }
            if (event.equalsIgnoreCase("options")) {
                node.convertToEntries(0);
                for (Node n : node) {
                    if (!(n instanceof EntryNode)) {
                        Skript.error("invalid line in options");
                        continue;
                    }
                    this.options.put(((EntryNode)n).getKey(), ((EntryNode)n).getValue());
                }
                continue;
            }
            if (event.equalsIgnoreCase("variables")) {
                node.convertToEntries(0, "=");
                for (Node n : node) {
                    Object o;
                    String var;
                    if (!(n instanceof EntryNode)) {
                        Skript.error("Invalid line in variables section");
                        continue;
                    }
                    String name = ((EntryNode)n).getKey().toLowerCase(Locale.ENGLISH);
                    if (name.startsWith("{") && name.endsWith("}")) {
                        name = name.substring(1, name.length() - 1);
                    }
                    if ((name = StringUtils.replaceAll((CharSequence)name, "%(.+)?%", new Callback<String, Matcher>(var = name){
                        private final /* synthetic */ String val$var;
                        {
                            this.val$var = string;
                        }

                        @Override
                        @Nullable
                        public String run(Matcher m) {
                            if (m.group(1).contains("{") || m.group(1).contains("}") || m.group(1).contains("%")) {
                                Skript.error("'" + this.val$var + "' is not a valid name for a default variable");
                                return null;
                            }
                            ClassInfo<?> ci = Classes.getClassInfoFromUserInput(m.group(1));
                            if (ci == null) {
                                Skript.error("Can't understand the type '" + m.group(1) + "'");
                                return null;
                            }
                            return "<" + ci.getCodeName() + ">";
                        }
                    })) == null) continue;
                    if (name.contains("%")) {
                        Skript.error("Invalid use of percent signs in variable name");
                        continue;
                    }
                    if (Variables.getVariable(name, null, false) != null) continue;
                    ParseLogHandler log = SkriptLogger.startParseLogHandler();
                    try {
                        o = Classes.parseSimple((String)((EntryNode)n).getValue(), Object.class, (ParseContext)ParseContext.SCRIPT);
                        if (o == null) {
                            log.printError("Can't understand the value '" + ((EntryNode)n).getValue() + "'");
                            continue;
                        }
                        log.printLog();
                    }
                    finally {
                        log.stop();
                    }
                    ClassInfo<?> ci = Classes.getSuperClassInfo(o.getClass());
                    if (ci.getSerializer() == null) {
                        Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                        continue;
                    }
                    if (ci.getSerializeAs() != null) {
                        ClassInfo<?> as = Classes.getExactClassInfo(ci.getSerializeAs());
                        if (as == null) {
                            assert (false) : ci;
                            continue;
                        }
                        if ((o = Converters.convert(o, as.getC())) == null) {
                            Skript.error("Can't save '" + ((EntryNode)n).getValue() + "' in a variable");
                            continue;
                        }
                    }
                    Variables.setVariable(name, o, null, false);
                }
                continue;
            }
            if (!SkriptParser.validateLine(event)) continue;
            if (event.toLowerCase().startsWith("command ")) {
                this.setCurrentEvent("command", CommandEvent.class);
                ScriptCommand c = Commands.loadCommand((SectionNode)node, (ScriptProcessor)this);
                if (c != null) {
                    ++this.numCommands;
                    this.commands.add(c);
                }
                this.deleteCurrentEvent();
                continue;
            }
            if (event.toLowerCase().startsWith("function ")) {
                this.setCurrentEvent("function", FunctionEvent.class);
                Function func = Functions.loadFunction((SectionNode)node);
                if (func != null) {
                    ++this.numFunctions;
                }
                this.deleteCurrentEvent();
                continue;
            }
            if (Skript.logVeryHigh() && !Skript.debug()) {
                Skript.info("loading trigger '" + event + "'");
            }
            if (StringUtils.startsWithIgnoreCase(event, "on ")) {
                event = event.substring("on ".length());
            }
            if ((parsedEvent = SkriptParser.parseEvent((String)(event = this.replaceOptions(event)), (String)("can't understand this event: '" + node.getKey() + "'"))) == null) continue;
            if (Skript.debug() || node.debug()) {
                Skript.debug(String.valueOf(event) + " (" + ((SkriptEvent)parsedEvent.getSecond()).toString(null, true) + "):");
            }
            this.setCurrentEvent(((SkriptEventInfo)parsedEvent.getFirst()).getName().toLowerCase(Locale.ENGLISH), ((SkriptEventInfo)parsedEvent.getFirst()).events);
            try {
                trigger = new Trigger(this.config.getFile(), event, (SkriptEvent)parsedEvent.getSecond(), this.loadItems(node));
            }
            finally {
                this.deleteCurrentEvent();
            }
            if (parsedEvent.getSecond() instanceof SelfRegisteringSkriptEvent) {
                ((SelfRegisteringSkriptEvent)parsedEvent.getSecond()).register(trigger);
                this.selfRegisteringTriggers.add(trigger);
            } else {
                this.triggers.put(((SkriptEventInfo)parsedEvent.getFirst()).events, trigger);
            }
            ++this.numTriggers;
        }
    }
}

