/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Events;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.events.util.PlayerChatEventHandler;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Message")
@Description(value={"The (chat) message of a chat event, the join message of a join event, the quit message of a quit event, or the death message on a death event. This expression is mostly useful for being changed."})
@Examples(value={"on chat:", "\tplayer has permission \"admin\"", "\tset message to \"<red>%message%\"", "", "on first join:", "\tset join message to \"Welcome %player% to our awesome server!\"", "on join:", "\tplayer has played before", "\tset join message to \"Welcome back, %player%!\"", "", "on quit:", "\tset quit message to \"%player% left this awesome server!\"", "", "on death:", "\tset the death message to \"%player% died!\""})
@Since(value="1.4.6 (chat message), 1.4.9 (join & quit messages), 2.0 (death message)")
@Events(value={"chat", "join", "quit", "death"})
public class ExprMessage
extends SimpleExpression<String> {
    private MessageType type;

    static {
        Skript.registerExpression(ExprMessage.class, String.class, ExpressionType.SIMPLE, MessageType.patterns);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.type = MessageType.values()[matchedPattern];
        if (!this.pi.isCurrentEvent(this.type.events)) {
            Skript.error("The " + this.type.name + " message can only be used in a " + this.type.name + " event", ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        return true;
    }

    protected String[] get(Event e) {
        Class<? extends Event>[] classArray = this.type.events;
        int n = this.type.events.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> c = classArray[n2];
            if (c.isInstance(e)) {
                return new String[]{this.type.get(e)};
            }
            ++n2;
        }
        return new String[0];
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return CollectionUtils.array(String.class);
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (mode == Changer.ChangeMode.SET);
        assert (delta != null);
        Class<? extends Event>[] classArray = this.type.events;
        int n = this.type.events.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Event> c = classArray[n2];
            if (c.isInstance(e)) {
                this.type.set(e, "" + delta[0]);
            }
            ++n2;
        }
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "the " + this.type.name + " message";
    }

    private static enum MessageType {
        CHAT("chat", "[chat( |-)]message", new Class[]{PlayerChatEventHandler.usesAsyncEvent ? AsyncPlayerChatEvent.class : PlayerChatEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                if (PlayerChatEventHandler.usesAsyncEvent) {
                    return ((AsyncPlayerChatEvent)e).getMessage();
                }
                return ((PlayerChatEvent)e).getMessage();
            }

            @Override
            void set(Event e, String message) {
                if (PlayerChatEventHandler.usesAsyncEvent) {
                    ((AsyncPlayerChatEvent)e).setMessage(message);
                } else {
                    ((PlayerChatEvent)e).setMessage(message);
                }
            }
        }
        ,
        JOIN("join", "(join|log[ ]in)( |-)message", new Class[]{PlayerJoinEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                return ((PlayerJoinEvent)e).getJoinMessage();
            }

            @Override
            void set(Event e, String message) {
                ((PlayerJoinEvent)e).setJoinMessage(message);
            }
        }
        ,
        QUIT("quit", "(quit|leave|log[ ]out|kick)( |-)message", new Class[]{PlayerQuitEvent.class, PlayerKickEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                if (e instanceof PlayerKickEvent) {
                    return ((PlayerKickEvent)e).getLeaveMessage();
                }
                return ((PlayerQuitEvent)e).getQuitMessage();
            }

            @Override
            void set(Event e, String message) {
                if (e instanceof PlayerKickEvent) {
                    ((PlayerKickEvent)e).setLeaveMessage(message);
                } else {
                    ((PlayerQuitEvent)e).setQuitMessage(message);
                }
            }
        }
        ,
        DEATH("death", "death( |-)message", new Class[]{EntityDeathEvent.class}){

            @Override
            @Nullable
            String get(Event e) {
                if (e instanceof PlayerDeathEvent) {
                    return ((PlayerDeathEvent)e).getDeathMessage();
                }
                return null;
            }

            @Override
            void set(Event e, String message) {
                if (e instanceof PlayerDeathEvent) {
                    ((PlayerDeathEvent)e).setDeathMessage(message);
                }
            }
        };

        final String name;
        private final String pattern;
        final Class<? extends Event>[] events;
        static String[] patterns;

        static {
            patterns = new String[MessageType.values().length];
            int i = 0;
            while (i < patterns.length) {
                MessageType.patterns[i] = MessageType.values()[i].pattern;
                ++i;
            }
        }

        private MessageType(String name, String pattern, Class<? extends Event> ... events) {
            this.name = name;
            this.pattern = "[the] " + pattern;
            this.events = events;
        }

        @Nullable
        abstract String get(Event var1);

        abstract void set(Event var1, String var2);
    }
}

