/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.EquipmentSlot;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import java.util.Locale;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Armour Slot")
@Description(value={"A part of a player's armour, i.e. the boots, leggings, chestplate or helmet."})
@Examples(value={"set chestplate of the player to a diamond chestplate", "helmet of player is neither a helmet nor air # player is wearing a block, e.g. from another plugin"})
@Since(value="1.0")
public class ExprArmorSlot
extends SimplePropertyExpression<LivingEntity, Slot> {
    private EquipmentSlot.EquipSlot slot;
    private static final EquipmentSlot.EquipSlot[] slots;

    static {
        ExprArmorSlot.register(ExprArmorSlot.class, Slot.class, "(0\u00a6boot[s]|0\u00a6shoe[s]|1\u00a6leg[ging][s]|2\u00a6chestplate[s]|3\u00a6helm[et][s]) [slot]", "livingentities");
        slots = new EquipmentSlot.EquipSlot[]{EquipmentSlot.EquipSlot.BOOTS, EquipmentSlot.EquipSlot.LEGGINGS, EquipmentSlot.EquipSlot.CHESTPLATE, EquipmentSlot.EquipSlot.HELMET};
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.slot = slots[parseResult.mark];
        return true;
    }

    @Override
    @Nullable
    public Slot convert(LivingEntity e) {
        EntityEquipment eq = e.getEquipment();
        if (eq == null) {
            return null;
        }
        return new EquipmentSlot(eq, this.slot);
    }

    @Override
    protected String getPropertyName() {
        return this.slot.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public Class<Slot> getReturnType() {
        return Slot.class;
    }
}

