/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.aliases;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemData;
import ch.njol.skript.lang.Unit;
import ch.njol.skript.localization.Adjective;
import ch.njol.skript.localization.GeneralWords;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.localization.Noun;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.Container;
import ch.njol.skript.util.EnchantmentType;
import ch.njol.skript.util.Utils;
import ch.njol.util.coll.iterator.EmptyIterable;
import ch.njol.util.coll.iterator.SingleItemIterable;
import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.YggdrasilSerializable;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.eclipse.jdt.annotation.Nullable;

@Container.ContainerType(value=ItemStack.class)
public class ItemType
implements Unit,
Iterable<ItemData>,
Container<ItemStack>,
YggdrasilSerializable.YggdrasilExtendedSerializable {
    private static final Message m_named = new Message("aliases.named");
    public static final boolean itemMetaSupported = Skript.supports("org.bukkit.inventory.meta.ItemMeta");
    public static final boolean oldInvSize = !Skript.isRunningMinecraft(1, 9);
    public static final boolean rawNamesSupported = Skript.isRunningMinecraft(1, 8);
    final ArrayList<ItemData> types = new ArrayList();
    private boolean all = false;
    private int amount = -1;
    private int numItems = 0;
    @Nullable
    transient Map<Enchantment, Integer> enchantments = null;
    @Nullable
    transient Object meta = null;
    @Nullable
    private ItemType item = null;
    @Nullable
    private ItemType block = null;
    private boolean ignoreMeta = false;
    private static final Random random = new Random();

    void setItem(@Nullable ItemType item) {
        if (this.equals(item)) {
            this.item = null;
        } else {
            if (item != null) {
                if (item.item != null || item.block != null) {
                    assert (false) : this + "; item=" + item + ", item.item=" + item.item + ", item.block=" + item.block;
                    this.item = null;
                    return;
                }
                item.setAmount(this.amount);
            }
            this.item = item;
        }
    }

    void setBlock(@Nullable ItemType block) {
        if (this.equals(block)) {
            this.block = null;
        } else {
            if (block != null) {
                if (block.item != null || block.block != null) {
                    assert (false) : this + "; block=" + block + ", block.item=" + block.item + ", block.block=" + block.block;
                    this.block = null;
                    return;
                }
                block.setAmount(this.amount);
            }
            this.block = block;
        }
    }

    public ItemType() {
    }

    public ItemType(int id) {
        this.add_(new ItemData(id));
    }

    public ItemType(int id, short data) {
        this.add_(new ItemData(id, data));
    }

    public ItemType(ItemData d) {
        this.add_(d.clone());
    }

    public ItemType(ItemStack i) {
        this.amount = i.getAmount();
        this.add_(new ItemData(i));
        if (!i.getEnchantments().isEmpty()) {
            this.enchantments = new HashMap<Enchantment, Integer>(i.getEnchantments());
        }
        if (itemMetaSupported) {
            this.meta = i.getItemMeta();
            ItemType.unsetItemMetaEnchs((ItemMeta)this.meta);
        }
    }

    public ItemType(Block b) {
        this.add_(new ItemData(b.getTypeId(), b.getData()));
    }

    private ItemType(ItemType i) {
        this.all = i.all;
        this.amount = i.amount;
        this.numItems = i.numItems;
        ItemType bl = i.block;
        ItemType it = i.item;
        this.block = bl == null ? null : bl.clone();
        this.item = it == null ? null : it.clone();
        Object m = i.meta;
        this.meta = m == null ? null : ((ItemMeta)m).clone();
        for (ItemData d : i) {
            this.types.add(d.clone());
        }
        if (i.enchantments != null) {
            this.enchantments = new HashMap<Enchantment, Integer>(i.enchantments);
        }
    }

    public void modified() {
        this.block = null;
        this.item = null;
    }

    @Override
    public int getAmount() {
        return this.amount == -1 ? 1 : this.amount;
    }

    public int getInternalAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(double amount) {
        this.setAmount((int)amount);
    }

    public void setAmount(int amount) {
        this.amount = amount;
        if (this.item != null) {
            this.item.amount = amount;
        }
        if (this.block != null) {
            this.block.amount = amount;
        }
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    @Nullable
    public Object getItemMeta() {
        return this.meta;
    }

    public void setItemMeta(Object meta) {
        if (!itemMetaSupported || !(meta instanceof ItemMeta)) {
            throw new IllegalStateException("" + meta);
        }
        ItemType.unsetItemMetaEnchs((ItemMeta)meta);
        this.meta = meta;
        if (this.item != null) {
            this.item = this.item.clone();
            this.item.meta = meta;
        }
        if (this.block != null) {
            this.block = this.block.clone();
            this.block.meta = meta;
        }
    }

    private static final void unsetItemMetaEnchs(@Nullable ItemMeta meta) {
        if (meta == null) {
            return;
        }
        for (Enchantment e : meta.getEnchants().keySet()) {
            meta.removeEnchant(e);
        }
    }

    private boolean hasMeta(@Nullable ItemStack item) {
        Object meta;
        Map<Enchantment, Integer> enchs = this.enchantments;
        if (enchs != null) {
            if (item == null) {
                return false;
            }
            for (Map.Entry<Enchantment, Integer> e : enchs.entrySet()) {
                if (!(e.getValue() == -1 ? item.getEnchantmentLevel(e.getKey()) == 0 : item.getEnchantmentLevel(e.getKey()) != e.getValue().intValue())) continue;
                return false;
            }
        }
        if ((meta = this.meta) != null && !this.ignoreMeta) {
            if (item == null) {
                return false;
            }
            ItemMeta m = item.getItemMeta();
            ItemType.unsetItemMetaEnchs(m);
            if (!meta.equals(m)) {
                return false;
            }
        }
        return true;
    }

    public boolean isOfType(@Nullable ItemStack item) {
        if (item == null) {
            return this.isOfType(0, (short)0);
        }
        if (!this.hasMeta(item)) {
            return false;
        }
        return this.isOfType(item.getTypeId(), item.getDurability());
    }

    public boolean isOfType(@Nullable Block block) {
        if (this.enchantments != null) {
            return false;
        }
        if (block == null) {
            return this.isOfType(0, (short)0);
        }
        return this.isOfType(block.getTypeId(), block.getData());
    }

    public boolean isOfType(int id, short data) {
        for (ItemData type : this.types) {
            if (!type.isOfType(id, data)) continue;
            return true;
        }
        return false;
    }

    public boolean isSupertypeOf(ItemType other) {
        if (this.amount != -1 && other.amount != this.amount) {
            return false;
        }
        Map<Enchantment, Integer> enchs = this.enchantments;
        if (enchs != null) {
            Map<Enchantment, Integer> oenchs = other.enchantments;
            if (oenchs == null) {
                return false;
            }
            for (Map.Entry<Enchantment, Integer> o : oenchs.entrySet()) {
                Integer t = enchs.get(o.getKey());
                if (t != null && t.equals(o.getValue())) continue;
                return false;
            }
        }
        if (this.meta != null && !this.meta.equals(other.meta)) {
            return false;
        }
        block1: for (ItemData o : other.types) {
            assert (o != null);
            for (ItemData t : this.types) {
                if (t.isSupertypeOf(o)) continue block1;
            }
            return false;
        }
        return true;
    }

    public ItemType getItem() {
        ItemType item = this.item;
        return item == null ? this : item;
    }

    public ItemType getBlock() {
        ItemType block = this.block;
        return block == null ? this : block;
    }

    public boolean hasItem() {
        for (ItemData d : this.types) {
            if (d.getId() <= 255) continue;
            return true;
        }
        return false;
    }

    public boolean hasBlock() {
        for (ItemData d : this.types) {
            if (d.getId() > 255) continue;
            return true;
        }
        return false;
    }

    public boolean setBlock(Block block, boolean applyPhysics) {
        for (ItemData d : this.types) {
            if (d.typeid > 255 || !BlockUtils.set(block, d.typeid, (byte)d.dataMin, (byte)d.dataMax, applyPhysics)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ItemType intersection(ItemType other) {
        if (this.amount != -1 || other.amount != -1 || this.enchantments != null || other.enchantments != null) {
            throw new IllegalStateException("ItemType.intersection(ItemType) must only be used to instersect aliases");
        }
        ItemType r = new ItemType();
        for (ItemData d1 : this.types) {
            for (ItemData d2 : other.types) {
                assert (d2 != null);
                r.add_(d1.intersection(d2));
            }
        }
        r.meta = this.meta;
        if (r.types.isEmpty()) {
            return null;
        }
        return r;
    }

    public void add(@Nullable ItemData type) {
        if (type != null) {
            this.add_(type.clone());
        }
    }

    private void add_(@Nullable ItemData type) {
        if (type != null) {
            this.types.add(type);
            this.numItems += type.numItems();
            this.modified();
        }
    }

    public void addAll(Collection<ItemData> types) {
        for (ItemData type : types) {
            if (type == null) continue;
            this.types.add(type);
            this.numItems += type.numItems();
        }
        this.modified();
    }

    public void remove(ItemData type) {
        if (this.types.remove(type)) {
            this.numItems -= type.numItems();
            this.modified();
        }
    }

    void remove(int index) {
        ItemData type = this.types.remove(index);
        this.numItems -= type.numItems();
        this.modified();
    }

    public void addEnchantment(Enchantment e, int level) {
        Map<Enchantment, Integer> enchs = this.enchantments;
        if (enchs == null) {
            this.enchantments = enchs = new HashMap<Enchantment, Integer>();
        }
        enchs.put(e, level);
    }

    public void addEnchantments(Map<Enchantment, Integer> enchantments) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>(enchantments);
        } else {
            this.enchantments.putAll(enchantments);
        }
    }

    public void clearEnchantments() {
        if (this.enchantments != null) {
            this.enchantments.clear();
        }
    }

    @Nullable
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    @Override
    public Iterator<ItemStack> containerIterator() {
        return new Iterator<ItemStack>(){
            Iterator<ItemData> iter;
            @Nullable
            Iterator<ItemStack> currentDataIter;
            {
                this.iter = ItemType.this.types.iterator();
            }

            @Override
            public boolean hasNext() {
                Iterator<ItemStack> cdi = this.currentDataIter;
                while (this.iter.hasNext() && (cdi == null || !cdi.hasNext())) {
                    this.currentDataIter = cdi = this.iter.next().getAll();
                }
                return cdi != null && cdi.hasNext();
            }

            @Override
            public ItemStack next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator<ItemStack> cdi = this.currentDataIter;
                if (cdi == null) {
                    throw new NoSuchElementException();
                }
                ItemStack is = cdi.next();
                is.setAmount(ItemType.this.getAmount());
                if (ItemType.this.meta != null) {
                    is.setItemMeta(Bukkit.getItemFactory().asMetaFor((ItemMeta)ItemType.this.meta, is.getType()));
                }
                if (ItemType.this.enchantments != null) {
                    is.addUnsafeEnchantments(ItemType.this.enchantments);
                }
                return is;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<ItemStack> getAll() {
        if (!this.isAll()) {
            ItemStack i = this.getRandom();
            if (i == null) {
                return EmptyIterable.get();
            }
            return new SingleItemIterable<ItemStack>(i);
        }
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return ItemType.this.containerIterator();
            }
        };
    }

    @Nullable
    public ItemStack removeAll(@Nullable ItemStack item) {
        boolean wasAll = this.all;
        int oldAmount = this.amount;
        this.all = true;
        this.amount = -1;
        try {
            ItemStack itemStack = this.removeFrom(item);
            return itemStack;
        }
        finally {
            this.all = wasAll;
            this.amount = oldAmount;
        }
    }

    @Nullable
    public ItemStack removeFrom(@Nullable ItemStack item) {
        if (item == null) {
            return null;
        }
        if (!this.isOfType(item)) {
            return item;
        }
        if (this.all && this.amount == -1) {
            return null;
        }
        int a = item.getAmount() - this.getAmount();
        if (a <= 0) {
            return null;
        }
        item.setAmount(a);
        return item;
    }

    @Nullable
    public ItemStack addTo(@Nullable ItemStack item) {
        if (item == null || item.getTypeId() == 0) {
            return this.getRandom();
        }
        if (this.isOfType(item)) {
            item.setAmount(Math.min(item.getAmount() + this.getAmount(), item.getMaxStackSize()));
        }
        return item;
    }

    @Override
    public ItemType clone() {
        return new ItemType(this);
    }

    @Nullable
    public ItemStack getRandom() {
        if (this.numItems == 0) {
            return null;
        }
        int item = random.nextInt(this.numItems);
        int i = -1;
        while (item >= 0) {
            item -= this.types.get(++i).numItems();
        }
        ItemStack is = this.types.get(i).getRandom();
        is.setAmount(this.getAmount());
        if (this.meta != null) {
            is.setItemMeta(Bukkit.getItemFactory().asMetaFor((ItemMeta)this.meta, is.getType()));
        }
        if (this.enchantments != null) {
            is.addUnsafeEnchantments(this.enchantments);
        }
        return is;
    }

    public boolean hasSpace(Inventory invi) {
        if (!this.isAll() && (this.getItem().types.size() != 1 || this.getItem().types.get(0).hasDataRange() || this.getItem().types.get((int)0).typeid == -1)) {
            return false;
        }
        return this.addTo(ItemType.getStorageContents(invi));
    }

    public static final ItemStack[] getCopiedContents(Inventory invi) {
        ItemStack[] buf = invi.getContents();
        int i = 0;
        while (i < buf.length) {
            if (buf[i] != null) {
                buf[i] = buf[i].clone();
            }
            ++i;
        }
        return buf;
    }

    public static final ItemStack[] getStorageContents(Inventory invi) {
        if (invi instanceof PlayerInventory) {
            ItemStack[] buf = invi.getContents();
            ItemStack[] tBuf = new ItemStack[36];
            int i = 0;
            while (i < 36) {
                if (buf[i] != null) {
                    tBuf[i] = buf[i].clone();
                }
                ++i;
            }
            return tBuf;
        }
        return ItemType.getCopiedContents(invi);
    }

    public List<ItemData> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    public int numTypes() {
        return this.types.size();
    }

    public int numItems() {
        return this.numItems;
    }

    @Override
    public Iterator<ItemData> iterator() {
        return new Iterator<ItemData>(){
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < ItemType.this.types.size();
            }

            @Override
            public ItemData next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ItemType.this.types.get(this.next++);
            }

            @Override
            public void remove() {
                if (this.next <= 0) {
                    throw new IllegalStateException();
                }
                ItemType.this.remove(--this.next);
            }
        };
    }

    public boolean isContainedIn(Inventory invi) {
        return this.isContainedIn((Iterable<ItemStack>)invi);
    }

    public boolean isContainedIn(Iterable<ItemStack> items) {
        for (ItemData d : this.types) {
            int found = 0;
            for (ItemStack i : items) {
                if (!d.isOfType(i) || !this.hasMeta(i) || (found += i == null ? 1 : i.getAmount()) < this.getAmount()) continue;
                if (this.all) break;
                return true;
            }
            if (!this.all || found >= this.getAmount()) continue;
            return false;
        }
        return this.all;
    }

    public boolean isContainedIn(ItemStack[] list) {
        for (ItemData d : this.types) {
            int found = 0;
            ItemStack[] itemStackArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack i = itemStackArray[n2];
                if (d.isOfType(i) && this.hasMeta(i) && (found += i == null ? 1 : i.getAmount()) >= this.getAmount()) {
                    if (this.all) break;
                    return true;
                }
                ++n2;
            }
            if (!this.all || found >= this.getAmount()) continue;
            return false;
        }
        return this.all;
    }

    public boolean removeAll(Inventory invi) {
        boolean wasAll = this.all;
        int oldAmount = this.amount;
        this.all = true;
        this.amount = -1;
        try {
            boolean bl = this.removeFrom(invi);
            return bl;
        }
        finally {
            this.all = wasAll;
            this.amount = oldAmount;
        }
    }

    public boolean removeFrom(Inventory invi) {
        ItemStack[] buf = oldInvSize ? ItemType.getStorageContents(invi) : ItemType.getCopiedContents(invi);
        ItemStack[] armour = invi instanceof PlayerInventory && !oldInvSize ? ((PlayerInventory)invi).getArmorContents() : null;
        boolean ok = this.removeFrom(Arrays.asList(buf), armour == null ? null : Arrays.asList(armour));
        invi.setContents(buf);
        if (armour != null) {
            ((PlayerInventory)invi).setArmorContents(armour);
        }
        return ok;
    }

    public boolean removeAll(List<ItemStack> ... lists) {
        boolean wasAll = this.all;
        int oldAmount = this.amount;
        this.all = true;
        this.amount = -1;
        try {
            boolean bl = this.removeFrom(lists);
            return bl;
        }
        finally {
            this.all = wasAll;
            this.amount = oldAmount;
        }
    }

    public boolean removeFrom(List<ItemStack> ... lists) {
        int removed = 0;
        boolean ok = true;
        for (ItemData d : this.types) {
            if (this.all) {
                removed = 0;
            }
            List<ItemStack>[] listArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                List<ItemStack> list = listArray[n2];
                if (list != null) {
                    assert (list instanceof RandomAccess);
                    int i = 0;
                    while (i < list.size()) {
                        ItemStack is = list.get(i);
                        if (is != null && d.isOfType(is) && this.hasMeta(is)) {
                            if (this.all && this.amount == -1) {
                                list.set(i, null);
                                removed = 1;
                            } else {
                                int toRemove = Math.min(is.getAmount(), this.getAmount() - removed);
                                removed += toRemove;
                                if (toRemove == is.getAmount()) {
                                    list.set(i, null);
                                } else {
                                    is.setAmount(is.getAmount() - toRemove);
                                }
                                if (removed == this.getAmount()) {
                                    if (this.all) break;
                                    return true;
                                }
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            if (!this.all) continue;
            ok &= removed == this.getAmount();
        }
        if (!this.all) {
            return false;
        }
        return ok;
    }

    public void addTo(List<ItemStack> list) {
        if (!this.isAll()) {
            list.add(this.getItem().getRandom());
            return;
        }
        for (ItemStack is : this.getItem().getAll()) {
            list.add(is);
        }
    }

    public boolean addTo(Inventory invi) {
        int i;
        ItemStack[] buf = invi.getContents();
        if (buf == null) {
            return false;
        }
        ItemStack[] tBuf = (ItemStack[])buf.clone();
        if (oldInvSize) {
            if (buf.length > 36) {
                buf = new ItemStack[35];
                i = 0;
                while (i < 35) {
                    buf[i] = tBuf[i];
                    ++i;
                }
            }
        } else if (invi instanceof PlayerInventory) {
            buf = new ItemStack[36];
            i = 0;
            while (i < 36) {
                buf[i] = tBuf[i];
                ++i;
            }
        }
        boolean b = this.addTo(buf);
        if (!oldInvSize && invi instanceof PlayerInventory) {
            buf = Arrays.copyOf(buf, tBuf.length);
            int i2 = tBuf.length - 5;
            while (i2 < tBuf.length) {
                buf[i2] = tBuf[i2];
                ++i2;
            }
        }
        invi.setContents(buf);
        return b;
    }

    private static boolean addTo(@Nullable ItemStack is, ItemStack[] buf) {
        int toAdd;
        if (is == null || is.getTypeId() == 0) {
            return true;
        }
        int added = 0;
        int i = 0;
        while (i < buf.length) {
            if (Utils.itemStacksEqual(is, buf[i])) {
                toAdd = Math.min(buf[i].getMaxStackSize() - buf[i].getAmount(), is.getAmount() - added);
                buf[i].setAmount(buf[i].getAmount() + toAdd);
                if ((added += toAdd) == is.getAmount()) {
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < buf.length) {
            if (buf[i] == null) {
                toAdd = Math.min(is.getMaxStackSize(), is.getAmount() - added);
                buf[i] = is.clone();
                buf[i].setAmount(toAdd);
                if ((added += toAdd) == is.getAmount()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean addTo(ItemStack[] buf) {
        if (!this.isAll()) {
            return ItemType.addTo(this.getItem().getRandom(), buf);
        }
        boolean ok = true;
        for (ItemStack is : this.getItem().getAll()) {
            ok &= ItemType.addTo(is, buf);
        }
        return ok;
    }

    public static final boolean isSubset(ItemType[] set, ItemType[] sub) {
        ItemType[] itemTypeArray = sub;
        int n = sub.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                ItemType i = itemTypeArray[n2];
                assert (i != null);
                ItemType[] itemTypeArray2 = set;
                int n3 = set.length;
                int n4 = 0;
                while (n4 < n3) {
                    ItemType t = itemTypeArray2[n4];
                    if (!t.isSupertypeOf(i)) {
                        ++n4;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Deprecated
    @Nullable
    public static ItemType[] deserialize(String s) {
        if (s.isEmpty()) {
            return null;
        }
        String[] split = s.split("(?!<\\|)\\|(?!\\|)");
        ItemType[] types = new ItemType[split.length];
        int i = 0;
        while (i < types.length) {
            ItemType t = (ItemType)Classes.deserialize("itemtype", split[i].replace("||", "|"));
            if (t == null) {
                return null;
            }
            types[i] = t;
            ++i;
        }
        return types;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.all ? 1231 : 1237);
        result = 31 * result + this.amount;
        Map<Enchantment, Integer> enchs = this.enchantments;
        result = 31 * result + (enchs == null ? 0 : enchs.hashCode());
        Object m = this.meta;
        result = 31 * result + (m == null ? 0 : m.hashCode());
        result = 31 * result + this.types.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemType)) {
            return false;
        }
        ItemType other = (ItemType)obj;
        if (this.all != other.all) {
            return false;
        }
        if (this.amount != other.amount) {
            return false;
        }
        Map<Enchantment, Integer> enchs = this.enchantments;
        if (enchs == null ? other.enchantments != null : !enchs.equals(other.enchantments)) {
            return false;
        }
        Object m = this.meta;
        if (m == null ? other.meta != null : !m.equals(other.meta)) {
            return false;
        }
        return this.types.equals(other.types);
    }

    @Override
    public String toString() {
        return this.toString(false, 0, null);
    }

    @Override
    public String toString(int flags) {
        return this.toString(false, flags, null);
    }

    public String toString(int flags, @Nullable Adjective a) {
        return this.toString(false, flags, a);
    }

    private String toString(boolean debug, int flags, @Nullable Adjective a) {
        boolean plural;
        StringBuilder b = new StringBuilder();
        boolean bl = plural = this.amount != 1 && this.amount != -1 || (flags & 1) != 0;
        if (this.amount != -1 && this.amount != 1) {
            b.append(String.valueOf(this.amount) + " ");
        } else {
            b.append(Noun.getArticleWithSpace(this.types.get(0).getGender(), flags));
        }
        if (a != null) {
            b.append(a.toString(this.types.get(0).getGender(), flags));
        }
        int i = 0;
        while (i < this.types.size()) {
            if (i != 0) {
                if (i == this.types.size() - 1) {
                    b.append(" " + (this.isAll() ? GeneralWords.and : GeneralWords.or) + " ");
                } else {
                    b.append(", ");
                }
            }
            b.append(this.types.get(i).toString(debug, plural));
            ++i;
        }
        Map<Enchantment, Integer> enchs = this.enchantments;
        if (enchs == null) {
            return b.toString();
        }
        b.append(Language.getSpaced("enchantments.of"));
        int i2 = 0;
        for (Map.Entry<Enchantment, Integer> e : enchs.entrySet()) {
            Enchantment ench;
            if (i2 != 0) {
                if (i2 != enchs.size() - 1) {
                    b.append(", ");
                } else {
                    b.append(" " + GeneralWords.and + " ");
                }
            }
            if ((ench = e.getKey()) == null) continue;
            b.append(EnchantmentType.toString(ench));
            b.append(" ");
            b.append(e.getValue());
            ++i2;
        }
        if (this.meta != null) {
            ItemMeta m = (ItemMeta)this.meta;
            if (m.hasDisplayName()) {
                b.append(" " + m_named.toString() + " ");
                b.append("\"" + m.getDisplayName() + "\"");
            }
            if (debug) {
                b.append(" meta=[").append(this.meta).append("]");
            }
        }
        return b.toString();
    }

    public static String toString(ItemStack i) {
        return new ItemType(i).toString();
    }

    public static String toString(ItemStack i, int flags) {
        return new ItemType(i).toString(flags);
    }

    public String getDebugMessage() {
        return this.toString(true, 0, null);
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        Fields f = new Fields(this);
        f.putObject("enchantments", this.enchantments);
        f.putObject("meta", this.meta);
        return f;
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        this.enchantments = fields.getAndRemoveObject("enchantments", Map.class);
        this.meta = fields.getAndRemoveObject("meta", Object.class);
        if (this.meta != null && !(this.meta instanceof ItemMeta)) {
            throw new StreamCorruptedException();
        }
        fields.setFields(this);
    }

    public List<String> getRawNames() {
        ArrayList<String> rawNames = new ArrayList<String>();
        for (ItemData data : this.types) {
            rawNames.add("minecraft:" + Material.getMaterial((int)data.typeid).toString().toLowerCase().replace("leash", "lead").replace("wood", "planks"));
        }
        return rawNames;
    }

    public void setIgnoreMeta(boolean ignore) {
        this.ignoreMeta = ignore;
    }

    public boolean doesIgnoreMeta() {
        return this.ignoreMeta;
    }
}

