/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript;

import ch.njol.skript.Metrics;
import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.SkriptCommand;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.SkriptEventHandler;
import ch.njol.skript.Updater;
import ch.njol.skript.aliases.Aliases;
import ch.njol.skript.bukkitutil.Workarounds;
import ch.njol.skript.classes.data.BukkitClasses;
import ch.njol.skript.classes.data.BukkitEventValues;
import ch.njol.skript.classes.data.DefaultComparators;
import ch.njol.skript.classes.data.DefaultConverters;
import ch.njol.skript.classes.data.DefaultFunctions;
import ch.njol.skript.classes.data.JavaClasses;
import ch.njol.skript.classes.data.SkriptClasses;
import ch.njol.skript.command.Commands;
import ch.njol.skript.doc.Documentation;
import ch.njol.skript.events.EvtSkript;
import ch.njol.skript.hooks.Hook;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.Statement;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.BukkitLoggerFilter;
import ch.njol.skript.log.CountingLogHandler;
import ch.njol.skript.log.ErrorDescLogHandler;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.LogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.log.Verbosity;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.EmptyStacktraceException;
import ch.njol.skript.util.ExceptionUtils;
import ch.njol.skript.util.FileUtils;
import ch.njol.skript.util.Task;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.Version;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Closeable;
import ch.njol.util.NullableChecker;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.CheckedIterator;
import ch.njol.util.coll.iterator.EnumerationIterable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.eclipse.jdt.annotation.Nullable;

public final class Skript
extends JavaPlugin
implements Listener {
    public static String MIRRE = "V10";
    public static boolean DEV_BUILD = true;
    @Nullable
    private static Skript instance = null;
    private static boolean disabled = false;
    @Nullable
    private static Version version = null;
    public static final Message m_invalid_reload = new Message("skript.invalid reload");
    public static final Message m_finished_loading = new Message("skript.finished loading");
    private static Version minecraftVersion = new Version(666);
    private static boolean runningCraftBukkit = false;
    @Nullable
    static Metrics metrics;
    private static final Collection<Closeable> closeOnDisable;
    public static final String SCRIPTSFOLDER = "scripts";
    public static final double EPSILON = 1.0E-10;
    public static final double EPSILON_MULT = 1.00001;
    public static final int MAXBLOCKID = 255;
    public static final int MAXDATAVALUE = 65535;
    public static final Thread.UncaughtExceptionHandler UEH;
    private static boolean acceptRegistrations;
    private static final HashMap<String, SkriptAddon> addons;
    @Nullable
    private static SkriptAddon addon;
    private static final Collection<SyntaxElementInfo<? extends Condition>> conditions;
    private static final Collection<SyntaxElementInfo<? extends Effect>> effects;
    private static final Collection<SyntaxElementInfo<? extends Statement>> statements;
    private static final List<ExpressionInfo<?, ?>> expressions;
    private static final int[] expressionTypesStartIndices;
    private static final Collection<SkriptEventInfo<?>> events;
    private static final String EXCEPTION_PREFIX = "#!#! ";
    public static String SKRIPT_PREFIX;

    static {
        closeOnDisable = Collections.synchronizedCollection(new ArrayList());
        UEH = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(@Nullable Thread t, @Nullable Throwable e) {
                Skript.exception(e, "Exception in thread " + (t == null ? null : t.getName()));
            }
        };
        acceptRegistrations = true;
        addons = new HashMap();
        conditions = new ArrayList<SyntaxElementInfo<? extends Condition>>(50);
        effects = new ArrayList<SyntaxElementInfo<? extends Effect>>(50);
        statements = new ArrayList<SyntaxElementInfo<? extends Statement>>(100);
        expressions = new ArrayList(100);
        expressionTypesStartIndices = new int[ExpressionType.values().length];
        events = new ArrayList(50);
        SKRIPT_PREFIX = ChatColor.GRAY + "[" + ChatColor.GOLD + "Skript" + ChatColor.GRAY + "]" + ChatColor.RESET + " ";
    }

    public static Skript getInstance() {
        Skript i = instance;
        if (i == null) {
            throw new IllegalStateException();
        }
        return i;
    }

    public Skript() throws IllegalStateException {
        if (instance != null) {
            throw new IllegalStateException("Cannot create multiple instances of Skript!");
        }
        instance = this;
    }

    public static Version getVersion() {
        Version v = version;
        if (v == null) {
            throw new IllegalStateException();
        }
        return v;
    }

    public void onEnable() {
        block41: {
            File scripts;
            if (disabled) {
                Skript.error(m_invalid_reload.toString());
                this.setEnabled(false);
                return;
            }
            Language.loadDefault(Skript.getAddonInstance());
            Workarounds.init();
            version = new Version(this.getDescription().getVersion());
            runningCraftBukkit = Bukkit.getServer().getClass().getName().equals("org.bukkit.craftbukkit.CraftServer");
            String bukkitV = Bukkit.getBukkitVersion();
            Matcher m = Pattern.compile("\\d+\\.\\d+(\\.\\d+)?").matcher(bukkitV);
            if (!m.find()) {
                Skript.error("The Bukkit version '" + bukkitV + "' does not contain a version number which is required for Skript to enable or disable certain features. " + "Skript will still work, but you might get random errors if you use features that are not available in your version of Bukkit.");
                minecraftVersion = new Version(666, 0, 0);
            } else {
                minecraftVersion = new Version(m.group());
            }
            if (!this.getDataFolder().isDirectory()) {
                this.getDataFolder().mkdirs();
            }
            if (!(scripts = new File(this.getDataFolder(), SCRIPTSFOLDER)).isDirectory()) {
                ZipFile f = null;
                try {
                    if (!scripts.mkdirs()) {
                        throw new IOException("Could not create the directory " + scripts);
                    }
                    f = new ZipFile(this.getFile());
                    for (ZipEntry zipEntry : new EnumerationIterable<ZipEntry>(f.entries())) {
                        File af;
                        if (zipEntry.isDirectory()) continue;
                        File saveTo = null;
                        if (zipEntry.getName().startsWith("scripts/")) {
                            String fileName = zipEntry.getName().substring(zipEntry.getName().lastIndexOf(47) + 1);
                            saveTo = new File(scripts, String.valueOf(fileName.startsWith("-") ? "" : "-") + fileName);
                        } else if (zipEntry.getName().equals("config.sk")) {
                            File cf = new File(this.getDataFolder(), zipEntry.getName());
                            if (!cf.exists()) {
                                saveTo = cf;
                            }
                        } else if (zipEntry.getName().startsWith("aliases-") && zipEntry.getName().endsWith(".sk") && !zipEntry.getName().contains("/")) {
                            af = new File(this.getDataFolder(), zipEntry.getName());
                            if (!af.exists()) {
                                saveTo = af;
                            }
                        } else if (zipEntry.getName().startsWith("features.sk") && !(af = new File(this.getDataFolder(), zipEntry.getName())).exists()) {
                            saveTo = af;
                        }
                        if (saveTo == null) continue;
                        try (InputStream in = f.getInputStream(zipEntry);){
                            assert (in != null);
                            FileUtils.save(in, saveTo);
                        }
                    }
                    Skript.info("Successfully generated the config, the example scripts and the aliases files.");
                }
                catch (ZipException zipException) {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block41;
                }
                catch (IOException iOException) {
                    try {
                        Skript.error("Error generating the default files: " + ExceptionUtils.toString(iOException));
                        break block41;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (f != null) {
                            try {
                                f.close();
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                }
                if (f == null) break block41;
                try {
                    f.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.getCommand("skript").setExecutor((CommandExecutor)new SkriptCommand());
        new JavaClasses();
        new BukkitClasses();
        new BukkitEventValues();
        new SkriptClasses();
        new DefaultComparators();
        new DefaultConverters();
        new DefaultFunctions();
        try {
            Skript.getAddonInstance().loadClasses("ch.njol.skript", "conditions", "effects", "events", "expressions", "entity");
        }
        catch (Exception e) {
            Skript.exception((Throwable)e, "Could not load required .class files: " + e.getLocalizedMessage());
            this.setEnabled(false);
            return;
        }
        SkriptConfig.load();
        Language.setUseLocal(true);
        if (SkriptConfig.checkForNewVersion.value().booleanValue()) {
            Updater.start();
        }
        Aliases.load();
        Commands.registerListeners();
        if (Skript.logNormal()) {
            Skript.info(" " + Language.get("skript.copyright"));
        }
        final long tick = Skript.testing() ? ((World)Bukkit.getWorlds().get(0)).getFullTime() : 0L;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Object c;
                block23: {
                    if (!$assertionsDisabled && ((World)Bukkit.getWorlds().get(0)).getFullTime() != tick) {
                        throw new AssertionError();
                    }
                    try {
                        JarFile jar = new JarFile(Skript.this.getFile());
                        try {
                            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                                if (!e.getName().startsWith("ch/njol/skript/hooks/") || !e.getName().endsWith("Hook.class") || StringUtils.count(e.getName(), '/') > 5) continue;
                                c = e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length());
                                try {
                                    Class<?> hook = Class.forName((String)c, true, Skript.this.getClassLoader());
                                    if (hook == null || !Hook.class.isAssignableFrom(hook) || hook.isInterface() || Hook.class == hook) continue;
                                    hook.getDeclaredConstructor(new Class[0]).setAccessible(true);
                                    hook.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                }
                                catch (ClassNotFoundException ex) {
                                    Skript.exception((Throwable)ex, "Cannot load class " + (String)c);
                                }
                                catch (ExceptionInInitializerError err) {
                                    Skript.exception(err.getCause(), "Class " + (String)c + " generated an exception while loading");
                                }
                            }
                        }
                        finally {
                            try {
                                jar.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception e) {
                        Skript.error("Error while loading plugin hooks" + (e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage()));
                        if (!Skript.testing()) break block23;
                        e.printStackTrace();
                    }
                }
                Language.setUseLocal(false);
                Skript.stopAcceptingRegistrations();
                Documentation.generate();
                if (Skript.logNormal()) {
                    Skript.info("Loading variables...");
                }
                long vls = System.currentTimeMillis();
                1 h = SkriptLogger.startLogHandler(new ErrorDescLogHandler(){

                    @Override
                    public LogHandler.LogResult log(LogEntry entry) {
                        super.log(entry);
                        if (entry.level.intValue() >= Level.SEVERE.intValue()) {
                            Skript.logEx(entry.message);
                            return LogHandler.LogResult.DO_NOT_LOG;
                        }
                        return LogHandler.LogResult.LOG;
                    }

                    @Override
                    protected void beforeErrors() {
                        Skript.logEx();
                        Skript.logEx("===!!!=== Skript variable load error ===!!!===");
                        Skript.logEx("Unable to load (all) variables:");
                    }

                    @Override
                    protected void afterErrors() {
                        Skript.logEx();
                        Skript.logEx("Skript will work properly, but old variables might not be available at all and new ones may or may not be saved until Skript is able to create a backup of the old file and/or is able to connect to the database (which requires a restart of Skript)!");
                        Skript.logEx();
                    }

                    @Override
                    protected void onStop() {
                        super.onStop();
                    }
                });
                c = SkriptLogger.startLogHandler(new CountingLogHandler(SkriptLogger.SEVERE));
                try {
                    if (!Variables.load() && ((CountingLogHandler)c).getCount() == 0) {
                        Skript.error("(no information available)");
                    }
                }
                finally {
                    ((LogHandler)c).stop();
                    h.stop();
                }
                long vld = System.currentTimeMillis() - vls;
                if (Skript.logNormal()) {
                    Skript.info("Loaded " + Variables.numVariables() + " variables in " + (double)(vld / 100L) / 10.0 + " seconds");
                }
                ConsoleCommandSender console = Bukkit.getConsoleSender();
                if (!$assertionsDisabled && console == null) {
                    throw new AssertionError();
                }
                ScriptLoader.loadScripts((CommandSender)console);
                Skript.info(m_finished_loading.toString());
                EvtSkript.onSkriptStart();
                Metrics metrics = new Metrics((Plugin)Skript.this);
                Metrics.Graph scriptData = metrics.createGraph("data");
                scriptData.addPlotter(new Metrics.Plotter(Skript.SCRIPTSFOLDER){

                    @Override
                    public int getValue() {
                        return ScriptLoader.loadedScripts();
                    }
                });
                scriptData.addPlotter(new Metrics.Plotter("triggers"){

                    @Override
                    public int getValue() {
                        return ScriptLoader.loadedTriggers();
                    }
                });
                scriptData.addPlotter(new Metrics.Plotter("commands"){

                    @Override
                    public int getValue() {
                        return ScriptLoader.loadedCommands();
                    }
                });
                scriptData.addPlotter(new Metrics.Plotter("functions"){

                    @Override
                    public int getValue() {
                        return ScriptLoader.loadedFunctions();
                    }
                });
                scriptData.addPlotter(new Metrics.Plotter("variables"){

                    @Override
                    public int getValue() {
                        return Variables.numVariables();
                    }
                });
                Metrics.Graph language = metrics.createGraph("language");
                language.addPlotter(new Metrics.Plotter(){

                    @Override
                    public int getValue() {
                        return 1;
                    }

                    @Override
                    public String getColumnName() {
                        return Language.getName();
                    }
                });
                Metrics.Graph similarPlugins = metrics.createGraph("similar plugins");
                String[] stringArray = new String[]{"VariableTriggers", "CommandHelper", "Denizen", "rTriggers", "kTriggers", "TriggerCmds", "BlockScripts", "ScriptBlock", "buscript", "BukkitScript"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    final String plugin = stringArray[n2];
                    if (!$assertionsDisabled && plugin == null) {
                        throw new AssertionError();
                    }
                    similarPlugins.addPlotter(new Metrics.Plotter(plugin){

                        @Override
                        public int getValue() {
                            return Bukkit.getPluginManager().getPlugin(plugin) != null ? 1 : 0;
                        }
                    });
                    ++n2;
                }
                metrics.start();
                Skript.metrics = metrics;
                final Filter f = new Filter(){

                    @Override
                    public boolean isLoggable(@Nullable LogRecord record) {
                        if (record == null) {
                            return false;
                        }
                        return record.getMessage() == null || !record.getMessage().toLowerCase().startsWith("can't keep up!");
                    }
                };
                BukkitLoggerFilter.addFilter(f);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Skript.this, new Runnable(){

                    @Override
                    public void run() {
                        BukkitLoggerFilter.removeFilter(f);
                    }
                }, 1L);
            }
        });
        Bukkit.getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(final PlayerJoinEvent e) {
                if (e.getPlayer().hasPermission("skript.admin")) {
                    new Task((Plugin)Skript.this, 0L){

                        @Override
                        public void run() {
                            Player p = e.getPlayer();
                            if (p == null) {
                                return;
                            }
                            switch (Updater.state) {
                                case UPDATE_AVAILABLE: {
                                    Skript.info((CommandSender)p, "" + Updater.m_update_available);
                                    break;
                                }
                                case DOWNLOADED: {
                                    Skript.info((CommandSender)p, "" + Updater.m_downloaded);
                                }
                            }
                        }
                    };
                }
            }
        }, (Plugin)this);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Skript.getInstance(), new Runnable(){

            @Override
            public void run() {
                String s = Skript.getMirreVersion();
                if (!s.equalsIgnoreCase(MIRRE) && !DEV_BUILD) {
                    Bukkit.getLogger().info("[Skript] A new version of Skript Fixes has been found. Skript 2.2 Fixes " + s + " has been released. It's recommended to try the latest version.");
                }
            }
        });
    }

    static String getMirreVersion() {
        try {
            URL url = new URL("http://mirre.eu.pn/version/");
            Scanner scanner = new Scanner(url.openStream());
            String str = "";
            while (scanner.hasNext()) {
                str = String.valueOf(str) + scanner.next();
            }
            scanner.close();
            return str;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static Version getMinecraftVersion() {
        return minecraftVersion;
    }

    public static boolean isRunningCraftBukkit() {
        return runningCraftBukkit;
    }

    public static boolean isRunningMinecraft(int major, int minor) {
        return minecraftVersion.compareTo(major, minor) >= 0;
    }

    public static boolean isRunningMinecraft(int major, int minor, int revision) {
        return minecraftVersion.compareTo(major, minor, revision) >= 0;
    }

    public static boolean isRunningMinecraft(Version v) {
        return minecraftVersion.compareTo(v) >= 0;
    }

    @Deprecated
    public static final boolean supports(String className) {
        return Skript.classExists(className);
    }

    public static final boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final boolean methodExists(Class<?> c, String methodName, Class<?> ... parameterTypes) {
        try {
            c.getDeclaredMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static final boolean methodExists(Class<?> c, String methodName, Class<?>[] parameterTypes, Class<?> returnType) {
        try {
            Method m = c.getDeclaredMethod(methodName, parameterTypes);
            return m.getReturnType() == returnType;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static final boolean fieldExists(Class<?> c, String fieldName) {
        try {
            c.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    @Nullable
    public static Metrics getMetrics() {
        return metrics;
    }

    static final void disableScripts() {
        VariableString.variableNames.clear();
        SkriptEventHandler.removeAllTriggers();
        Commands.clearCommands();
        Functions.clearFunctions();
    }

    static final void reload(CommandSender viewer) {
        Skript.disableScripts();
        Skript.reloadMainConfig();
        Skript.reloadAliases();
        ScriptLoader.loadScripts(viewer);
    }

    static final void reloadScripts(CommandSender viewer) {
        Skript.disableScripts();
        ScriptLoader.loadScripts(viewer);
    }

    static final void reloadMainConfig() {
        SkriptConfig.load();
    }

    static final void reloadAliases() {
        Aliases.clear();
        Aliases.load();
    }

    public static void closeOnDisable(Closeable closeable) {
        closeOnDisable.add(closeable);
    }

    public void onDisable() {
        if (disabled) {
            return;
        }
        disabled = true;
        EvtSkript.onSkriptStop();
        Skript.disableScripts();
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        for (Closeable c : closeOnDisable) {
            try {
                c.close();
            }
            catch (Exception e) {
                Skript.exception((Throwable)e, "An error occurred while shutting down.", "This might or might not cause any issues.");
            }
        }
        Thread t = Skript.newThread(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        Field modifiers = Field.class.getDeclaredField("modifiers");
                        modifiers.setAccessible(true);
                        try (JarFile jar = new JarFile(Skript.this.getFile());){
                            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                                if (!e.getName().endsWith(".class")) continue;
                                try {
                                    Class<?> c = Class.forName(e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length()), false, Skript.this.getClassLoader());
                                    Field[] fieldArray = c.getDeclaredFields();
                                    int n = fieldArray.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        Field f = fieldArray[n2];
                                        if (Modifier.isStatic(f.getModifiers()) && !f.getType().isPrimitive()) {
                                            if (Modifier.isFinal(f.getModifiers())) {
                                                modifiers.setInt(f, f.getModifiers() & 0xFFFFFFEF);
                                            }
                                            f.setAccessible(true);
                                            f.set(null, null);
                                        }
                                        ++n2;
                                    }
                                }
                                catch (Throwable ex) {
                                    if (!Skript.testing()) continue;
                                    ex.printStackTrace();
                                }
                            }
                        }
                    }
                    catch (Throwable ex) {
                        if (!Skript.testing()) break block13;
                        ex.printStackTrace();
                    }
                }
            }
        }, "Skript cleanup thread");
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public static void outdatedError() {
        Skript.error("Skript v" + Skript.getInstance().getDescription().getVersion() + " is not fully compatible with Bukkit " + Bukkit.getVersion() + ". Some feature(s) will be broken until you update Skript.");
    }

    public static void outdatedError(Exception e) {
        Skript.outdatedError();
        if (Skript.testing()) {
            e.printStackTrace();
        }
    }

    public static final String toString(double n) {
        return StringUtils.toString(n, SkriptConfig.numberAccuracy.value());
    }

    public static final Thread newThread(Runnable r, String name) {
        Thread t = new Thread(r, name);
        t.setUncaughtExceptionHandler(UEH);
        return t;
    }

    public static boolean isAcceptRegistrations() {
        return acceptRegistrations;
    }

    public static void checkAcceptRegistrations() {
        if (!acceptRegistrations) {
            throw new SkriptAPIException("Registering is disabled after initialisation!");
        }
    }

    private static void stopAcceptingRegistrations() {
        acceptRegistrations = false;
        Converters.createMissingConverters();
        Classes.onRegistrationsStop();
    }

    public static SkriptAddon registerAddon(JavaPlugin p) {
        Skript.checkAcceptRegistrations();
        if (addons.containsKey(p.getName())) {
            throw new IllegalArgumentException("The plugin " + p.getName() + " is already registered");
        }
        SkriptAddon addon = new SkriptAddon(p);
        addons.put(p.getName(), addon);
        return addon;
    }

    @Nullable
    public static SkriptAddon getAddon(JavaPlugin p) {
        return addons.get(p.getName());
    }

    @Nullable
    public static SkriptAddon getAddon(String name) {
        return addons.get(name);
    }

    public static Collection<SkriptAddon> getAddons() {
        return Collections.unmodifiableCollection(addons.values());
    }

    public static SkriptAddon getAddonInstance() {
        SkriptAddon a = addon;
        if (a == null) {
            addon = new SkriptAddon(Skript.getInstance()).setLanguageFileDirectory("lang");
            return addon;
        }
        return a;
    }

    public static <E extends Condition> void registerCondition(Class<E> condition, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, condition);
        conditions.add(info);
        statements.add(info);
    }

    public static <E extends Effect> void registerEffect(Class<E> effect, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        SyntaxElementInfo<E> info = new SyntaxElementInfo<E>(patterns, effect);
        effects.add(info);
        statements.add(info);
    }

    public static Collection<SyntaxElementInfo<? extends Statement>> getStatements() {
        return statements;
    }

    public static Collection<SyntaxElementInfo<? extends Condition>> getConditions() {
        return conditions;
    }

    public static Collection<SyntaxElementInfo<? extends Effect>> getEffects() {
        return effects;
    }

    public static <E extends Expression<T>, T> void registerExpression(Class<E> c, Class<T> returnType, ExpressionType type, String ... patterns) throws IllegalArgumentException {
        Skript.checkAcceptRegistrations();
        if (returnType.isAnnotation() || returnType.isArray() || returnType.isPrimitive()) {
            throw new IllegalArgumentException("returnType must be a normal type");
        }
        ExpressionInfo<E, T> info = new ExpressionInfo<E, T>(patterns, returnType, c);
        int i = type.ordinal() + 1;
        while (i < ExpressionType.values().length) {
            int n = i++;
            expressionTypesStartIndices[n] = expressionTypesStartIndices[n] + 1;
        }
        expressions.add(expressionTypesStartIndices[type.ordinal()], info);
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions() {
        return expressions.iterator();
    }

    public static Iterator<ExpressionInfo<?, ?>> getExpressions(final Class<?> ... returnTypes) {
        return new CheckedIterator(Skript.getExpressions(), new NullableChecker<ExpressionInfo<?, ?>>(){

            @Override
            public boolean check(@Nullable ExpressionInfo<?, ?> i) {
                if (i == null || i.returnType == Object.class) {
                    return true;
                }
                Class[] classArray = returnTypes;
                int n = returnTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class returnType = classArray[n2];
                    if (!$assertionsDisabled && returnType == null) {
                        throw new AssertionError();
                    }
                    if (Converters.converterExists(i.returnType, returnType)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> registerEvent(String name, Class<E> c, Class<? extends Event> event, String ... patterns) {
        Skript.checkAcceptRegistrations();
        SkriptEventInfo<E> r = new SkriptEventInfo<E>(name, patterns, c, CollectionUtils.array(event));
        events.add(r);
        return r;
    }

    public static <E extends SkriptEvent> SkriptEventInfo<E> registerEvent(String name, Class<E> c, Class<? extends Event>[] events, String ... patterns) {
        Skript.checkAcceptRegistrations();
        SkriptEventInfo<E> r = new SkriptEventInfo<E>(name, patterns, c, events);
        Skript.events.add(r);
        return r;
    }

    public static final Collection<SkriptEventInfo<?>> getEvents() {
        return events;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean dispatchCommand(CommandSender sender, String command) {
        try {
            if (sender instanceof Player) {
                PlayerCommandPreprocessEvent e = new PlayerCommandPreprocessEvent((Player)sender, "/" + command);
                Bukkit.getPluginManager().callEvent((Event)e);
                if (!e.isCancelled() && e.getMessage() != null && e.getMessage().startsWith("/")) {
                    return Bukkit.dispatchCommand((CommandSender)e.getPlayer(), (String)e.getMessage().substring(1));
                }
                return false;
            }
            ServerCommandEvent e = new ServerCommandEvent(sender, command);
            Bukkit.getPluginManager().callEvent((Event)e);
            if (e.getCommand() != null && !e.getCommand().isEmpty()) {
                return Bukkit.dispatchCommand((CommandSender)e.getSender(), (String)e.getCommand());
            }
            return false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static final boolean logNormal() {
        return SkriptLogger.log(Verbosity.NORMAL);
    }

    public static final boolean logHigh() {
        return SkriptLogger.log(Verbosity.HIGH);
    }

    public static final boolean logVeryHigh() {
        return SkriptLogger.log(Verbosity.VERY_HIGH);
    }

    public static final boolean debug() {
        return SkriptLogger.debug();
    }

    public static final boolean testing() {
        return Skript.debug() || Skript.class.desiredAssertionStatus();
    }

    public static final boolean log(Verbosity minVerb) {
        return SkriptLogger.log(minVerb);
    }

    public static void debug(String info) {
        if (!Skript.debug()) {
            return;
        }
        SkriptLogger.log(SkriptLogger.DEBUG, info);
    }

    public static void info(String info) {
        SkriptLogger.log(Level.INFO, info);
    }

    public static void warning(String warning) {
        SkriptLogger.log(Level.WARNING, warning);
    }

    public static void error(@Nullable String error) {
        if (error != null) {
            SkriptLogger.log(Level.SEVERE, error);
        }
    }

    public static void error(String error, ErrorQuality quality) {
        SkriptLogger.log(new LogEntry(SkriptLogger.SEVERE, quality, error));
    }

    public static final EmptyStacktraceException exception(String ... info) {
        return Skript.exception(null, info);
    }

    public static final EmptyStacktraceException exception(@Nullable Throwable cause, String ... info) {
        return Skript.exception(cause, null, null, info);
    }

    public static final EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable Thread thread, String ... info) {
        return Skript.exception(cause, thread, null, info);
    }

    public static final EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable TriggerItem item, String ... info) {
        return Skript.exception(cause, null, item, info);
    }

    public static final EmptyStacktraceException exception(@Nullable Throwable cause, @Nullable Thread thread, @Nullable TriggerItem item, String ... info) {
        Skript.logEx();
        Skript.logEx("[Skript] Severe Error:");
        Skript.logEx(info);
        Skript.logEx();
        Skript.logEx("If you're developing an add-on for Skript this likely means that you have done something wrong.");
        Skript.logEx("If you're a server admin however please go to https://github.com/bensku/Skript/issues/");
        Skript.logEx("and check whether this error has already been reported.");
        Skript.logEx("If not please create a new ticket with a meaningful title, copy & paste this whole error into it (or use paste service),");
        Skript.logEx("and describe what you did before it happened and/or what you think caused the error.");
        Skript.logEx("If you think that it's a trigger that's causing the error please post the trigger as well.");
        Skript.logEx("By following this guide fixing the error should be easy and done fast.");
        Skript.logEx();
        Skript.logEx("Stack trace:");
        if (cause == null || cause.getStackTrace().length == 0) {
            Skript.logEx("  warning: no/empty exception given, dumping current stack trace instead");
            cause = new Exception(cause);
        }
        boolean first = true;
        while (cause != null) {
            Skript.logEx(String.valueOf(first ? "" : "Caused by: ") + cause.toString());
            StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                Skript.logEx("    at " + e.toString());
                ++n2;
            }
            cause = cause.getCause();
            first = false;
        }
        Skript.logEx();
        Skript.logEx("Version Information:");
        Skript.logEx("  Skript: " + Skript.getVersion());
        Skript.logEx("  Bukkit: " + Bukkit.getBukkitVersion());
        Skript.logEx("  Minecraft: " + Skript.getMinecraftVersion());
        Skript.logEx("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skript.logEx("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skript.logEx();
        Skript.logEx("Running CraftBukkit: " + runningCraftBukkit);
        Skript.logEx();
        Skript.logEx("Current node: " + SkriptLogger.getNode());
        Skript.logEx("Current item: " + (item == null ? "null" : item.toString(null, true)));
        Skript.logEx();
        Skript.logEx("Thread: " + (thread == null ? Thread.currentThread() : thread).getName());
        Skript.logEx();
        Skript.logEx("End of Error.");
        Skript.logEx();
        return new EmptyStacktraceException();
    }

    static final void logEx() {
        SkriptLogger.LOGGER.severe(EXCEPTION_PREFIX);
    }

    static final void logEx(String ... lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            SkriptLogger.LOGGER.severe(EXCEPTION_PREFIX + line);
            ++n2;
        }
    }

    public static void info(CommandSender sender, String info) {
        sender.sendMessage(String.valueOf(SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(info));
    }

    public static void broadcast(String message, String permission) {
        Bukkit.broadcast((String)(String.valueOf(SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(message)), (String)permission);
    }

    public static void adminBroadcast(String message) {
        Bukkit.broadcast((String)(String.valueOf(SKRIPT_PREFIX) + Utils.replaceEnglishChatStyles(message)), (String)"skript.admin");
    }

    public static void message(CommandSender sender, String info) {
        sender.sendMessage(Utils.replaceEnglishChatStyles(info));
    }

    public static void error(CommandSender sender, String error) {
        sender.sendMessage(String.valueOf(SKRIPT_PREFIX) + ChatColor.DARK_RED + Utils.replaceEnglishChatStyles(error));
    }

    public static boolean isPrerelease() {
        return true;
    }
}

