/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.localization.Noun;
import ch.njol.util.coll.CollectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.eclipse.jdt.annotation.Nullable;

public enum StructureType {
    TREE(TreeType.TREE, TreeType.BIG_TREE, TreeType.REDWOOD, TreeType.TALL_REDWOOD, TreeType.SMALL_JUNGLE, TreeType.JUNGLE, TreeType.SWAMP),
    REGULAR(TreeType.TREE, TreeType.BIG_TREE),
    SMALL_REGULAR(TreeType.TREE),
    BIG_REGULAR(TreeType.BIG_TREE),
    REDWOOD(TreeType.REDWOOD, TreeType.TALL_REDWOOD),
    SMALL_REDWOOD(TreeType.REDWOOD),
    BIG_REDWOOD(TreeType.TALL_REDWOOD),
    JUNGLE(TreeType.SMALL_JUNGLE, TreeType.JUNGLE),
    SMALL_JUNGLE(TreeType.SMALL_JUNGLE),
    BIG_JUNGLE(TreeType.JUNGLE),
    JUNGLE_BUSH(TreeType.JUNGLE_BUSH),
    SWAMP(TreeType.SWAMP),
    MUSHROOM(TreeType.RED_MUSHROOM, TreeType.BROWN_MUSHROOM),
    RED_MUSHROOM(TreeType.RED_MUSHROOM),
    BROWN_MUSHROOM(TreeType.BROWN_MUSHROOM);

    private Noun name;
    private final TreeType[] types;
    static final Map<Pattern, StructureType> parseMap;

    static {
        parseMap = new HashMap<Pattern, StructureType>();
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                parseMap.clear();
            }
        });
    }

    private StructureType(TreeType ... types) {
        this.types = types;
        this.name = new Noun("tree types." + this.name() + ".name");
    }

    public void grow(Location loc) {
        loc.getWorld().generateTree(loc, CollectionUtils.getRandom(this.types));
    }

    public void grow(Block b) {
        b.getWorld().generateTree(b.getLocation(), CollectionUtils.getRandom(this.types));
    }

    public TreeType[] getTypes() {
        return this.types;
    }

    public String toString() {
        return this.name.toString();
    }

    public String toString(int flags) {
        return this.name.toString(flags);
    }

    public Noun getName() {
        return this.name;
    }

    public boolean is(TreeType type) {
        return CollectionUtils.contains(this.types, type);
    }

    @Nullable
    public static StructureType fromName(String s) {
        if (parseMap.isEmpty()) {
            StructureType[] structureTypeArray = StructureType.values();
            int n = structureTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StructureType t = structureTypeArray[n2];
                String pattern = Language.get("tree types." + t.name() + ".pattern");
                parseMap.put(Pattern.compile(pattern, 2), t);
                ++n2;
            }
        }
        s = s.toLowerCase();
        for (Map.Entry<Pattern, StructureType> e : parseMap.entrySet()) {
            if (!e.getKey().matcher(s).matches()) continue;
            return e.getValue();
        }
        return null;
    }
}

