/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.doc;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.ExpressionInfo;
import ch.njol.skript.lang.SkriptEventInfo;
import ch.njol.skript.lang.SyntaxElementInfo;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class HTMLGenerator {
    private File template;
    private File output;
    private String skeleton;

    public HTMLGenerator(File templateDir, File outputDir) {
        this.template = templateDir;
        this.output = outputDir;
        this.skeleton = this.readFile(new File(this.template + "/template.html"));
    }

    public void generate() {
        File[] fileArray = this.template.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().equals("css")) {
                File cssTo = new File(this.output + "/css");
                cssTo.mkdirs();
                File[] fileArray2 = new File(this.template + "/css").listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File css = fileArray2[n4];
                    this.writeFile(new File(cssTo + "/" + css.getName()), this.readFile(css));
                    ++n4;
                }
            } else if (!f.isDirectory() && !f.getName().endsWith("template.html") && f.getName().endsWith(".html")) {
                Skript.info("Creating documentation for " + f.getName());
                String content = this.readFile(f);
                String page = this.skeleton.replace("${content}", content);
                page = page.replace("${skript.version}", Skript.getVersion().toString());
                ArrayList replace = Lists.newArrayList();
                int include = page.indexOf("${include");
                while (include != -1) {
                    int endIncl = page.indexOf("}", include);
                    String name = page.substring(include + 10, endIncl);
                    replace.add(name);
                    include = page.indexOf("${include", endIncl);
                }
                for (String name : replace) {
                    String temp = this.readFile(new File(this.template + "/templates/" + name));
                    page = page.replace("${include " + name + "}", temp);
                }
                int generate = page.indexOf("${generate");
                while (generate != -1) {
                    int nextBracket = page.indexOf("}", generate);
                    String[] genParams = page.substring(generate + 11, nextBracket).split(" ");
                    String generated = "";
                    String descTemp = this.readFile(new File(this.template + "/templates/" + genParams[1]));
                    String genType = genParams[0];
                    if (genType.equals("expressions")) {
                        Iterator<ExpressionInfo<?, ?>> iterator = Skript.getExpressions();
                        while (iterator.hasNext()) {
                            ExpressionInfo<?, ?> expressionInfo = iterator.next();
                            assert (expressionInfo != null);
                            if (expressionInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            String desc = this.generateAnnotated(descTemp, expressionInfo);
                            generated = String.valueOf(generated) + desc;
                        }
                    } else if (genType.equals("effects")) {
                        for (SyntaxElementInfo<? extends Effect> syntaxElementInfo : Skript.getEffects()) {
                            assert (syntaxElementInfo != null);
                            if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            generated = String.valueOf(generated) + this.generateAnnotated(descTemp, syntaxElementInfo);
                        }
                    } else if (genType.equals("conditions")) {
                        for (SyntaxElementInfo<? extends Condition> syntaxElementInfo : Skript.getConditions()) {
                            assert (syntaxElementInfo != null);
                            if (syntaxElementInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            generated = String.valueOf(generated) + this.generateAnnotated(descTemp, syntaxElementInfo);
                        }
                    } else if (genType.equals("events")) {
                        for (SkriptEventInfo<?> skriptEventInfo : Skript.getEvents()) {
                            assert (skriptEventInfo != null);
                            if (skriptEventInfo.c.getAnnotation(NoDoc.class) != null) continue;
                            generated = String.valueOf(generated) + this.generateEvent(descTemp, skriptEventInfo);
                        }
                    } else if (genType.equals("classes")) {
                        for (ClassInfo<?> classInfo : Classes.getClassInfos()) {
                            if (ClassInfo.NO_DOC.equals(classInfo.getDocName())) continue;
                            assert (classInfo != null);
                            generated = String.valueOf(generated) + this.generateClass(descTemp, classInfo);
                        }
                    } else if (genType.equals("functions")) {
                        Iterable<JavaFunction<?>> iterable = Functions.getJavaFunctions();
                        for (JavaFunction<?> javaFunction : iterable) {
                            generated = String.valueOf(generated) + this.generateFunction(descTemp, javaFunction);
                        }
                    }
                    page = page.replace(page.substring(generate, nextBracket + 1), generated);
                    generate = page.indexOf("${generate", nextBracket);
                }
                this.writeFile(new File(this.output + "/" + f.getName()), page);
            }
            ++n2;
        }
    }

    String generateAnnotated(String descTemp, SyntaxElementInfo<?> info) {
        Class c = info.c;
        String desc = "";
        Name name = c.getAnnotation(Name.class);
        desc = descTemp.replace("${element.name}", name == null ? "Unknown Name" : name.value());
        Since since = c.getAnnotation(Since.class);
        desc = desc.replace("${element.since}", since == null ? "unknown" : since.value());
        Description description = c.getAnnotation(Description.class);
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join((Object[])(description == null ? new String[]{} : description.value())));
        Examples examples = c.getAnnotation(Examples.class);
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join((Object[])(examples == null ? new String[]{} : examples.value())));
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] stringArray = info.patterns;
            int n = info.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = String.valueOf(patterns) + parsed;
                ++n2;
            }
            String toReplace = "${generate element.patterns " + split[1] + "}";
            desc = desc.replace(toReplace, patterns);
        }
        return desc;
    }

    String generateEvent(String descTemp, SkriptEventInfo<?> info) {
        String desc = "";
        String docName = info.getName();
        desc = descTemp.replace("${element.name}", docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] stringArray = info.patterns;
            int n = info.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = String.valueOf(patterns) + parsed;
                ++n2;
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
        }
        return desc;
    }

    String generateClass(String descTemp, ClassInfo<?> info) {
        String desc = "";
        String docName = info.getDocName();
        desc = descTemp.replace("${element.name}", docName == null ? "Unknown Name" : docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            String[] lines = info.getUsage();
            if (lines == null) continue;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String parsed = pattern.replace("${element.pattern}", line);
                patterns = String.valueOf(patterns) + parsed;
                ++n2;
            }
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
        }
        return desc;
    }

    String generateFunction(String descTemp, JavaFunction<?> info) {
        String desc = "";
        String docName = info.getName();
        desc = descTemp.replace("${element.name}", docName);
        String since = info.getSince();
        desc = desc.replace("${element.since}", since == null ? "unknown" : since);
        Object[] description = info.getDescription();
        desc = desc.replace("${element.desc}", Joiner.on((String)"\n").join(description == null ? new String[]{} : description));
        Object[] examples = info.getExamples();
        desc = desc.replace("${element.examples}", Joiner.on((String)"\n<br>").join(examples == null ? new String[]{} : examples));
        ArrayList toGen = Lists.newArrayList();
        int generate = desc.indexOf("${generate");
        while (generate != -1) {
            int nextBracket = desc.indexOf("}", generate);
            String data = desc.substring(generate + 11, nextBracket);
            toGen.add(data);
            generate = desc.indexOf("${generate", nextBracket);
        }
        for (String data : toGen) {
            String[] split = data.split(" ");
            String pattern = this.readFile(new File(this.template + "/templates/" + split[1]));
            String patterns = "";
            Parameter<?>[] params = info.getParameters();
            Object[] types = new String[params.length];
            int i = 0;
            while (i < types.length) {
                types[i] = params[i].getType().getDocName();
                ++i;
            }
            String line = String.valueOf(docName) + "(" + Joiner.on((String)", ").join(types) + ")";
            patterns = String.valueOf(patterns) + pattern.replace("${element.pattern}", line);
            desc = desc.replace("${generate element.patterns " + split[1] + "}", patterns);
        }
        return desc;
    }

    String readFile(File f) {
        try {
            return Files.toString((File)f, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    void writeFile(File f, String data) {
        try {
            Files.write((CharSequence)data, (File)f, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

