/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.yggdrasil;

import ch.njol.yggdrasil.Fields;
import ch.njol.yggdrasil.PseudoEnum;
import ch.njol.yggdrasil.Tag;
import ch.njol.yggdrasil.Yggdrasil;
import ch.njol.yggdrasil.YggdrasilException;
import ch.njol.yggdrasil.YggdrasilSerializable;
import ch.njol.yggdrasil.YggdrasilSerializer;
import java.io.Closeable;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public abstract class YggdrasilInputStream
implements Closeable {
    protected final Yggdrasil yggdrasil;
    private final List<Object> readObjects = new ArrayList<Object>();

    protected YggdrasilInputStream(Yggdrasil yggdrasil) {
        this.yggdrasil = yggdrasil;
    }

    protected abstract Tag readTag() throws IOException;

    protected abstract Object readPrimitive(Tag var1) throws IOException;

    protected abstract Object readPrimitive_(Tag var1) throws IOException;

    protected abstract String readString() throws IOException;

    protected abstract Class<?> readArrayComponentType() throws IOException;

    protected abstract int readArrayLength() throws IOException;

    private final void readArrayContents(Object array) throws IOException {
        if (array.getClass().getComponentType().isPrimitive()) {
            int length = Array.getLength(array);
            Tag type = Tag.getType(array.getClass().getComponentType());
            int i = 0;
            while (i < length) {
                Array.set(array, i, this.readPrimitive_(type));
                ++i;
            }
        } else {
            int i = 0;
            while (i < ((Object[])array).length) {
                ((Object[])array)[i] = this.readObject();
                ++i;
            }
        }
    }

    protected abstract Class<?> readEnumType() throws IOException;

    protected abstract String readEnumID() throws IOException;

    private final Object readEnum() throws IOException {
        Class<?> c = this.readEnumType();
        String id = this.readEnumID();
        if (Enum.class.isAssignableFrom(c)) {
            return Yggdrasil.getEnumConstant(c, id);
        }
        if (PseudoEnum.class.isAssignableFrom(c)) {
            Object o = PseudoEnum.valueOf(c, id);
            if (o != null) {
                return o;
            }
            throw new StreamCorruptedException("Enum constant " + id + " does not exist in " + c);
        }
        throw new StreamCorruptedException(c + " is not an enum type");
    }

    protected abstract Class<?> readClass() throws IOException;

    protected abstract int readReference() throws IOException;

    protected abstract Class<?> readObjectType() throws IOException;

    protected abstract short readNumFields() throws IOException;

    protected abstract String readFieldID() throws IOException;

    private final Fields readFields() throws IOException {
        Fields fields = new Fields(this.yggdrasil);
        int numFields = this.readNumFields();
        int i = 0;
        while (i < numFields) {
            String id = this.readFieldID();
            Tag t = this.readTag();
            if (t.isPrimitive()) {
                fields.putPrimitive(id, this.readPrimitive(t));
            } else {
                fields.putObject(id, this.readObject(t));
            }
            ++i;
        }
        return fields;
    }

    @Nullable
    public final Object readObject() throws IOException {
        Tag t = this.readTag();
        return this.readObject(t);
    }

    @Nullable
    public final <T> T readObject(Class<T> expectedType) throws IOException {
        Tag t = this.readTag();
        Object o = this.readObject(t);
        if (o != null && !expectedType.isInstance(o)) {
            throw new StreamCorruptedException("Object " + o + " is of " + o.getClass() + " but expected " + expectedType);
        }
        return (T)o;
    }

    @Nullable
    private final Object readObject(Tag t) throws IOException {
        Object o;
        if (t == Tag.T_NULL) {
            return null;
        }
        if (t == Tag.T_REFERENCE) {
            int ref = this.readReference();
            if (ref < 0 || ref >= this.readObjects.size()) {
                throw new StreamCorruptedException("Invalid reference " + ref + ", " + this.readObjects.size() + " object(s) read so far");
            }
            Object o2 = this.readObjects.get(ref);
            if (o2 == null) {
                throw new StreamCorruptedException("Reference to uninstantiable object: " + ref);
            }
            return o2;
        }
        switch (t) {
            case T_ARRAY: {
                Class<?> c = this.readArrayComponentType();
                Object o3 = Array.newInstance(c, this.readArrayLength());
                assert (o3 != null);
                this.readObjects.add(o3);
                this.readArrayContents(o3);
                return o3;
            }
            case T_CLASS: {
                o = this.readClass();
                break;
            }
            case T_ENUM: {
                o = this.readEnum();
                break;
            }
            case T_STRING: {
                o = this.readString();
                break;
            }
            case T_OBJECT: {
                Object o4;
                Class<?> c = this.readObjectType();
                YggdrasilSerializer<?> s = this.yggdrasil.getSerializer(c);
                if (s != null && !s.canBeInstantiated(c)) {
                    int ref = this.readObjects.size();
                    this.readObjects.add(null);
                    Fields fields = this.readFields();
                    o4 = s.deserialize(c, fields);
                    if (o4 == null) {
                        throw new YggdrasilException("YggdrasilSerializer " + s + " returned null from deserialize(" + c + "," + fields + ")");
                    }
                    this.readObjects.set(ref, o4);
                } else {
                    o4 = this.yggdrasil.newInstance(c);
                    if (o4 == null) {
                        throw new StreamCorruptedException();
                    }
                    this.readObjects.add(o4);
                    Fields fields = this.readFields();
                    if (s != null) {
                        s.deserialize(o4, fields);
                    } else if (o4 instanceof YggdrasilSerializable.YggdrasilExtendedSerializable) {
                        ((YggdrasilSerializable.YggdrasilExtendedSerializable)o4).deserialize(fields);
                    } else {
                        fields.setFields(o4);
                    }
                }
                return o4;
            }
            case T_BYTE_OBJ: 
            case T_SHORT_OBJ: 
            case T_INT_OBJ: 
            case T_LONG_OBJ: 
            case T_FLOAT_OBJ: 
            case T_DOUBLE_OBJ: 
            case T_CHAR_OBJ: 
            case T_BOOLEAN_OBJ: {
                Tag p = t.getPrimitive();
                assert (p != null);
                o = this.readPrimitive(p);
                break;
            }
            case T_BYTE: 
            case T_SHORT: 
            case T_INT: 
            case T_LONG: 
            case T_FLOAT: 
            case T_DOUBLE: 
            case T_CHAR: 
            case T_BOOLEAN: {
                throw new StreamCorruptedException();
            }
            default: {
                assert (false);
                throw new StreamCorruptedException();
            }
        }
        this.readObjects.add(o);
        return o;
    }
}

