/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.timings;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.localization.Language;
import ch.njol.skript.timings.Timing;
import ch.njol.skript.timings.Timings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;

public class TimingReporter {
    public static String getReport() {
        Map<Object, Timing> timings = Timings.timings;
        HashMap<String, Long> triggers = new HashMap<String, Long>();
        HashMap<Object, Long> events = new HashMap<Object, Long>();
        for (Map.Entry<Object, Timing> entry : timings.entrySet()) {
            Object key = entry.getKey();
            Timing val = entry.getValue();
            for (Map.Entry<Trigger, Long> trigger : val.getTriggerTimes().entrySet()) {
                String name = trigger.getKey().getName();
                long tt = 0L;
                if (triggers.containsKey(name)) {
                    tt = (Long)triggers.get(name);
                }
                triggers.put(name, tt += trigger.getValue().longValue());
            }
            long evtTime = 0L;
            if (events.containsKey(key)) {
                evtTime = (Long)events.get(key);
            }
            events.put(key, evtTime += val.getEventTime());
        }
        long length = Timings.disableTime - Timings.enableTime;
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(String.format(Language.get("timings.start"), Float.valueOf((float)length / 1.0E9f))) + "\n");
        sb.append(String.valueOf(Language.get("timings.triggers")) + "\n");
        for (Map.Entry trigger : triggers.entrySet()) {
            float percent = (float)((Long)trigger.getValue()).longValue() / (float)length * 100.0f;
            sb.append(String.valueOf((String)trigger.getKey()) + ": " + (float)((Long)trigger.getValue()).longValue() / 1000000.0f + "ms (" + percent + "%)\n");
        }
        sb.append(String.valueOf(Language.get("timings.events")) + "\n");
        for (Map.Entry event : events.entrySet()) {
            float percent = (float)((Long)event.getValue()).longValue() / (float)length * 100.0f;
            sb.append(event.getKey() + ": " + (float)((Long)event.getValue()).longValue() / 1000000.0f + "ms (" + percent + "%)\n");
        }
        return sb.toString();
    }

    public static void saveToFile(String str) {
        File folder = Skript.getInstance().getDataFolder();
        File file = new File(folder + "/timings-" + DateFormat.getTimeInstance().format(System.currentTimeMillis()) + ".log");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return;
            }
        }
        try {
            PrintWriter out = new PrintWriter(file);
            out.write(str);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

