/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.Function;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.lang.function.Signature;
import ch.njol.skript.lang.function.Unknown;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

public class FunctionReference<T> {
    final String functionName;
    @Nullable
    private Function<? extends T> function;
    @Nullable
    private Signature<? extends T> signature;
    private boolean singleUberParam;
    private final Expression<?>[] parameters;
    private boolean single;
    @Nullable
    private final Class<? extends T>[] returnTypes;
    @Nullable
    private final Node node;
    @Nullable
    public final File script;

    public FunctionReference(String functionName, @Nullable Node node, @Nullable File script, @Nullable Class<? extends T>[] returnTypes, Expression<?>[] params) {
        this.functionName = functionName;
        this.node = node;
        this.script = script;
        this.returnTypes = returnTypes;
        this.parameters = params;
    }

    public boolean validateFunction(boolean first) {
        Signature<?> sign = Functions.getSignature(this.functionName);
        Function<?> newFunc = Functions.getFunction(this.functionName);
        SkriptLogger.setNode(this.node);
        if (sign == null) {
            if (first) {
                Skript.error("The function '" + this.functionName + "' does not exist.");
            } else {
                Skript.error("The function '" + this.functionName + "' was deleted or renamed, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
            }
            return false;
        }
        if (newFunc == this.function) {
            return true;
        }
        Class<? extends T>[] returnTypes = this.returnTypes;
        if (returnTypes != null) {
            ClassInfo rt = sign.returnType;
            if (rt == null) {
                if (first) {
                    Skript.error("The function '" + this.functionName + "' doesn't return any value.");
                } else {
                    Skript.error("The function '" + this.functionName + "' was redefined with no return value, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                }
                return false;
            }
            if (!CollectionUtils.containsAnySuperclass(returnTypes, rt.getC())) {
                if (first) {
                    Skript.error("The returned value of the function '" + this.functionName + "', " + sign.returnType + ", is " + SkriptParser.notOfType(returnTypes) + ".");
                } else {
                    Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible return type, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                }
                return false;
            }
            if (first) {
                this.single = sign.single;
            } else if (this.single && !sign.single) {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible return type, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                return false;
            }
        }
        boolean bl = this.singleUberParam = sign.getMaxParameters() == 1 && !sign.getParameter((int)0).single;
        if (!this.singleUberParam && this.parameters.length > sign.getMaxParameters()) {
            if (first) {
                if (sign.getMaxParameters() == 0) {
                    Skript.error("The function '" + this.functionName + "' has no arguments, but " + this.parameters.length + " are given." + " To call a function without parameters, just write the function name followed by '()', e.g. 'func()'.");
                } else {
                    Skript.error("The function '" + this.functionName + "' has only " + sign.getMaxParameters() + " argument" + (sign.getMaxParameters() == 1 ? "" : "s") + "," + " but " + this.parameters.length + " are given." + " If you want to use lists in function calls, you have to use additional parentheses, e.g. 'give(player, (iron ore and gold ore))'");
                }
            } else {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible amount of arguments, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
            }
            return false;
        }
        if (this.parameters.length < sign.getMinParameters()) {
            if (first) {
                Skript.error("The function '" + this.functionName + "' requires at least " + sign.getMinParameters() + " argument" + (sign.getMinParameters() == 1 ? "" : "s") + "," + " but only " + this.parameters.length + " " + (this.parameters.length == 1 ? "is" : "are") + " given.");
            } else {
                Skript.error("The function '" + this.functionName + "' was redefined with a different, incompatible amount of arguments, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
            }
            return false;
        }
        int i = 0;
        while (i < this.parameters.length) {
            Parameter<?> p = sign.parameters.get(this.singleUberParam ? 0 : i);
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                Expression e = this.parameters[i].getConvertedExpression(p.type.getC());
                if (e == null) {
                    if (first) {
                        Skript.error("The " + StringUtils.fancyOrderNumber(i + 1) + " argument given to the function '" + this.functionName + "' is not of the required type " + p.type + "." + " Check the correct order of the arguments and put lists into parentheses if appropriate (e.g. 'give(player, (iron ore and gold ore))')." + " Please note that storing the value in a variable and then using that variable as parameter will suppress this error, but it still won't work.");
                    } else {
                        Skript.error("The function '" + this.functionName + "' was redefined with different, incompatible arguments, but is still used in other script(s)." + " These will continue to use the old version of the function until Skript restarts.");
                    }
                    return false;
                }
                this.parameters[i] = e;
            }
            finally {
                log.printLog();
            }
            ++i;
        }
        this.signature = sign;
        this.function = newFunc;
        Functions.registerCaller(this);
        return true;
    }

    @Nullable
    protected T[] execute(Event e) {
        if (this.function == null) {
            this.function = Functions.getFunction(this.functionName);
        }
        Object[][] params = new Object[this.singleUberParam ? 1 : this.parameters.length][];
        if (this.singleUberParam && this.parameters.length > 1) {
            ArrayList l = new ArrayList();
            int i = 0;
            while (i < params.length) {
                l.addAll(Arrays.asList(this.parameters[i].getArray(e)));
                ++i;
            }
            params[0] = l.toArray();
        } else {
            int i = 0;
            while (i < params.length) {
                params[i] = this.parameters[i].getArray(e);
                ++i;
            }
        }
        assert (this.function != null);
        return this.function.execute(params);
    }

    public boolean isSingle() {
        return this.single;
    }

    public Class<? extends T> getReturnType() {
        if (this.signature == null) {
            throw new SkriptAPIException("Signature of function is null when return type is asked!");
        }
        assert (this.signature != null);
        ClassInfo ret = this.signature.returnType;
        return ret == null ? Unknown.class : ret.getC();
    }

    public String toString(@Nullable Event e, boolean debug) {
        StringBuilder b = new StringBuilder(String.valueOf(this.functionName) + "(");
        int i = 0;
        while (i < this.parameters.length) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(this.parameters[i].toString(e, debug));
            ++i;
        }
        return "" + b.append(")");
    }
}

