/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.PotionEffectUtils;
import ch.njol.util.Kleenean;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Potion (item)")
@Description(value={"Potion in item form, with advanced parameters."})
@Examples(value={"strong splash potion of instant damage"})
@Since(value="unknown (2.2)")
public class ExprPotionItem
extends SimpleExpression<ItemType> {
    public static final String POTION_MODS = "[(0\u00a6(regular|normal)|1\u00a6(strong|upgraded|level 2)|2\u00a6(extended|long)) ][(20\u00a6(splash|exploding)|40\u00a6lingering) ]";
    @Nullable
    private Expression<PotionEffectType> type;
    private int mod = 0;
    private int usage = 0;
    private boolean water = false;
    private boolean matchAll = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        boolean bl = $assertionsDisabled = !ExprPotionItem.class.desiredAssertionStatus();
        if (Skript.classExists("org.bukkit.potion.PotionData")) {
            Skript.registerExpression(ExprPotionItem.class, ItemType.class, ExpressionType.SIMPLE, "[(0\u00a6(regular|normal)|1\u00a6(strong|upgraded|level 2)|2\u00a6(extended|long)) ][(20\u00a6(splash|exploding)|40\u00a6lingering) ]potion of %potioneffecttype%", "[(0\u00a6(regular|normal)|1\u00a6(strong|upgraded|level 2)|2\u00a6(extended|long)) ][(20\u00a6(splash|exploding)|40\u00a6lingering) ]%potioneffecttype% potion", "(water bottle|bottle of water)", "potion");
        }
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (matchedPattern == 2) {
            this.water = true;
            return true;
        }
        if (matchedPattern == 3) {
            this.water = true;
            this.matchAll = true;
            return true;
        }
        this.type = exprs[0];
        this.mod = parseResult.mark;
        if (parseResult.mark >= 20) {
            this.usage = 1;
            this.mod = parseResult.mark - 20;
        }
        if (parseResult.mark >= 40) {
            this.usage = 2;
            this.mod = parseResult.mark - 40;
        }
        return exprs.length != 0;
    }

    @Nullable
    protected ItemType[] get(Event e) {
        Material mat = Material.POTION;
        if (this.usage == 1) {
            mat = Material.SPLASH_POTION;
        }
        if (this.usage == 2) {
            mat = Material.LINGERING_POTION;
        }
        ItemStack item = new ItemStack(mat);
        PotionData potion = this.water ? new PotionData(PotionType.WATER) : new PotionData(PotionEffectUtils.effectToType(this.type.getSingle(e)), this.mod == 2, this.mod == 1);
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        meta.setBasePotionData(potion);
        item.setItemMeta((ItemMeta)meta);
        ItemType it = new ItemType(item);
        if (this.matchAll) {
            it.setIgnoreMeta(true);
        }
        return new ItemType[]{it};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends ItemType> getReturnType() {
        return ItemType.class;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        if (e == null || this.type == null) {
            return "bottle of water";
        }
        if (!$assertionsDisabled && this.type == null) {
            throw new AssertionError();
        }
        return PotionEffectUtils.getPotionName(this.type.getSingle(e), this.mod == 2, this.mod == 1);
    }
}

