/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.classes.data;

import ch.njol.skript.Skript;
import ch.njol.skript.command.CommandEvent;
import ch.njol.skript.events.EvtMoveOn;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.BlockStateBlock;
import ch.njol.skript.util.BlockUtils;
import ch.njol.skript.util.DelayedChangeBlock;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.InventorySlot;
import ch.njol.skript.util.Slot;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.event.vehicle.VehicleEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.WeatherEvent;
import org.bukkit.event.world.ChunkEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public final class BukkitEventValues {
    protected static final boolean offHandSupport = Skript.isRunningMinecraft(1, 9);

    static {
        EventValues.registerEventValue(WorldEvent.class, World.class, new Getter<World, WorldEvent>(){

            @Override
            @Nullable
            public World get(WorldEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block.class, new Getter<Block, StructureGrowEvent>(){

            @Override
            @Nullable
            public Block get(StructureGrowEvent e) {
                return e.getLocation().getBlock();
            }
        }, 0);
        EventValues.registerEventValue(StructureGrowEvent.class, Block.class, new Getter<Block, StructureGrowEvent>(){

            @Override
            @Nullable
            public Block get(StructureGrowEvent e) {
                for (BlockState bs : e.getBlocks()) {
                    if (!bs.getLocation().equals((Object)e.getLocation())) continue;
                    return new BlockStateBlock(bs);
                }
                return e.getLocation().getBlock();
            }
        }, 1);
        EventValues.registerEventValue(WeatherEvent.class, World.class, new Getter<World, WeatherEvent>(){

            @Override
            @Nullable
            public World get(WeatherEvent e) {
                return e.getWorld();
            }
        }, 0);
        EventValues.registerEventValue(ChunkEvent.class, Chunk.class, new Getter<Chunk, ChunkEvent>(){

            @Override
            @Nullable
            public Chunk get(ChunkEvent e) {
                return e.getChunk();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, Block.class, new Getter<Block, BlockEvent>(){

            @Override
            @Nullable
            public Block get(BlockEvent e) {
                return e.getBlock();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, World.class, new Getter<World, BlockEvent>(){

            @Override
            @Nullable
            public World get(BlockEvent e) {
                return e.getBlock().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(BlockEvent.class, Location.class, new Getter<Location, BlockEvent>(){

            @Override
            @Nullable
            public Location get(BlockEvent e) {
                return BlockUtils.getLocation(e.getBlock());
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, Player.class, new Getter<Player, BlockPlaceEvent>(){

            @Override
            @Nullable
            public Player get(BlockPlaceEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockPlaceEvent.class, Block.class, new Getter<Block, BlockPlaceEvent>(){

            @Override
            public Block get(BlockPlaceEvent e) {
                return new BlockStateBlock(e.getBlockReplacedState());
            }
        }, -1);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            @Nullable
            public Block get(BlockFadeEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new DelayedChangeBlock(e.getBlock(), e.getNewState());
            }
        }, 0);
        EventValues.registerEventValue(BlockFadeEvent.class, Block.class, new Getter<Block, BlockFadeEvent>(){

            @Override
            public Block get(BlockFadeEvent e) {
                return new BlockStateBlock(e.getNewState());
            }
        }, 1);
        EventValues.registerEventValue(BlockFormEvent.class, Block.class, new Getter<Block, BlockFormEvent>(){

            @Override
            @Nullable
            public Block get(BlockFormEvent e) {
                if (e instanceof BlockSpreadEvent) {
                    return e.getBlock();
                }
                return new BlockStateBlock(e.getNewState());
            }
        }, 0);
        EventValues.registerEventValue(BlockFormEvent.class, Block.class, new Getter<Block, BlockFormEvent>(){

            @Override
            @Nullable
            public Block get(BlockFormEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockDamageEvent.class, Player.class, new Getter<Player, BlockDamageEvent>(){

            @Override
            @Nullable
            public Player get(BlockDamageEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Player.class, new Getter<Player, BlockBreakEvent>(){

            @Override
            @Nullable
            public Player get(BlockBreakEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            @Nullable
            public Block get(BlockBreakEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                return new DelayedChangeBlock(e.getBlock());
            }
        }, 0);
        EventValues.registerEventValue(BlockBreakEvent.class, Block.class, new Getter<Block, BlockBreakEvent>(){

            @Override
            public Block get(BlockBreakEvent e) {
                BlockState s;
                s.setType((s = e.getBlock().getState()).getType() == Material.ICE ? Material.STATIONARY_WATER : Material.AIR);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        EventValues.registerEventValue(BlockFromToEvent.class, Block.class, new Getter<Block, BlockFromToEvent>(){

            @Override
            @Nullable
            public Block get(BlockFromToEvent e) {
                return e.getToBlock();
            }
        }, 1);
        EventValues.registerEventValue(BlockIgniteEvent.class, Player.class, new Getter<Player, BlockIgniteEvent>(){

            @Override
            @Nullable
            public Player get(BlockIgniteEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockDispenseEvent.class, ItemStack.class, new Getter<ItemStack, BlockDispenseEvent>(){

            @Override
            @Nullable
            public ItemStack get(BlockDispenseEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(BlockCanBuildEvent.class, Block.class, new Getter<Block, BlockCanBuildEvent>(){

            @Override
            @Nullable
            public Block get(BlockCanBuildEvent e) {
                return e.getBlock();
            }
        }, -1);
        EventValues.registerEventValue(BlockCanBuildEvent.class, Block.class, new Getter<Block, BlockCanBuildEvent>(){

            @Override
            public Block get(BlockCanBuildEvent e) {
                BlockState s = e.getBlock().getState();
                s.setTypeId(e.getMaterialId());
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 0);
        EventValues.registerEventValue(SignChangeEvent.class, Player.class, new Getter<Player, SignChangeEvent>(){

            @Override
            @Nullable
            public Player get(SignChangeEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(BlockGrowEvent.class, Block.class, new Getter<Block, BlockGrowEvent>(){

            @Override
            @Nullable
            public Block get(BlockGrowEvent e) {
                return new BlockStateBlock(e.getBlock().getState(), true);
            }
        }, 0);
        EventValues.registerEventValue(EntityEvent.class, Entity.class, new Getter<Entity, EntityEvent>(){

            @Override
            @Nullable
            public Entity get(EntityEvent e) {
                return e.getEntity();
            }
        }, 0, "Use 'attacker' and/or 'victim' in damage events", EntityDamageEvent.class);
        EventValues.registerEventValue(EntityEvent.class, World.class, new Getter<World, EntityEvent>(){

            @Override
            @Nullable
            public World get(EntityEvent e) {
                return e.getEntity() == null ? null : e.getEntity().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(EntityDamageEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDamageEvent>(){

            @Override
            @Nullable
            public EntityDamageEvent.DamageCause get(EntityDamageEvent e) {
                return e.getCause();
            }
        }, 0);
        EventValues.registerEventValue(EntityDamageByEntityEvent.class, Projectile.class, new Getter<Projectile, EntityDamageByEntityEvent>(){

            @Override
            @Nullable
            public Projectile get(EntityDamageByEntityEvent e) {
                if (e.getDamager() instanceof Projectile) {
                    return (Projectile)e.getDamager();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, Projectile.class, new Getter<Projectile, EntityDeathEvent>(){

            @Override
            @Nullable
            public Projectile get(EntityDeathEvent e) {
                EntityDamageEvent ldc = e.getEntity().getLastDamageCause();
                if (ldc instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)ldc).getDamager() instanceof Projectile) {
                    return (Projectile)((EntityDamageByEntityEvent)ldc).getDamager();
                }
                return null;
            }
        }, 0);
        EventValues.registerEventValue(EntityDeathEvent.class, EntityDamageEvent.DamageCause.class, new Getter<EntityDamageEvent.DamageCause, EntityDeathEvent>(){

            @Override
            @Nullable
            public EntityDamageEvent.DamageCause get(EntityDeathEvent e) {
                EntityDamageEvent ldc = e.getEntity().getLastDamageCause();
                return ldc == null ? null : ldc.getCause();
            }
        }, 0);
        EventValues.registerEventValue(ProjectileHitEvent.class, Entity.class, new Getter<Entity, ProjectileHitEvent>(){

            @Override
            @Nullable
            public Entity get(ProjectileHitEvent e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return e.getEntity();
            }
        }, 0, "Use 'projectile' and/or 'shooter' in projectile hit events", ProjectileHitEvent.class);
        EventValues.registerEventValue(ProjectileHitEvent.class, Projectile.class, new Getter<Projectile, ProjectileHitEvent>(){

            @Override
            @Nullable
            public Projectile get(ProjectileHitEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(ProjectileLaunchEvent.class, Entity.class, new Getter<Entity, ProjectileLaunchEvent>(){

            @Override
            @Nullable
            public Entity get(ProjectileLaunchEvent e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return e.getEntity();
            }
        }, 0, "Use 'projectile' and/or 'shooter' in shoot events", ProjectileLaunchEvent.class);
        EventValues.registerEventValue(ProjectileLaunchEvent.class, Projectile.class, new Getter<Projectile, ProjectileLaunchEvent>(){

            @Override
            @Nullable
            public Projectile get(ProjectileLaunchEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(EntityTameEvent.class, Player.class, new Getter<Player, EntityTameEvent>(){

            @Override
            @Nullable
            public Player get(EntityTameEvent e) {
                return e.getOwner() instanceof Player ? (Player)e.getOwner() : null;
            }
        }, 0);
        EventValues.registerEventValue(EntityChangeBlockEvent.class, Block.class, new Getter<Block, EntityChangeBlockEvent>(){

            @Override
            @Nullable
            public Block get(EntityChangeBlockEvent e) {
                return e.getBlock();
            }
        }, 0);
        EventValues.registerEventValue(PlayerEvent.class, Player.class, new Getter<Player, PlayerEvent>(){

            @Override
            @Nullable
            public Player get(PlayerEvent e) {
                return e.getPlayer();
            }
        }, 0);
        EventValues.registerEventValue(PlayerEvent.class, World.class, new Getter<World, PlayerEvent>(){

            @Override
            @Nullable
            public World get(PlayerEvent e) {
                return e.getPlayer().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBedEnterEvent.class, Block.class, new Getter<Block, PlayerBedEnterEvent>(){

            @Override
            @Nullable
            public Block get(PlayerBedEnterEvent e) {
                return e.getBed();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBedLeaveEvent.class, Block.class, new Getter<Block, PlayerBedLeaveEvent>(){

            @Override
            @Nullable
            public Block get(PlayerBedLeaveEvent e) {
                return e.getBed();
            }
        }, 0);
        EventValues.registerEventValue(PlayerBucketFillEvent.class, Block.class, new Getter<Block, PlayerBucketFillEvent>(){

            @Override
            @Nullable
            public Block get(PlayerBucketFillEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, 0);
        EventValues.registerEventValue(PlayerBucketFillEvent.class, Block.class, new Getter<Block, PlayerBucketFillEvent>(){

            @Override
            @Nullable
            public Block get(PlayerBucketFillEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setTypeId(0);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 1);
        EventValues.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new Getter<Block, PlayerBucketEmptyEvent>(){

            @Override
            @Nullable
            public Block get(PlayerBucketEmptyEvent e) {
                return e.getBlockClicked().getRelative(e.getBlockFace());
            }
        }, -1);
        EventValues.registerEventValue(PlayerBucketEmptyEvent.class, Block.class, new Getter<Block, PlayerBucketEmptyEvent>(){

            @Override
            public Block get(PlayerBucketEmptyEvent e) {
                BlockState s = e.getBlockClicked().getRelative(e.getBlockFace()).getState();
                s.setType(e.getBucket() == Material.WATER_BUCKET ? Material.STATIONARY_WATER : Material.STATIONARY_LAVA);
                s.setRawData((byte)0);
                return new BlockStateBlock(s, true);
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, Item.class, new Getter<Item, PlayerDropItemEvent>(){

            @Override
            @Nullable
            public Item get(PlayerDropItemEvent e) {
                return e.getItemDrop();
            }
        }, 0);
        EventValues.registerEventValue(PlayerDropItemEvent.class, ItemStack.class, new Getter<ItemStack, PlayerDropItemEvent>(){

            @Override
            @Nullable
            public ItemStack get(PlayerDropItemEvent e) {
                return e.getItemDrop().getItemStack();
            }
        }, 0);
        EventValues.registerEventValue(PlayerPickupItemEvent.class, Item.class, new Getter<Item, PlayerPickupItemEvent>(){

            @Override
            @Nullable
            public Item get(PlayerPickupItemEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerPickupItemEvent.class, ItemStack.class, new Getter<ItemStack, PlayerPickupItemEvent>(){

            @Override
            @Nullable
            public ItemStack get(PlayerPickupItemEvent e) {
                return e.getItem().getItemStack();
            }
        }, 0);
        if (Skript.supports("org.bukkit.event.player.PlayerItemConsumeEvent")) {
            EventValues.registerEventValue(PlayerItemConsumeEvent.class, ItemStack.class, new Getter<ItemStack, PlayerItemConsumeEvent>(){

                @Override
                @Nullable
                public ItemStack get(PlayerItemConsumeEvent e) {
                    return e.getItem();
                }
            }, 0);
        }
        if (Skript.supports("org.bukkit.event.player.PlayerItemBreakEvent")) {
            EventValues.registerEventValue(PlayerItemBreakEvent.class, ItemStack.class, new Getter<ItemStack, PlayerItemBreakEvent>(){

                @Override
                @Nullable
                public ItemStack get(PlayerItemBreakEvent e) {
                    return e.getBrokenItem();
                }
            }, 0);
        }
        EventValues.registerEventValue(PlayerInteractEntityEvent.class, Entity.class, new Getter<Entity, PlayerInteractEntityEvent>(){

            @Override
            @Nullable
            public Entity get(PlayerInteractEntityEvent e) {
                return e.getRightClicked();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEntityEvent.class, ItemStack.class, new Getter<ItemStack, PlayerInteractEntityEvent>(){

            @Override
            @Nullable
            public ItemStack get(PlayerInteractEntityEvent e) {
                if (offHandSupport) {
                    EquipmentSlot hand = e.getHand();
                    if (hand == EquipmentSlot.HAND) {
                        return e.getPlayer().getInventory().getItemInMainHand();
                    }
                    if (hand == EquipmentSlot.OFF_HAND) {
                        return e.getPlayer().getInventory().getItemInOffHand();
                    }
                    return null;
                }
                return e.getPlayer().getItemInHand();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEvent.class, Block.class, new Getter<Block, PlayerInteractEvent>(){

            @Override
            @Nullable
            public Block get(PlayerInteractEvent e) {
                return e.getClickedBlock();
            }
        }, 0);
        EventValues.registerEventValue(PlayerInteractEvent.class, ItemStack.class, new Getter<ItemStack, PlayerInteractEvent>(){

            @Override
            @Nullable
            public ItemStack get(PlayerInteractEvent e) {
                return e.getItem();
            }
        }, 0);
        EventValues.registerEventValue(PlayerShearEntityEvent.class, Entity.class, new Getter<Entity, PlayerShearEntityEvent>(){

            @Override
            @Nullable
            public Entity get(PlayerShearEntityEvent e) {
                return e.getEntity();
            }
        }, 0);
        EventValues.registerEventValue(PlayerMoveEvent.class, Block.class, new Getter<Block, PlayerMoveEvent>(){

            @Override
            @Nullable
            public Block get(PlayerMoveEvent e) {
                return EvtMoveOn.getBlock(e);
            }
        }, 0);
        if (Skript.classExists("org.bukkit.event.hanging.HangingEvent")) {
            EventValues.registerEventValue(HangingEvent.class, Hanging.class, new Getter<Hanging, HangingEvent>(){

                @Override
                @Nullable
                public Hanging get(HangingEvent e) {
                    return e.getEntity();
                }
            }, 0);
            EventValues.registerEventValue(HangingEvent.class, World.class, new Getter<World, HangingEvent>(){

                @Override
                @Nullable
                public World get(HangingEvent e) {
                    return e.getEntity().getWorld();
                }
            }, 0);
            EventValues.registerEventValue(HangingEvent.class, Location.class, new Getter<Location, HangingEvent>(){

                @Override
                @Nullable
                public Location get(HangingEvent e) {
                    return e.getEntity().getLocation();
                }
            }, 0);
            EventValues.registerEventValue(HangingPlaceEvent.class, Player.class, new Getter<Player, HangingPlaceEvent>(){

                @Override
                @Nullable
                public Player get(HangingPlaceEvent e) {
                    return e.getPlayer();
                }
            }, 0);
        }
        EventValues.registerEventValue(VehicleEvent.class, Vehicle.class, new Getter<Vehicle, VehicleEvent>(){

            @Override
            @Nullable
            public Vehicle get(VehicleEvent e) {
                return e.getVehicle();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, World.class, new Getter<World, VehicleEvent>(){

            @Override
            @Nullable
            public World get(VehicleEvent e) {
                return e.getVehicle().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(VehicleExitEvent.class, LivingEntity.class, new Getter<LivingEntity, VehicleExitEvent>(){

            @Override
            @Nullable
            public LivingEntity get(VehicleExitEvent e) {
                return e.getExited();
            }
        }, 0);
        EventValues.registerEventValue(VehicleEvent.class, Entity.class, new Getter<Entity, VehicleEvent>(){

            @Override
            @Nullable
            public Entity get(VehicleEvent e) {
                return e.getVehicle().getPassenger();
            }
        }, 0);
        EventValues.registerEventValue(ServerCommandEvent.class, CommandSender.class, new Getter<CommandSender, ServerCommandEvent>(){

            @Override
            @Nullable
            public CommandSender get(ServerCommandEvent e) {
                return e.getSender();
            }
        }, 0);
        EventValues.registerEventValue(CommandEvent.class, CommandSender.class, new Getter<CommandSender, CommandEvent>(){

            @Override
            public CommandSender get(CommandEvent e) {
                return e.getSender();
            }
        }, 0);
        EventValues.registerEventValue(CommandEvent.class, World.class, new Getter<World, CommandEvent>(){

            @Override
            @Nullable
            public World get(CommandEvent e) {
                return e.getSender() instanceof Player ? ((Player)e.getSender()).getWorld() : null;
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, Player.class, new Getter<Player, InventoryClickEvent>(){

            @Override
            @Nullable
            public Player get(InventoryClickEvent e) {
                return e.getWhoClicked() instanceof Player ? (Player)e.getWhoClicked() : null;
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, World.class, new Getter<World, InventoryClickEvent>(){

            @Override
            @Nullable
            public World get(InventoryClickEvent e) {
                return e.getWhoClicked().getWorld();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, ItemStack.class, new Getter<ItemStack, InventoryClickEvent>(){

            @Override
            @Nullable
            public ItemStack get(InventoryClickEvent e) {
                if (e instanceof CraftItemEvent) {
                    return ((CraftItemEvent)e).getRecipe().getResult();
                }
                return e.getCurrentItem();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, Slot.class, new Getter<Slot, InventoryClickEvent>(){

            @Override
            @Nullable
            public Slot get(InventoryClickEvent e) {
                return new InventorySlot(e.getInventory(), e.getSlot());
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, InventoryAction.class, new Getter<InventoryAction, InventoryClickEvent>(){

            @Override
            @Nullable
            public InventoryAction get(InventoryClickEvent e) {
                return e.getAction();
            }
        }, 0);
        EventValues.registerEventValue(InventoryClickEvent.class, ClickType.class, new Getter<ClickType, InventoryClickEvent>(){

            @Override
            @Nullable
            public ClickType get(InventoryClickEvent e) {
                return e.getClick();
            }
        }, 0);
        EventValues.registerEventValue(PrepareItemCraftEvent.class, Slot.class, new Getter<Slot, PrepareItemCraftEvent>(){

            @Override
            @Nullable
            public Slot get(PrepareItemCraftEvent e) {
                return new InventorySlot((Inventory)e.getInventory(), 9);
            }
        }, 0);
    }
}

