/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.bukkitutil;

import ch.njol.skript.Skript;
import ch.njol.util.Math2;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;

public abstract class HealthUtils {
    private static final boolean supportsDoubles = Skript.methodExists(Damageable.class, "setHealth", Double.TYPE);
    private static Method getHealth;
    private static Method setHealth;
    private static Method getMaxHealth;
    private static Method setMaxHealth;
    private static Method damage;
    private static Method getDamage;
    private static Method setDamage;

    static {
        if (!supportsDoubles) {
            try {
                getHealth = Damageable.class.getDeclaredMethod("getHealth", new Class[0]);
                setHealth = Damageable.class.getDeclaredMethod("setHealth", Integer.TYPE);
                getMaxHealth = Damageable.class.getDeclaredMethod("getMaxHealth", new Class[0]);
                setMaxHealth = Damageable.class.getDeclaredMethod("setMaxHealth", Integer.TYPE);
                damage = Damageable.class.getDeclaredMethod("damage", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                Skript.outdatedError(e);
            }
            catch (SecurityException e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
        if (!supportsDoubles) {
            try {
                getDamage = EntityDamageEvent.class.getDeclaredMethod("getDamage", new Class[0]);
                setDamage = EntityDamageEvent.class.getDeclaredMethod("setDamage", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                Skript.outdatedError(e);
            }
            catch (SecurityException e) {
                Skript.exception((Throwable)e, new String[0]);
            }
        }
    }

    private HealthUtils() {
    }

    public static final double getHealth(Damageable e) {
        if (e.isDead()) {
            return 0.0;
        }
        if (supportsDoubles) {
            return e.getHealth() / 2.0;
        }
        try {
            return ((Number)getHealth.invoke((Object)e, new Object[0])).doubleValue() / 2.0;
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        return 0.0;
    }

    public static final void setHealth(Damageable e, double health) {
        if (supportsDoubles) {
            e.setHealth(Math2.fit(0.0, health, HealthUtils.getMaxHealth(e)) * 2.0);
            return;
        }
        try {
            setHealth.invoke((Object)e, (int)Math.round(Math2.fit(0.0, health, HealthUtils.getMaxHealth(e)) * 2.0));
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
    }

    public static final double getMaxHealth(Damageable e) {
        if (supportsDoubles) {
            return e.getMaxHealth() / 2.0;
        }
        try {
            return ((Number)getMaxHealth.invoke((Object)e, new Object[0])).doubleValue() / 2.0;
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        return 0.0;
    }

    public static final void setMaxHealth(Damageable e, double health) {
        if (supportsDoubles) {
            e.setMaxHealth(Math.max(5.0E-11, health * 2.0));
            return;
        }
        try {
            setMaxHealth.invoke((Object)e, Math.max(1, (int)Math.round(health * 2.0)));
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
    }

    public static final void damage(Damageable e, double d) {
        if (d < 0.0) {
            HealthUtils.heal(e, -d);
            return;
        }
        if (supportsDoubles) {
            e.damage(d * 2.0);
            return;
        }
        try {
            damage.invoke((Object)e, (int)Math.round(d * 2.0));
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
    }

    public static final void heal(Damageable e, double h) {
        if (h < 0.0) {
            HealthUtils.damage(e, -h);
            return;
        }
        HealthUtils.setHealth(e, Math2.fit(0.0, HealthUtils.getHealth(e) + h, HealthUtils.getMaxHealth(e)));
    }

    public static final double getDamage(EntityDamageEvent e) {
        if (supportsDoubles) {
            return e.getDamage() / 2.0;
        }
        try {
            return ((Number)getDamage.invoke((Object)e, new Object[0])).doubleValue() / 2.0;
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        return 0.0;
    }

    public static final double getFinalDamage(EntityDamageEvent e) {
        if (supportsDoubles) {
            return e.getFinalDamage() / 2.0;
        }
        return 0.0;
    }

    public static final void setDamage(EntityDamageEvent e, double damage) {
        if (supportsDoubles) {
            e.setDamage(damage * 2.0);
            return;
        }
        try {
            setDamage.invoke((Object)e, (int)Math.round(damage * 2.0));
        }
        catch (IllegalAccessException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
        catch (IllegalArgumentException ex) {
            Skript.outdatedError(ex);
        }
        catch (InvocationTargetException ex) {
            Skript.exception((Throwable)ex, new String[0]);
        }
    }

    public static final void setDamageCause(Damageable e, EntityDamageEvent.DamageCause cause) {
        e.setLastDamageCause(new EntityDamageEvent((Entity)e, cause, 0));
    }
}

